/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.os.Looper;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.OptionalPendingResult;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzqe;
import com.google.android.gms.internal.zzrg;
import com.google.android.gms.internal.zzrm;

public final class PendingResults {
    public static PendingResult<Status> immediatePendingResult(Status status) {
        zzac.zzb((Object)status, (Object)"Result must not be null");
        zzrm zzrm2 = new zzrm(Looper.getMainLooper());
        zzrm2.zzc(status);
        return zzrm2;
    }

    public static PendingResult<Status> zza(Status status, GoogleApiClient googleApiClient) {
        zzac.zzb((Object)status, (Object)"Result must not be null");
        zzrm zzrm2 = new zzrm(googleApiClient);
        zzrm2.zzc(status);
        return zzrm2;
    }

    public static <R extends Result> PendingResult<R> zza(R r, GoogleApiClient googleApiClient) {
        zzac.zzb(r, (Object)"Result must not be null");
        zzac.zzb((!r.getStatus().isSuccess() ? 1 : 0) != 0, (Object)"Status code must not be SUCCESS");
        zzb<R> zzb2 = new zzb<R>(googleApiClient, r);
        zzb2.zzc(r);
        return zzb2;
    }

    public static <R extends Result> OptionalPendingResult<R> immediatePendingResult(R r) {
        zzac.zzb(r, (Object)"Result must not be null");
        zzc<R> zzc2 = new zzc<R>(null);
        zzc2.zzc(r);
        return new zzrg(zzc2);
    }

    public static <R extends Result> OptionalPendingResult<R> zzb(R r, GoogleApiClient googleApiClient) {
        zzac.zzb(r, (Object)"Result must not be null");
        zzc<R> zzc2 = new zzc<R>(googleApiClient);
        zzc2.zzc(r);
        return new zzrg(zzc2);
    }

    public static PendingResult<Status> canceledPendingResult() {
        zzrm zzrm2 = new zzrm(Looper.getMainLooper());
        zzrm2.cancel();
        return zzrm2;
    }

    public static <R extends Result> PendingResult<R> canceledPendingResult(R r) {
        zzac.zzb(r, (Object)"Result must not be null");
        zzac.zzb((r.getStatus().getStatusCode() == 16 ? 1 : 0) != 0, (Object)"Status code must be CommonStatusCodes.CANCELED");
        zza<R> zza2 = new zza<R>(r);
        zza2.cancel();
        return zza2;
    }

    private PendingResults() {
    }

    private static final class zza<R extends Result>
    extends zzqe<R> {
        private final R vT;

        public zza(R r) {
            super(Looper.getMainLooper());
            this.vT = r;
        }

        @Override
        protected R zzc(Status status) {
            if (status.getStatusCode() != this.vT.getStatus().getStatusCode()) {
                throw new UnsupportedOperationException("Creating failed results is not supported");
            }
            return this.vT;
        }
    }

    private static final class zzb<R extends Result>
    extends zzqe<R> {
        private final R vU;

        public zzb(GoogleApiClient googleApiClient, R r) {
            super(googleApiClient);
            this.vU = r;
        }

        @Override
        protected R zzc(Status status) {
            return this.vU;
        }
    }

    private static final class zzc<R extends Result>
    extends zzqe<R> {
        public zzc(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        @Override
        protected R zzc(Status status) {
            throw new UnsupportedOperationException("Creating failed results is not supported");
        }
    }
}

