/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.zzac;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;

public final class zzm
implements Handler.Callback {
    private final zza Cs;
    private final ArrayList<GoogleApiClient.ConnectionCallbacks> Ct = new ArrayList();
    final ArrayList<GoogleApiClient.ConnectionCallbacks> Cu = new ArrayList();
    private final ArrayList<GoogleApiClient.OnConnectionFailedListener> Cv = new ArrayList();
    private volatile boolean Cw = false;
    private final AtomicInteger Cx = new AtomicInteger(0);
    private boolean Cy = false;
    private final Handler mHandler;
    private final Object zzakd = new Object();

    public zzm(Looper looper, zza zza2) {
        this.Cs = zza2;
        this.mHandler = new Handler(looper, (Handler.Callback)this);
    }

    public void zzaut() {
        this.Cw = false;
        this.Cx.incrementAndGet();
    }

    public void zzauu() {
        this.Cw = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzp(Bundle bundle) {
        zzac.zza((Looper.myLooper() == this.mHandler.getLooper() ? 1 : 0) != 0, (Object)"onConnectionSuccess must only be called on the Handler thread");
        Object object = this.zzakd;
        synchronized (object) {
            zzac.zzbr((!this.Cy ? 1 : 0) != 0);
            this.mHandler.removeMessages(1);
            this.Cy = true;
            zzac.zzbr((this.Cu.size() == 0 ? 1 : 0) != 0);
            ArrayList<GoogleApiClient.ConnectionCallbacks> arrayList = new ArrayList<GoogleApiClient.ConnectionCallbacks>(this.Ct);
            int n = this.Cx.get();
            for (GoogleApiClient.ConnectionCallbacks connectionCallbacks : arrayList) {
                if (!this.Cw || !this.Cs.isConnected() || this.Cx.get() != n) break;
                if (this.Cu.contains(connectionCallbacks)) continue;
                connectionCallbacks.onConnected(bundle);
            }
            this.Cu.clear();
            this.Cy = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzgo(int n) {
        zzac.zza((Looper.myLooper() == this.mHandler.getLooper() ? 1 : 0) != 0, (Object)"onUnintentionalDisconnection must only be called on the Handler thread");
        this.mHandler.removeMessages(1);
        Object object = this.zzakd;
        synchronized (object) {
            this.Cy = true;
            ArrayList<GoogleApiClient.ConnectionCallbacks> arrayList = new ArrayList<GoogleApiClient.ConnectionCallbacks>(this.Ct);
            int n2 = this.Cx.get();
            for (GoogleApiClient.ConnectionCallbacks connectionCallbacks : arrayList) {
                if (!this.Cw || this.Cx.get() != n2) break;
                if (!this.Ct.contains(connectionCallbacks)) continue;
                connectionCallbacks.onConnectionSuspended(n);
            }
            this.Cu.clear();
            this.Cy = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzn(ConnectionResult connectionResult) {
        zzac.zza((Looper.myLooper() == this.mHandler.getLooper() ? 1 : 0) != 0, (Object)"onConnectionFailure must only be called on the Handler thread");
        this.mHandler.removeMessages(1);
        Object object = this.zzakd;
        synchronized (object) {
            ArrayList<GoogleApiClient.OnConnectionFailedListener> arrayList = new ArrayList<GoogleApiClient.OnConnectionFailedListener>(this.Cv);
            int n = this.Cx.get();
            for (GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener : arrayList) {
                if (!this.Cw || this.Cx.get() != n) {
                    return;
                }
                if (!this.Cv.contains(onConnectionFailedListener)) continue;
                onConnectionFailedListener.onConnectionFailed(connectionResult);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerConnectionCallbacks(GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        zzac.zzy((Object)connectionCallbacks);
        Object object = this.zzakd;
        synchronized (object) {
            if (this.Ct.contains(connectionCallbacks)) {
                String string2 = String.valueOf(connectionCallbacks);
                Log.w((String)"GmsClientEvents", (String)new StringBuilder(62 + String.valueOf(string2).length()).append("registerConnectionCallbacks(): listener ").append(string2).append(" is already registered").toString());
            } else {
                this.Ct.add(connectionCallbacks);
            }
        }
        if (this.Cs.isConnected()) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(1, (Object)connectionCallbacks));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnectionCallbacksRegistered(GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        zzac.zzy((Object)connectionCallbacks);
        Object object = this.zzakd;
        synchronized (object) {
            return this.Ct.contains(connectionCallbacks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterConnectionCallbacks(GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        zzac.zzy((Object)connectionCallbacks);
        Object object = this.zzakd;
        synchronized (object) {
            boolean bl = this.Ct.remove(connectionCallbacks);
            if (!bl) {
                String string2 = String.valueOf(connectionCallbacks);
                Log.w((String)"GmsClientEvents", (String)new StringBuilder(52 + String.valueOf(string2).length()).append("unregisterConnectionCallbacks(): listener ").append(string2).append(" not found").toString());
            } else if (this.Cy) {
                this.Cu.add(connectionCallbacks);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerConnectionFailedListener(GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        zzac.zzy((Object)onConnectionFailedListener);
        Object object = this.zzakd;
        synchronized (object) {
            if (this.Cv.contains(onConnectionFailedListener)) {
                String string2 = String.valueOf(onConnectionFailedListener);
                Log.w((String)"GmsClientEvents", (String)new StringBuilder(67 + String.valueOf(string2).length()).append("registerConnectionFailedListener(): listener ").append(string2).append(" is already registered").toString());
            } else {
                this.Cv.add(onConnectionFailedListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnectionFailedListenerRegistered(GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        zzac.zzy((Object)onConnectionFailedListener);
        Object object = this.zzakd;
        synchronized (object) {
            return this.Cv.contains(onConnectionFailedListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterConnectionFailedListener(GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        zzac.zzy((Object)onConnectionFailedListener);
        Object object = this.zzakd;
        synchronized (object) {
            boolean bl = this.Cv.remove(onConnectionFailedListener);
            if (!bl) {
                String string2 = String.valueOf(onConnectionFailedListener);
                Log.w((String)"GmsClientEvents", (String)new StringBuilder(57 + String.valueOf(string2).length()).append("unregisterConnectionFailedListener(): listener ").append(string2).append(" not found").toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleMessage(Message message) {
        if (message.what == 1) {
            GoogleApiClient.ConnectionCallbacks connectionCallbacks = (GoogleApiClient.ConnectionCallbacks)message.obj;
            Object object = this.zzakd;
            synchronized (object) {
                if (this.Cw && this.Cs.isConnected() && this.Ct.contains(connectionCallbacks)) {
                    Bundle bundle = this.Cs.zzaoe();
                    connectionCallbacks.onConnected(bundle);
                }
            }
            return true;
        }
        int n = message.what;
        Log.wtf((String)"GmsClientEvents", (String)new StringBuilder(45).append("Don't know how to handle message: ").append(n).toString(), (Throwable)new Exception());
        return false;
    }

    public static interface zza {
        public boolean isConnected();

        public Bundle zzaoe();
    }
}

