/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import android.util.Pair;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.ResultTransform;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.TransformedResult;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.internal.zzs;
import com.google.android.gms.internal.zzrp;
import com.google.android.gms.internal.zzrq;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public abstract class zzqe<R extends Result>
extends PendingResult<R> {
    static final ThreadLocal<Boolean> wF = new ThreadLocal<Boolean>(){

        protected Boolean zzaqv() {
            return false;
        }

        @Override
        protected /* synthetic */ Object initialValue() {
            return this.zzaqv();
        }
    };
    private final Object wG = new Object();
    protected final zza<R> wH;
    protected final WeakReference<GoogleApiClient> wI;
    private final CountDownLatch zzamx = new CountDownLatch(1);
    private final ArrayList<PendingResult.zza> wJ = new ArrayList();
    private ResultCallback<? super R> wK;
    private final AtomicReference<zzrq.zzb> wL = new AtomicReference();
    private R vU;
    private zzb wM;
    private volatile boolean wN;
    private boolean zzak;
    private boolean wO;
    private zzs wP;
    private volatile zzrp<R> wQ;
    private boolean wR = false;

    @Deprecated
    zzqe() {
        this.wH = new zza(Looper.getMainLooper());
        this.wI = new WeakReference<Object>(null);
    }

    protected zzqe(GoogleApiClient googleApiClient) {
        Looper looper = googleApiClient != null ? googleApiClient.getLooper() : Looper.getMainLooper();
        this.wH = new zza(looper);
        this.wI = new WeakReference<GoogleApiClient>(googleApiClient);
    }

    @Deprecated
    protected zzqe(Looper looper) {
        this.wH = new zza(looper);
        this.wI = new WeakReference<Object>(null);
    }

    public final boolean isReady() {
        return this.zzamx.getCount() == 0L;
    }

    @Override
    public final R await() {
        zzac.zza((Looper.myLooper() != Looper.getMainLooper() ? 1 : 0) != 0, (Object)"await must not be called on the UI thread");
        zzac.zza((!this.wN ? 1 : 0) != 0, (Object)"Result has already been consumed");
        zzac.zza((this.wQ == null ? 1 : 0) != 0, (Object)"Cannot await if then() has been called.");
        try {
            this.zzamx.await();
        }
        catch (InterruptedException interruptedException) {
            this.zzaa(Status.vZ);
        }
        zzac.zza((boolean)this.isReady(), (Object)"Result is not ready.");
        return this.get();
    }

    @Override
    public final R await(long l, TimeUnit timeUnit) {
        zzac.zza((l <= 0L || Looper.myLooper() != Looper.getMainLooper() ? 1 : 0) != 0, (Object)"await must not be called on the UI thread when time is greater than zero.");
        zzac.zza((!this.wN ? 1 : 0) != 0, (Object)"Result has already been consumed.");
        zzac.zza((this.wQ == null ? 1 : 0) != 0, (Object)"Cannot await if then() has been called.");
        try {
            boolean bl = this.zzamx.await(l, timeUnit);
            if (!bl) {
                this.zzaa(Status.wb);
            }
        }
        catch (InterruptedException interruptedException) {
            this.zzaa(Status.vZ);
        }
        zzac.zza((boolean)this.isReady(), (Object)"Result is not ready.");
        return this.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setResultCallback(ResultCallback<? super R> resultCallback) {
        Object object = this.wG;
        synchronized (object) {
            if (resultCallback == null) {
                this.wK = null;
                return;
            }
            zzac.zza((!this.wN ? 1 : 0) != 0, (Object)"Result has already been consumed.");
            zzac.zza((this.wQ == null ? 1 : 0) != 0, (Object)"Cannot set callbacks if then() has been called.");
            if (this.isCanceled()) {
                return;
            }
            if (this.isReady()) {
                this.wH.zza(resultCallback, (R)this.get());
            } else {
                this.wK = resultCallback;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setResultCallback(ResultCallback<? super R> resultCallback, long l, TimeUnit timeUnit) {
        Object object = this.wG;
        synchronized (object) {
            if (resultCallback == null) {
                this.wK = null;
                return;
            }
            zzac.zza((!this.wN ? 1 : 0) != 0, (Object)"Result has already been consumed.");
            zzac.zza((this.wQ == null ? 1 : 0) != 0, (Object)"Cannot set callbacks if then() has been called.");
            if (this.isCanceled()) {
                return;
            }
            if (this.isReady()) {
                this.wH.zza(resultCallback, (R)this.get());
            } else {
                this.wK = resultCallback;
                this.wH.zza(this, timeUnit.toMillis(l));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zza(PendingResult.zza zza2) {
        zzac.zza((!this.wN ? 1 : 0) != 0, (Object)"Result has already been consumed.");
        zzac.zzb((zza2 != null ? 1 : 0) != 0, (Object)"Callback cannot be null.");
        Object object = this.wG;
        synchronized (object) {
            if (this.isReady()) {
                zza2.zzv(this.vU.getStatus());
            } else {
                this.wJ.add(zza2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        Object object = this.wG;
        synchronized (object) {
            if (this.zzak || this.wN) {
                return;
            }
            if (this.wP != null) {
                try {
                    this.wP.cancel();
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            zzqe.zze(this.vU);
            this.zzak = true;
            this.zzd(this.zzc(Status.wc));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean zzaqq() {
        Object object = this.wG;
        synchronized (object) {
            GoogleApiClient googleApiClient = (GoogleApiClient)this.wI.get();
            if (googleApiClient == null || !this.wR) {
                this.cancel();
            }
            return this.isCanceled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCanceled() {
        Object object = this.wG;
        synchronized (object) {
            return this.zzak;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <S extends Result> TransformedResult<S> then(ResultTransform<? super R, ? extends S> resultTransform) {
        zzac.zza((!this.wN ? 1 : 0) != 0, (Object)"Result has already been consumed.");
        Object object = this.wG;
        synchronized (object) {
            zzac.zza((this.wQ == null ? 1 : 0) != 0, (Object)"Cannot call then() twice.");
            zzac.zza((this.wK == null ? 1 : 0) != 0, (Object)"Cannot call then() if callbacks are set.");
            this.wR = true;
            this.wQ = new zzrp(this.wI);
            TransformedResult<? extends S> transformedResult = this.wQ.then(resultTransform);
            if (this.isReady()) {
                this.wH.zza(this.wQ, this.get());
            } else {
                this.wK = this.wQ;
            }
            return transformedResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzc(R r) {
        Object object = this.wG;
        synchronized (object) {
            if (this.wO || this.zzak || this.isReady() && this.zzaqu()) {
                zzqe.zze(r);
                return;
            }
            zzac.zza((!this.isReady() ? 1 : 0) != 0, (Object)"Results have already been set");
            zzac.zza((!this.wN ? 1 : 0) != 0, (Object)"Result has already been consumed");
            this.zzd(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzaa(Status status) {
        Object object = this.wG;
        synchronized (object) {
            if (!this.isReady()) {
                this.zzc(this.zzc(status));
                this.wO = true;
            }
        }
    }

    protected abstract R zzc(Status var1);

    private void zzaqr() {
        zzrq.zzb zzb2 = this.wL.getAndSet(null);
        if (zzb2 != null) {
            zzb2.zzc(this);
        }
    }

    public void zza(zzrq.zzb zzb2) {
        this.wL.set(zzb2);
    }

    public void zzaqs() {
        this.setResultCallback(null);
    }

    @Override
    public Integer zzaqf() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void zza(zzs zzs2) {
        Object object = this.wG;
        synchronized (object) {
            this.wP = zzs2;
        }
    }

    public void zzaqt() {
        this.wR = this.wR || wF.get() != false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private R get() {
        R r;
        Object object = this.wG;
        synchronized (object) {
            zzac.zza((!this.wN ? 1 : 0) != 0, (Object)"Result has already been consumed.");
            zzac.zza((boolean)this.isReady(), (Object)"Result is not ready.");
            r = this.vU;
            this.vU = null;
            this.wK = null;
            this.wN = true;
        }
        this.zzaqr();
        return r;
    }

    boolean zzaqu() {
        return false;
    }

    private void zzd(R r) {
        this.vU = r;
        this.wP = null;
        this.zzamx.countDown();
        Status status = this.vU.getStatus();
        if (this.zzak) {
            this.wK = null;
        } else if (this.wK == null) {
            if (this.vU instanceof Releasable) {
                this.wM = new zzb();
            }
        } else {
            this.wH.zzaqw();
            this.wH.zza(this.wK, (R)this.get());
        }
        for (PendingResult.zza zza2 : this.wJ) {
            zza2.zzv(status);
        }
        this.wJ.clear();
    }

    public static void zze(Result result) {
        if (result instanceof Releasable) {
            try {
                ((Releasable)result).release();
            }
            catch (RuntimeException runtimeException) {
                String string2 = String.valueOf(result);
                Log.w((String)"BasePendingResult", (String)new StringBuilder(18 + String.valueOf(string2).length()).append("Unable to release ").append(string2).toString(), (Throwable)runtimeException);
            }
        }
    }

    private final class zzb {
        private zzb() {
        }

        protected void finalize() throws Throwable {
            zzqe.zze(zzqe.this.vU);
            super.finalize();
        }
    }

    public static class zza<R extends Result>
    extends Handler {
        public zza() {
            this(Looper.getMainLooper());
        }

        public zza(Looper looper) {
            super(looper);
        }

        public void zza(ResultCallback<? super R> resultCallback, R r) {
            this.sendMessage(this.obtainMessage(1, new Pair(resultCallback, r)));
        }

        public void zza(zzqe<R> zzqe2, long l) {
            this.sendMessageDelayed(this.obtainMessage(2, zzqe2), l);
        }

        public void zzaqw() {
            this.removeMessages(2);
        }

        public void handleMessage(Message message) {
            switch (message.what) {
                case 1: {
                    Pair pair = (Pair)message.obj;
                    this.zzb((ResultCallback)pair.first, (Result)pair.second);
                    return;
                }
                case 2: {
                    zzqe zzqe2 = (zzqe)message.obj;
                    zzqe2.zzaa(Status.wb);
                    return;
                }
            }
            int n = message.what;
            Log.wtf((String)"BasePendingResult", (String)new StringBuilder(45).append("Don't know how to handle message: ").append(n).toString(), (Throwable)new Exception());
        }

        protected void zzb(ResultCallback<? super R> resultCallback, R r) {
            try {
                resultCallback.onResult(r);
            }
            catch (RuntimeException runtimeException) {
                zzqe.zze(r);
                throw runtimeException;
            }
        }
    }
}

