/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.v4.app.FragmentActivity;
import android.util.Log;
import com.google.android.gms.auth.api.signin.internal.zzk;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.internal.zzh;
import com.google.android.gms.common.internal.zzm;
import com.google.android.gms.internal.zzqa;
import com.google.android.gms.internal.zzqc;
import com.google.android.gms.internal.zzqe;
import com.google.android.gms.internal.zzqf;
import com.google.android.gms.internal.zzqh;
import com.google.android.gms.internal.zzqr;
import com.google.android.gms.internal.zzqv;
import com.google.android.gms.internal.zzqy;
import com.google.android.gms.internal.zzqz;
import com.google.android.gms.internal.zzrd;
import com.google.android.gms.internal.zzre;
import com.google.android.gms.internal.zzrl;
import com.google.android.gms.internal.zzrm;
import com.google.android.gms.internal.zzrp;
import com.google.android.gms.internal.zzrq;
import com.google.android.gms.internal.zzrx;
import com.google.android.gms.internal.zzwz;
import com.google.android.gms.internal.zzxa;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;

public final class zzqp
extends GoogleApiClient
implements zzqy.zza {
    private final Lock xf;
    private final zzm xO;
    private zzqy xP = null;
    private final int vN;
    private final Context mContext;
    private final Looper zzajn;
    final Queue<zzqc.zza<?, ?>> xQ = new LinkedList();
    private volatile boolean xR;
    private long xS = 120000L;
    private long xT = 5000L;
    private final zza xU;
    private final GoogleApiAvailability vP;
    zzqv xV;
    final Map<Api.zzc<?>, Api.zze> xW;
    Set<Scope> xX = new HashSet<Scope>();
    final zzh xB;
    final Map<Api<?>, Integer> xC;
    final Api.zza<? extends zzwz, zzxa> vQ;
    private final zzre xY = new zzre();
    private final ArrayList<zzqf> xZ;
    private Integer ya = null;
    Set<zzrp> yb = null;
    final zzrq yc;
    private final zzm.zza yd = new zzm.zza(){

        @Override
        public boolean isConnected() {
            return zzqp.this.isConnected();
        }

        @Override
        public Bundle zzaoe() {
            return null;
        }
    };

    public zzqp(Context context, Lock lock, Looper looper, zzh zzh2, GoogleApiAvailability googleApiAvailability, Api.zza<? extends zzwz, zzxa> zza2, Map<Api<?>, Integer> map, List<GoogleApiClient.ConnectionCallbacks> list, List<GoogleApiClient.OnConnectionFailedListener> list2, Map<Api.zzc<?>, Api.zze> map2, int n, int n2, ArrayList<zzqf> arrayList) {
        this.mContext = context;
        this.xf = lock;
        this.xO = new zzm(looper, this.yd);
        this.zzajn = looper;
        this.xU = new zza(looper);
        this.vP = googleApiAvailability;
        this.vN = n;
        if (this.vN >= 0) {
            this.ya = n2;
        }
        this.xC = map;
        this.xW = map2;
        this.xZ = arrayList;
        this.yc = new zzrq(this.xW);
        for (GoogleApiClient.ConnectionCallbacks object : list) {
            this.xO.registerConnectionCallbacks(object);
        }
        for (GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener : list2) {
            this.xO.registerConnectionFailedListener(onConnectionFailedListener);
        }
        this.xB = zzh2;
        this.vQ = zza2;
    }

    @Override
    public <A extends Api.zzb, R extends Result, T extends zzqc.zza<R, A>> T zzc(@NonNull T t) {
        zzac.zzb((t.zzapp() != null ? 1 : 0) != 0, (Object)"This task can not be enqueued (it's probably a Batch or malformed)");
        String string2 = t.zzaqn() != null ? t.zzaqn().getName() : "the API";
        zzac.zzb((boolean)this.xW.containsKey(t.zzapp()), (Object)new StringBuilder(65 + String.valueOf(string2).length()).append("GoogleApiClient is not configured to use ").append(string2).append(" required for this call.").toString());
        this.xf.lock();
        try {
            if (this.xP == null) {
                this.xQ.add(t);
                string2 = t;
                return (T)string2;
            }
            string2 = this.xP.zzc(t);
            return (T)string2;
        }
        finally {
            this.xf.unlock();
        }
    }

    @Override
    public <A extends Api.zzb, T extends zzqc.zza<? extends Result, A>> T zzd(@NonNull T t) {
        zzac.zzb((t.zzapp() != null ? 1 : 0) != 0, (Object)"This task can not be executed (it's probably a Batch or malformed)");
        Object object = t.zzaqn() != null ? t.zzaqn().getName() : "the API";
        zzac.zzb((boolean)this.xW.containsKey(t.zzapp()), (Object)new StringBuilder(65 + String.valueOf(object).length()).append("GoogleApiClient is not configured to use ").append((String)object).append(" required for this call.").toString());
        this.xf.lock();
        try {
            if (this.xP == null) {
                throw new IllegalStateException("GoogleApiClient is not connected yet.");
            }
            if (this.isResuming()) {
                this.xQ.add(t);
                while (!this.xQ.isEmpty()) {
                    object = this.xQ.remove();
                    this.yc.zzb((zzqe<? extends Result>)object);
                    ((zzqc.zza)object).zzz(Status.wa);
                }
                object = t;
                return (T)object;
            }
            object = this.xP.zzd(t);
            return (T)object;
        }
        finally {
            this.xf.unlock();
        }
    }

    @Override
    public <L> zzrd<L> zzs(@NonNull L l) {
        this.xf.lock();
        try {
            zzrd<L> zzrd2 = this.xY.zzb(l, this.zzajn);
            return zzrd2;
        }
        finally {
            this.xf.unlock();
        }
    }

    @Override
    @NonNull
    public <C extends Api.zze> C zza(@NonNull Api.zzc<C> zzc2) {
        Api.zze zze2 = this.xW.get(zzc2);
        zzac.zzb((Object)zze2, (Object)"Appropriate Api was not requested.");
        return (C)zze2;
    }

    <C extends Api.zze> C zzb(Api.zzc<?> zzc2) {
        Api.zze zze2 = this.xW.get(zzc2);
        zzac.zzb((Object)zze2, (Object)"Appropriate Api was not requested.");
        return (C)zze2;
    }

    @Override
    public boolean zza(@NonNull Api<?> api) {
        return this.xW.containsKey(api.zzapp());
    }

    @Override
    public boolean hasConnectedApi(@NonNull Api<?> api) {
        Api.zze zze2 = this.xW.get(api.zzapp());
        return zze2 != null && zze2.isConnected();
    }

    @Override
    @NonNull
    public ConnectionResult getConnectionResult(@NonNull Api<?> api) {
        this.xf.lock();
        try {
            if (!this.isConnected() && !this.isResuming()) {
                throw new IllegalStateException("Cannot invoke getConnectionResult unless GoogleApiClient is connected");
            }
            if (this.xW.containsKey(api.zzapp())) {
                ConnectionResult connectionResult = this.xP.getConnectionResult(api);
                if (connectionResult == null) {
                    if (this.isResuming()) {
                        ConnectionResult connectionResult2 = ConnectionResult.uJ;
                        return connectionResult2;
                    }
                    Log.w((String)"GoogleApiClientImpl", (String)this.zzarv());
                    Log.wtf((String)"GoogleApiClientImpl", (String)String.valueOf(api.getName()).concat(" requested in getConnectionResult is not connected but is not present in the failed  connections map"), (Throwable)new Exception());
                    ConnectionResult connectionResult3 = new ConnectionResult(8, null);
                    return connectionResult3;
                }
                ConnectionResult connectionResult4 = connectionResult;
                return connectionResult4;
            }
            throw new IllegalArgumentException(String.valueOf(api.getName()).concat(" was never registered with GoogleApiClient"));
        }
        finally {
            this.xf.unlock();
        }
    }

    @Override
    public void connect() {
        this.xf.lock();
        try {
            if (this.vN >= 0) {
                zzac.zza((this.ya != null ? 1 : 0) != 0, (Object)"Sign-in mode should have been set explicitly by auto-manage.");
            } else if (this.ya == null) {
                this.ya = zzqp.zza(this.xW.values(), false);
            } else if (this.ya == 2) {
                throw new IllegalStateException("Cannot call connect() when SignInMode is set to SIGN_IN_MODE_OPTIONAL. Call connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            this.connect(this.ya);
        }
        finally {
            this.xf.unlock();
        }
    }

    @Override
    public void connect(int n) {
        this.xf.lock();
        try {
            zzac.zzb((n == 3 || n == 1 || n == 2 ? 1 : 0) != 0, (Object)new StringBuilder(33).append("Illegal sign-in mode: ").append(n).toString());
            this.zzft(n);
            this.zzarq();
        }
        finally {
            this.xf.unlock();
        }
    }

    @Override
    public ConnectionResult blockingConnect() {
        zzac.zza((Looper.myLooper() != Looper.getMainLooper() ? 1 : 0) != 0, (Object)"blockingConnect must not be called on the UI thread");
        this.xf.lock();
        try {
            if (this.vN >= 0) {
                zzac.zza((this.ya != null ? 1 : 0) != 0, (Object)"Sign-in mode should have been set explicitly by auto-manage.");
            } else if (this.ya == null) {
                this.ya = zzqp.zza(this.xW.values(), false);
            } else if (this.ya == 2) {
                throw new IllegalStateException("Cannot call blockingConnect() when sign-in mode is set to SIGN_IN_MODE_OPTIONAL. Call connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            this.zzft(this.ya);
            this.xO.zzauu();
            ConnectionResult connectionResult = this.xP.blockingConnect();
            return connectionResult;
        }
        finally {
            this.xf.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectionResult blockingConnect(long l, @NonNull TimeUnit timeUnit) {
        zzac.zza((Looper.myLooper() != Looper.getMainLooper() ? 1 : 0) != 0, (Object)"blockingConnect must not be called on the UI thread");
        zzac.zzb((Object)((Object)timeUnit), (Object)"TimeUnit must not be null");
        this.xf.lock();
        try {
            if (this.ya == null) {
                this.ya = zzqp.zza(this.xW.values(), false);
            } else if (this.ya == 2) {
                throw new IllegalStateException("Cannot call blockingConnect() when sign-in mode is set to SIGN_IN_MODE_OPTIONAL. Call connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            this.zzft(this.ya);
            this.xO.zzauu();
            ConnectionResult connectionResult = this.xP.blockingConnect(l, timeUnit);
            return connectionResult;
        }
        finally {
            this.xf.unlock();
        }
    }

    @Override
    public void disconnect() {
        this.xf.lock();
        try {
            this.yc.release();
            if (this.xP != null) {
                this.xP.disconnect();
            }
            this.xY.release();
            for (zzqc.zza zza2 : this.xQ) {
                zza2.zza(null);
                zza2.cancel();
            }
            this.xQ.clear();
            if (this.xP == null) {
                return;
            }
            this.zzart();
            this.xO.zzaut();
        }
        finally {
            this.xf.unlock();
        }
    }

    @Override
    public void reconnect() {
        this.disconnect();
        this.connect();
    }

    @Override
    public PendingResult<Status> clearDefaultAccountAndReconnect() {
        zzac.zza((boolean)this.isConnected(), (Object)"GoogleApiClient is not connected yet.");
        zzac.zza((this.ya != 2 ? 1 : 0) != 0, (Object)"Cannot use clearDefaultAccountAndReconnect with GOOGLE_SIGN_IN_API");
        final zzrm zzrm2 = new zzrm(this);
        if (this.xW.containsKey(zzrx.fa)) {
            this.zza(this, zzrm2, false);
        } else {
            final AtomicReference<GoogleApiClient> atomicReference = new AtomicReference<GoogleApiClient>();
            GoogleApiClient.ConnectionCallbacks connectionCallbacks = new GoogleApiClient.ConnectionCallbacks(){

                @Override
                public void onConnected(Bundle bundle) {
                    zzqp.this.zza((GoogleApiClient)atomicReference.get(), zzrm2, true);
                }

                @Override
                public void onConnectionSuspended(int n) {
                }
            };
            GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener = new GoogleApiClient.OnConnectionFailedListener(){

                @Override
                public void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
                    zzrm2.zzc(new Status(8));
                }
            };
            GoogleApiClient googleApiClient = new GoogleApiClient.Builder(this.mContext).addApi(zzrx.API).addConnectionCallbacks(connectionCallbacks).addOnConnectionFailedListener(onConnectionFailedListener).setHandler(this.xU).build();
            atomicReference.set(googleApiClient);
            googleApiClient.connect();
        }
        return zzrm2;
    }

    private void zza(final GoogleApiClient googleApiClient, final zzrm zzrm2, final boolean bl) {
        zzrx.Dh.zzg(googleApiClient).setResultCallback(new ResultCallback<Status>(){

            public void zzp(@NonNull Status status) {
                zzk.zzbd(zzqp.this.mContext).zzaie();
                if (status.isSuccess() && zzqp.this.isConnected()) {
                    zzqp.this.reconnect();
                }
                zzrm2.zzc(status);
                if (bl) {
                    googleApiClient.disconnect();
                }
            }

            public /* synthetic */ void onResult(@NonNull Result result) {
                this.zzp((Status)result);
            }
        });
    }

    @Override
    public void stopAutoManage(@NonNull FragmentActivity fragmentActivity) {
        this.zzb(new zzqz((Activity)fragmentActivity));
    }

    private void zzb(@NonNull zzqz zzqz2) {
        if (this.vN < 0) {
            throw new IllegalStateException("Called stopAutoManage but automatic lifecycle management is not enabled.");
        }
        zzqa.zza(zzqz2).zzfq(this.vN);
    }

    @Override
    public boolean isConnected() {
        return this.xP != null && this.xP.isConnected();
    }

    @Override
    public boolean isConnecting() {
        return this.xP != null && this.xP.isConnecting();
    }

    boolean isResuming() {
        return this.xR;
    }

    private void zzft(int n) {
        if (this.ya == null) {
            this.ya = n;
        } else if (this.ya != n) {
            String string2 = String.valueOf(zzqp.zzfu(n));
            String string3 = String.valueOf(zzqp.zzfu(this.ya));
            throw new IllegalStateException(new StringBuilder(51 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Cannot use sign-in mode: ").append(string2).append(". Mode was already set to ").append(string3).toString());
        }
        if (this.xP != null) {
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        for (Api.zze zze2 : this.xW.values()) {
            if (zze2.zzahd()) {
                bl = true;
            }
            if (!zze2.zzahs()) continue;
            bl2 = true;
        }
        switch (this.ya) {
            case 3: {
                break;
            }
            case 1: {
                if (!bl) {
                    throw new IllegalStateException("SIGN_IN_MODE_REQUIRED cannot be used on a GoogleApiClient that does not contain any authenticated APIs. Use connect() instead.");
                }
                if (!bl2) break;
                throw new IllegalStateException("Cannot use SIGN_IN_MODE_REQUIRED with GOOGLE_SIGN_IN_API. Use connect(SIGN_IN_MODE_OPTIONAL) instead.");
            }
            case 2: {
                if (!bl) break;
                this.xP = zzqh.zza(this.mContext, this, this.xf, this.zzajn, this.vP, this.xW, this.xB, this.xC, this.vQ, this.xZ);
                return;
            }
        }
        this.xP = new zzqr(this.mContext, this, this.xf, this.zzajn, this.vP, this.xW, this.xB, this.xC, this.vQ, this.xZ, this);
    }

    private void zzarq() {
        this.xO.zzauu();
        this.xP.connect();
    }

    private void resume() {
        this.xf.lock();
        try {
            if (this.isResuming()) {
                this.zzarq();
            }
        }
        finally {
            this.xf.unlock();
        }
    }

    private void zzarr() {
        this.xf.lock();
        try {
            boolean bl = this.zzart();
            if (bl) {
                this.zzarq();
            }
        }
        finally {
            this.xf.unlock();
        }
    }

    void zzars() {
        if (this.isResuming()) {
            return;
        }
        this.xR = true;
        if (this.xV == null) {
            this.xV = this.vP.zza(this.mContext.getApplicationContext(), new zzb(this));
        }
        this.xU.sendMessageDelayed(this.xU.obtainMessage(1), this.xS);
        this.xU.sendMessageDelayed(this.xU.obtainMessage(2), this.xT);
    }

    boolean zzart() {
        if (!this.isResuming()) {
            return false;
        }
        this.xR = false;
        this.xU.removeMessages(2);
        this.xU.removeMessages(1);
        if (this.xV != null) {
            this.xV.unregister();
            this.xV = null;
        }
        return true;
    }

    @Override
    public void registerConnectionCallbacks(@NonNull GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        this.xO.registerConnectionCallbacks(connectionCallbacks);
    }

    @Override
    public boolean isConnectionCallbacksRegistered(@NonNull GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        return this.xO.isConnectionCallbacksRegistered(connectionCallbacks);
    }

    @Override
    public void unregisterConnectionCallbacks(@NonNull GoogleApiClient.ConnectionCallbacks connectionCallbacks) {
        this.xO.unregisterConnectionCallbacks(connectionCallbacks);
    }

    @Override
    public void registerConnectionFailedListener(@NonNull GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        this.xO.registerConnectionFailedListener(onConnectionFailedListener);
    }

    @Override
    public boolean isConnectionFailedListenerRegistered(@NonNull GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        return this.xO.isConnectionFailedListenerRegistered(onConnectionFailedListener);
    }

    @Override
    public void unregisterConnectionFailedListener(@NonNull GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        this.xO.unregisterConnectionFailedListener(onConnectionFailedListener);
    }

    @Override
    public void zzn(Bundle bundle) {
        while (!this.xQ.isEmpty()) {
            this.zzd(this.xQ.remove());
        }
        this.xO.zzp(bundle);
    }

    @Override
    public void zzd(ConnectionResult connectionResult) {
        if (!this.vP.zzd(this.mContext, connectionResult.getErrorCode())) {
            this.zzart();
        }
        if (!this.isResuming()) {
            this.xO.zzn(connectionResult);
            this.xO.zzaut();
        }
    }

    @Override
    public void zzc(int n, boolean bl) {
        if (n == 1 && !bl) {
            this.zzars();
        }
        this.yc.zzasw();
        this.xO.zzgo(n);
        this.xO.zzaut();
        if (n == 2) {
            this.zzarq();
        }
    }

    @Override
    public Context getContext() {
        return this.mContext;
    }

    @Override
    public Looper getLooper() {
        return this.zzajn;
    }

    @Override
    public boolean zza(zzrl zzrl2) {
        return this.xP != null && this.xP.zza(zzrl2);
    }

    @Override
    public void zzaqb() {
        if (this.xP != null) {
            this.xP.zzaqb();
        }
    }

    @Override
    public void zza(zzrp zzrp2) {
        this.xf.lock();
        try {
            if (this.yb == null) {
                this.yb = new HashSet<zzrp>();
            }
            this.yb.add(zzrp2);
        }
        finally {
            this.xf.unlock();
        }
    }

    @Override
    public void zzb(zzrp zzrp2) {
        this.xf.lock();
        try {
            if (this.yb == null) {
                Log.wtf((String)"GoogleApiClientImpl", (String)"Attempted to remove pending transform when no transforms are registered.", (Throwable)new Exception());
            } else if (!this.yb.remove(zzrp2)) {
                Log.wtf((String)"GoogleApiClientImpl", (String)"Failed to remove pending transform - this may lead to memory leaks!", (Throwable)new Exception());
            } else if (!this.zzaru()) {
                this.xP.zzaqy();
            }
        }
        finally {
            this.xf.unlock();
        }
    }

    boolean zzaru() {
        this.xf.lock();
        try {
            if (this.yb == null) {
                boolean bl = false;
                return false;
            }
            boolean bl = !this.yb.isEmpty();
            return bl;
        }
        finally {
            this.xf.unlock();
        }
    }

    String zzarv() {
        StringWriter stringWriter = new StringWriter();
        this.dump("", null, new PrintWriter(stringWriter), null);
        return stringWriter.toString();
    }

    @Override
    public void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        printWriter.append(string2).append("mContext=").println(this.mContext);
        printWriter.append(string2).append("mResuming=").print(this.xR);
        printWriter.append(" mWorkQueue.size()=").print(this.xQ.size());
        this.yc.dump(printWriter);
        if (this.xP != null) {
            this.xP.dump(string2, fileDescriptor, printWriter, stringArray);
        }
    }

    public int getSessionId() {
        return System.identityHashCode(this);
    }

    public static int zza(Iterable<Api.zze> iterable, boolean bl) {
        boolean bl2 = false;
        boolean bl3 = false;
        for (Api.zze zze2 : iterable) {
            if (zze2.zzahd()) {
                bl2 = true;
            }
            if (!zze2.zzahs()) continue;
            bl3 = true;
        }
        if (bl2) {
            if (bl3 && bl) {
                return 2;
            }
            return 1;
        }
        return 3;
    }

    static String zzfu(int n) {
        switch (n) {
            case 3: {
                return "SIGN_IN_MODE_NONE";
            }
            case 1: {
                return "SIGN_IN_MODE_REQUIRED";
            }
            case 2: {
                return "SIGN_IN_MODE_OPTIONAL";
            }
        }
        return "UNKNOWN";
    }

    final class zza
    extends Handler {
        zza(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message message) {
            switch (message.what) {
                case 1: {
                    zzqp.this.zzarr();
                    break;
                }
                case 2: {
                    zzqp.this.resume();
                    break;
                }
                default: {
                    int n = message.what;
                    Log.w((String)"GoogleApiClientImpl", (String)new StringBuilder(31).append("Unknown message id: ").append(n).toString());
                }
            }
        }
    }

    static class zzb
    extends zzqv.zza {
        private WeakReference<zzqp> yi;

        zzb(zzqp zzqp2) {
            this.yi = new WeakReference<zzqp>(zzqp2);
        }

        @Override
        public void zzaqp() {
            zzqp zzqp2 = (zzqp)this.yi.get();
            if (zzqp2 == null) {
                return;
            }
            zzqp2.resume();
        }
    }
}

