/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.signin.internal;

import android.accounts.Account;
import android.content.Context;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.auth.api.signin.internal.zzk;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.ResolveAccountRequest;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.internal.zze;
import com.google.android.gms.common.internal.zzh;
import com.google.android.gms.common.internal.zzl;
import com.google.android.gms.common.internal.zzr;
import com.google.android.gms.internal.zzwz;
import com.google.android.gms.internal.zzxa;
import com.google.android.gms.signin.internal.SignInRequest;
import com.google.android.gms.signin.internal.SignInResponse;
import com.google.android.gms.signin.internal.zzd;
import com.google.android.gms.signin.internal.zze;

public class zzg
extends zzl<zze>
implements zzwz {
    private final boolean aAk;
    private final zzh xB;
    private final Bundle aAl;
    private Integer Ca;

    public zzg(Context context, Looper looper, boolean bl, zzh zzh2, Bundle bundle, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        super(context, looper, 44, zzh2, connectionCallbacks, onConnectionFailedListener);
        this.aAk = bl;
        this.xB = zzh2;
        this.aAl = bundle;
        this.Ca = zzh2.zzaun();
    }

    public zzg(Context context, Looper looper, boolean bl, zzh zzh2, zzxa zzxa2, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        this(context, looper, bl, zzh2, zzg.zza(zzh2), connectionCallbacks, onConnectionFailedListener);
    }

    @Override
    public boolean zzahd() {
        return this.aAk;
    }

    @Override
    public void zza(zzr zzr2, boolean bl) {
        try {
            ((zze)this.zzatx()).zza(zzr2, this.Ca, bl);
        }
        catch (RemoteException remoteException) {
            Log.w((String)"SignInClientImpl", (String)"Remote service probably died when saveDefaultAccount is called");
        }
    }

    @Override
    public void zzcda() {
        try {
            ((zze)this.zzatx()).zzaaf(this.Ca);
        }
        catch (RemoteException remoteException) {
            Log.w((String)"SignInClientImpl", (String)"Remote service probably died when clearAccountFromSessionStore is called");
        }
    }

    @Override
    public void zza(zzd zzd2) {
        zzac.zzb((Object)zzd2, (Object)"Expecting a valid ISignInCallbacks");
        try {
            ResolveAccountRequest resolveAccountRequest = this.zzcdj();
            ((zze)this.zzatx()).zza(new SignInRequest(resolveAccountRequest), zzd2);
        }
        catch (RemoteException remoteException) {
            Log.w((String)"SignInClientImpl", (String)"Remote service probably died when signIn is called");
            try {
                zzd2.zzb(new SignInResponse(8));
            }
            catch (RemoteException remoteException2) {
                Log.wtf((String)"SignInClientImpl", (String)"ISignInCallbacks#onSignInComplete should be executed from the same process, unexpected RemoteException.", (Throwable)remoteException);
            }
        }
    }

    private ResolveAccountRequest zzcdj() {
        Account account = this.xB.zzatv();
        GoogleSignInAccount googleSignInAccount = null;
        if ("<<default account>>".equals(account.name)) {
            googleSignInAccount = zzk.zzbd(this.getContext()).zzaic();
        }
        return new ResolveAccountRequest(account, this.Ca, googleSignInAccount);
    }

    protected String zzix() {
        return "com.google.android.gms.signin.service.START";
    }

    protected String zziy() {
        return "com.google.android.gms.signin.internal.ISignInService";
    }

    protected zze zzlc(IBinder iBinder) {
        return zze.zza.zzlb(iBinder);
    }

    protected Bundle zzagl() {
        String string2 = this.xB.zzauj();
        if (!this.getContext().getPackageName().equals(string2)) {
            this.aAl.putString("com.google.android.gms.signin.internal.realClientPackageName", this.xB.zzauj());
        }
        return this.aAl;
    }

    @Override
    public void connect() {
        this.zza((zze.zzf)new zze.zzi((com.google.android.gms.common.internal.zze)this));
    }

    public static Bundle zza(zzh zzh2) {
        zzxa zzxa2 = zzh2.zzaum();
        Integer n = zzh2.zzaun();
        Bundle bundle = new Bundle();
        bundle.putParcelable("com.google.android.gms.signin.internal.clientRequestedAccount", (Parcelable)zzh2.getAccount());
        if (n != null) {
            bundle.putInt("com.google.android.gms.common.internal.ClientSettings.sessionId", n.intValue());
        }
        if (zzxa2 != null) {
            bundle.putBoolean("com.google.android.gms.signin.internal.offlineAccessRequested", zzxa2.zzcdb());
            bundle.putBoolean("com.google.android.gms.signin.internal.idTokenRequested", zzxa2.zzahk());
            bundle.putString("com.google.android.gms.signin.internal.serverClientId", zzxa2.zzahn());
            bundle.putBoolean("com.google.android.gms.signin.internal.usePromptModeForAuthCode", true);
            bundle.putBoolean("com.google.android.gms.signin.internal.forceCodeForRefreshToken", zzxa2.zzahm());
            bundle.putString("com.google.android.gms.signin.internal.hostedDomain", zzxa2.zzaho());
            bundle.putBoolean("com.google.android.gms.signin.internal.waitForAccessTokenRefresh", zzxa2.zzcdc());
            if (zzxa2.zzcdd() != null) {
                bundle.putLong("com.google.android.gms.signin.internal.authApiSignInModuleVersion", zzxa2.zzcdd().longValue());
            }
            if (zzxa2.zzcde() != null) {
                bundle.putLong("com.google.android.gms.signin.internal.realClientLibraryVersion", zzxa2.zzcde().longValue());
            }
        }
        return bundle;
    }

    protected /* synthetic */ IInterface zzh(IBinder iBinder) {
        return this.zzlc(iBinder);
    }
}

