/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive;

import android.text.TextUtils;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.drive.Drive;
import com.google.android.gms.drive.internal.zzu;

public class ExecutionOptions {
    public static final int MAX_TRACKING_TAG_STRING_LENGTH = 65536;
    public static final int CONFLICT_STRATEGY_OVERWRITE_REMOTE = 0;
    public static final int CONFLICT_STRATEGY_KEEP_REMOTE = 1;
    private final String HE;
    private final boolean HF;
    private final int HG;

    public ExecutionOptions(String string, boolean bl, int n) {
        this.HE = string;
        this.HF = bl;
        this.HG = n;
    }

    public String zzbba() {
        return this.HE;
    }

    public boolean zzbbb() {
        return this.HF;
    }

    public int zzbbc() {
        return this.HG;
    }

    public static boolean zzja(int n) {
        switch (n) {
            case 1: {
                return true;
            }
        }
        return false;
    }

    public static boolean zzjb(int n) {
        switch (n) {
            case 0: 
            case 1: {
                return true;
            }
        }
        return false;
    }

    public static boolean zzio(String string) {
        return !TextUtils.isEmpty((CharSequence)string) && string.length() <= 65536;
    }

    public void zzh(GoogleApiClient googleApiClient) {
        zzu zzu2 = (zzu)googleApiClient.zza(Drive.fa);
        if (this.zzbbb() && !zzu2.zzbch()) {
            throw new IllegalStateException("Application must define an exported DriveEventService subclass in AndroidManifest.xml to be notified on completion");
        }
    }

    public boolean equals(Object object) {
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        if (object == this) {
            return true;
        }
        ExecutionOptions executionOptions = (ExecutionOptions)object;
        return zzab.equal((Object)this.HE, (Object)executionOptions.HE) && this.HG == executionOptions.HG && this.HF == executionOptions.HF;
    }

    public int hashCode() {
        return zzab.hashCode((Object[])new Object[]{this.HE, this.HG, this.HF});
    }

    public static class Builder {
        protected String HE;
        protected boolean HF;
        protected int HG = 0;

        public Builder setTrackingTag(String string) {
            if (!ExecutionOptions.zzio(string)) {
                throw new IllegalArgumentException(String.format("trackingTag must not be null nor empty, and the length must be <= the maximum length (%s)", 65536));
            }
            this.HE = string;
            return this;
        }

        public Builder setNotifyOnCompletion(boolean bl) {
            this.HF = bl;
            return this;
        }

        public Builder setConflictStrategy(int n) {
            if (!ExecutionOptions.zzjb(n)) {
                throw new IllegalArgumentException(new StringBuilder(53).append("Unrecognized value for conflict strategy: ").append(n).toString());
            }
            this.HG = n;
            return this;
        }

        protected void zzbbd() {
            if (this.HG == 1 && !this.HF) {
                throw new IllegalStateException("Cannot use CONFLICT_STRATEGY_KEEP_REMOTE without requesting completion notifications");
            }
        }

        public ExecutionOptions build() {
            this.zzbbd();
            return new ExecutionOptions(this.HE, this.HF, this.HG);
        }
    }
}

