/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.events;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import com.google.android.gms.common.util.zzy;
import com.google.android.gms.drive.events.ChangeEvent;
import com.google.android.gms.drive.events.ChangeListener;
import com.google.android.gms.drive.events.ChangesAvailableEvent;
import com.google.android.gms.drive.events.CompletionEvent;
import com.google.android.gms.drive.events.CompletionListener;
import com.google.android.gms.drive.events.DriveEvent;
import com.google.android.gms.drive.events.TransferStateEvent;
import com.google.android.gms.drive.events.zzc;
import com.google.android.gms.drive.events.zzq;
import com.google.android.gms.drive.internal.OnEventResponse;
import com.google.android.gms.drive.internal.zzao;
import com.google.android.gms.drive.internal.zzz;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public abstract class DriveEventService
extends Service
implements ChangeListener,
CompletionListener,
zzc,
zzq {
    public static final String ACTION_HANDLE_EVENT = "com.google.android.gms.drive.events.HANDLE_EVENT";
    private final String mName;
    private CountDownLatch Iu;
    zza Iv;
    boolean Iw = false;
    int AV = -1;

    protected DriveEventService(String string) {
        this.mName = string;
    }

    protected DriveEventService() {
        this("DriveEventService");
    }

    public final synchronized IBinder onBind(Intent intent) {
        if (ACTION_HANDLE_EVENT.equals(intent.getAction())) {
            if (this.Iv == null && !this.Iw) {
                this.Iw = true;
                final CountDownLatch countDownLatch = new CountDownLatch(1);
                this.Iu = new CountDownLatch(1);
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            Looper.prepare();
                            DriveEventService.this.Iv = new zza();
                            DriveEventService.this.Iw = false;
                            countDownLatch.countDown();
                            zzz.zzae("DriveEventService", "Bound and starting loop");
                            Looper.loop();
                            zzz.zzae("DriveEventService", "Finished loop");
                        }
                        finally {
                            if (DriveEventService.this.Iu != null) {
                                DriveEventService.this.Iu.countDown();
                            }
                        }
                    }
                }.start();
                try {
                    boolean bl = countDownLatch.await(5000L, TimeUnit.MILLISECONDS);
                    if (!bl) {
                        zzz.zzag("DriveEventService", "Failed to synchronously initialize event handler.");
                    }
                }
                catch (InterruptedException interruptedException) {
                    throw new RuntimeException("Unable to start event handler", interruptedException);
                }
            }
            return new zzb().asBinder();
        }
        return null;
    }

    public boolean onUnbind(Intent intent) {
        return true;
    }

    public synchronized void onDestroy() {
        zzz.zzae("DriveEventService", "onDestroy");
        if (this.Iv != null) {
            Message message = this.Iv.zzbbv();
            this.Iv.sendMessage(message);
            this.Iv = null;
            try {
                boolean bl = this.Iu.await(5000L, TimeUnit.MILLISECONDS);
                if (!bl) {
                    zzz.zzaf("DriveEventService", "Failed to synchronously quit event handler. Will quit itself");
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.Iu = null;
        }
        super.onDestroy();
    }

    @Override
    public void onChange(ChangeEvent changeEvent) {
        String string = String.valueOf(changeEvent);
        zzz.zzaf(this.mName, new StringBuilder(24 + String.valueOf(string).length()).append("Unhandled change event: ").append(string).toString());
    }

    @Override
    public void zza(ChangesAvailableEvent changesAvailableEvent) {
        String string = String.valueOf(changesAvailableEvent);
        zzz.zzaf(this.mName, new StringBuilder(35 + String.valueOf(string).length()).append("Unhandled changes available event: ").append(string).toString());
    }

    @Override
    public void onCompletion(CompletionEvent completionEvent) {
        String string = String.valueOf(completionEvent);
        zzz.zzaf(this.mName, new StringBuilder(28 + String.valueOf(string).length()).append("Unhandled completion event: ").append(string).toString());
    }

    public void zza(TransferStateEvent transferStateEvent) {
        String string = String.valueOf(transferStateEvent);
        zzz.zzaf(this.mName, new StringBuilder(32 + String.valueOf(string).length()).append("Unhandled transfer state event: ").append(string).toString());
    }

    protected int getCallingUid() {
        return Binder.getCallingUid();
    }

    private void zza(OnEventResponse onEventResponse) {
        DriveEvent driveEvent = onEventResponse.zzbco();
        String string = String.valueOf(driveEvent);
        zzz.zzae("DriveEventService", new StringBuilder(20 + String.valueOf(string).length()).append("handleEventMessage: ").append(string).toString());
        try {
            switch (driveEvent.getType()) {
                case 1: {
                    this.onChange((ChangeEvent)driveEvent);
                    break;
                }
                case 2: {
                    this.onCompletion((CompletionEvent)driveEvent);
                    break;
                }
                case 4: {
                    this.zza((ChangesAvailableEvent)driveEvent);
                    break;
                }
                case 7: {
                    this.zza((TransferStateEvent)driveEvent);
                    break;
                }
                default: {
                    string = String.valueOf(driveEvent);
                    zzz.zzaf(this.mName, new StringBuilder(17 + String.valueOf(string).length()).append("Unhandled event: ").append(string).toString());
                    break;
                }
            }
        }
        catch (Exception exception) {
            String string2 = String.valueOf(driveEvent);
            zzz.zza(this.mName, exception, new StringBuilder(22 + String.valueOf(string2).length()).append("Error handling event: ").append(string2).toString());
        }
    }

    private void zzbbu() throws SecurityException {
        int n = this.getCallingUid();
        if (n == this.AV) {
            return;
        }
        if (zzy.zzf((Context)this, (int)n)) {
            this.AV = n;
            return;
        }
        throw new SecurityException("Caller is not GooglePlayServices");
    }

    final class zzb
    extends zzao.zza {
        zzb() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zzc(OnEventResponse onEventResponse) throws RemoteException {
            DriveEventService driveEventService = DriveEventService.this;
            synchronized (driveEventService) {
                String string = String.valueOf((Object)onEventResponse);
                zzz.zzae("DriveEventService", new StringBuilder(9 + String.valueOf(string).length()).append("onEvent: ").append(string).toString());
                DriveEventService.this.zzbbu();
                if (DriveEventService.this.Iv != null) {
                    string = DriveEventService.this.Iv.zzb(onEventResponse);
                    DriveEventService.this.Iv.sendMessage((Message)string);
                } else {
                    zzz.zzag("DriveEventService", "Receiving event before initialize is completed.");
                }
            }
        }
    }

    final class zza
    extends Handler {
        zza() {
        }

        private Message zzb(OnEventResponse onEventResponse) {
            return this.obtainMessage(1, (Object)onEventResponse);
        }

        private Message zzbbv() {
            return this.obtainMessage(2);
        }

        public void handleMessage(Message message) {
            int n = message.what;
            zzz.zzae("DriveEventService", new StringBuilder(38).append("handleMessage message type:").append(n).toString());
            switch (message.what) {
                case 1: {
                    DriveEventService.this.zza((OnEventResponse)((Object)message.obj));
                    break;
                }
                case 2: {
                    this.getLooper().quit();
                    break;
                }
                default: {
                    n = message.what;
                    zzz.zzaf("DriveEventService", new StringBuilder(35).append("Unexpected message type:").append(n).toString());
                }
            }
        }
    }
}

