/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.internal;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Process;
import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.internal.zzh;
import com.google.android.gms.common.internal.zzl;
import com.google.android.gms.common.util.zzy;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.events.ChangeListener;
import com.google.android.gms.drive.events.zzc;
import com.google.android.gms.drive.events.zzg;
import com.google.android.gms.drive.events.zzi;
import com.google.android.gms.drive.internal.AddEventListenerRequest;
import com.google.android.gms.drive.internal.CancelPendingActionsRequest;
import com.google.android.gms.drive.internal.DisconnectRequest;
import com.google.android.gms.drive.internal.RemoveEventListenerRequest;
import com.google.android.gms.drive.internal.zzae;
import com.google.android.gms.drive.internal.zzam;
import com.google.android.gms.drive.internal.zzan;
import com.google.android.gms.drive.internal.zzao;
import com.google.android.gms.drive.internal.zzbr;
import com.google.android.gms.drive.internal.zzs;
import com.google.android.gms.drive.internal.zzt;
import com.google.android.gms.internal.zzqc;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class zzu
extends zzl<zzam> {
    private final String fo;
    private final Bundle Ju;
    private final boolean Jv;
    private volatile DriveId Jw;
    private volatile DriveId Jx;
    private volatile boolean Jy = false;
    final GoogleApiClient.ConnectionCallbacks Jz;
    final Map<DriveId, Map<ChangeListener, zzae>> JA = new HashMap<DriveId, Map<ChangeListener, zzae>>();
    final Map<zzc, zzae> JB = new HashMap<zzc, zzae>();
    final Map<DriveId, Map<zzi, zzae>> JC = new HashMap<DriveId, Map<zzi, zzae>>();
    final Map<DriveId, Map<zzi, zzae>> JD = new HashMap<DriveId, Map<zzi, zzae>>();

    public zzu(Context context, Looper looper, zzh zzh2, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, Bundle bundle) {
        super(context, looper, 11, zzh2, connectionCallbacks, onConnectionFailedListener);
        this.fo = zzh2.zzauj();
        this.Jz = connectionCallbacks;
        this.Ju = bundle;
        Intent intent = new Intent("com.google.android.gms.drive.events.HANDLE_EVENT");
        intent.setPackage(context.getPackageName());
        List list = context.getPackageManager().queryIntentServices(intent, 0);
        switch (list.size()) {
            case 0: {
                this.Jv = false;
                break;
            }
            case 1: {
                ServiceInfo serviceInfo = ((ResolveInfo)list.get((int)0)).serviceInfo;
                if (!serviceInfo.exported) {
                    String string = String.valueOf(serviceInfo.name);
                    throw new IllegalStateException(new StringBuilder(60 + String.valueOf(string).length()).append("Drive event service ").append(string).append(" must be exported in AndroidManifest.xml").toString());
                }
                this.Jv = true;
                break;
            }
            default: {
                String string = String.valueOf(intent.getAction());
                throw new IllegalStateException(new StringBuilder(72 + String.valueOf(string).length()).append("AndroidManifest.xml can only define one service that handles the ").append(string).append(" action").toString());
            }
        }
    }

    public boolean zzahd() {
        return !this.getContext().getPackageName().equals(this.fo) || !this.zzbcc();
    }

    public boolean zzaty() {
        return true;
    }

    boolean zzbcc() {
        return zzy.zzf((Context)this.getContext(), (int)Process.myUid());
    }

    protected zzam zzel(IBinder iBinder) {
        return zzam.zza.zzem(iBinder);
    }

    protected String zziy() {
        return "com.google.android.gms.drive.internal.IDriveService";
    }

    protected Bundle zzagl() {
        String string = this.getContext().getPackageName();
        zzac.zzy((Object)string);
        zzac.zzbr((!this.zzaus().zzauh().isEmpty() ? 1 : 0) != 0);
        Bundle bundle = new Bundle();
        if (!string.equals(this.fo)) {
            bundle.putString("proxy_package_name", this.fo);
        }
        bundle.putAll(this.Ju);
        return bundle;
    }

    protected String zzix() {
        return "com.google.android.gms.drive.ApiService.START";
    }

    public zzam zzbcd() throws DeadObjectException {
        return (zzam)this.zzatx();
    }

    public DriveId zzbce() {
        return this.Jw;
    }

    public DriveId zzbcf() {
        return this.Jx;
    }

    public boolean zzbcg() {
        return this.Jy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        Map<Object, Object> map;
        if (this.isConnected()) {
            try {
                map = (zzam)this.zzatx();
                map.zza(new DisconnectRequest());
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        super.disconnect();
        map = this.JA;
        synchronized (map) {
            this.JA.clear();
        }
        map = this.JB;
        synchronized (map) {
            this.JB.clear();
        }
        map = this.JC;
        synchronized (map) {
            this.JC.clear();
        }
        map = this.JD;
        synchronized (map) {
            this.JD.clear();
        }
    }

    protected void zza(int n, IBinder iBinder, Bundle bundle, int n2) {
        if (bundle != null) {
            bundle.setClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            this.Jw = (DriveId)bundle.getParcelable("com.google.android.gms.drive.root_id");
            this.Jx = (DriveId)bundle.getParcelable("com.google.android.gms.drive.appdata_id");
            this.Jy = true;
        }
        super.zza(n, iBinder, bundle, n2);
    }

    public boolean zzbch() {
        return this.Jv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PendingResult<Status> zza(GoogleApiClient googleApiClient, DriveId driveId, ChangeListener changeListener) {
        boolean bl = true;
        zzac.zzbs((boolean)zzg.zza(1, driveId));
        zzac.zzb((Object)changeListener, (Object)"listener");
        zzac.zza((boolean)this.isConnected(), (Object)"Client must be connected");
        Map<DriveId, Map<ChangeListener, zzae>> map = this.JA;
        synchronized (map) {
            zzae zzae2;
            Map<ChangeListener, zzae> map2 = this.JA.get((Object)driveId);
            if (map2 == null) {
                map2 = new HashMap<ChangeListener, zzae>();
                this.JA.put(driveId, map2);
            }
            if ((zzae2 = map2.get(changeListener)) == null) {
                zzae2 = new zzae(this.getLooper(), this.getContext(), 1, changeListener);
                map2.put(changeListener, zzae2);
            } else if (zzae2.zzkm(1)) {
                return new zzs.zzj(googleApiClient, Status.vY);
            }
            zzae2.zzkl(1);
            return this.zza(googleApiClient, new AddEventListenerRequest(1, driveId), zzae2);
        }
    }

    private PendingResult<Status> zza(GoogleApiClient googleApiClient, final AddEventListenerRequest addEventListenerRequest, final zzae zzae2) {
        return googleApiClient.zzd((zzqc.zza)new zzt.zza(googleApiClient){

            protected void zza(zzu zzu2) throws RemoteException {
                zzu2.zzbcd().zza(addEventListenerRequest, (zzao)zzae2, null, (zzan)new zzbr((zzqc.zzb<Status>)this));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PendingResult<Status> zzb(GoogleApiClient googleApiClient, DriveId driveId, ChangeListener changeListener) {
        boolean bl = true;
        zzac.zzbs((boolean)zzg.zza(1, driveId));
        zzac.zza((boolean)this.isConnected(), (Object)"Client must be connected");
        zzac.zzb((Object)changeListener, (Object)"listener");
        Map<DriveId, Map<ChangeListener, zzae>> map = this.JA;
        synchronized (map) {
            Map<ChangeListener, zzae> map2 = this.JA.get((Object)driveId);
            if (map2 == null) {
                return new zzs.zzj(googleApiClient, Status.vY);
            }
            zzae zzae2 = map2.remove(changeListener);
            if (zzae2 == null) {
                return new zzs.zzj(googleApiClient, Status.vY);
            }
            if (map2.isEmpty()) {
                this.JA.remove((Object)driveId);
            }
            return this.zza(googleApiClient, new RemoveEventListenerRequest(driveId, 1), zzae2);
        }
    }

    private PendingResult<Status> zza(GoogleApiClient googleApiClient, final RemoveEventListenerRequest removeEventListenerRequest, final zzae zzae2) {
        return googleApiClient.zzd((zzqc.zza)new zzt.zza(googleApiClient){

            protected void zza(zzu zzu2) throws RemoteException {
                zzu2.zzbcd().zza(removeEventListenerRequest, (zzao)zzae2, null, (zzan)new zzbr((zzqc.zzb<Status>)this));
            }
        });
    }

    PendingResult<Status> zza(GoogleApiClient googleApiClient, DriveId driveId) {
        return this.zza(googleApiClient, new AddEventListenerRequest(1, driveId));
    }

    private PendingResult<Status> zza(GoogleApiClient googleApiClient, final AddEventListenerRequest addEventListenerRequest) {
        zzac.zzbs((boolean)zzg.zza(addEventListenerRequest.getEventType(), addEventListenerRequest.getDriveId()));
        zzac.zza((boolean)this.isConnected(), (Object)"Client must be connected");
        if (!this.Jv) {
            throw new IllegalStateException("Application must define an exported DriveEventService subclass in AndroidManifest.xml to add event subscriptions");
        }
        return googleApiClient.zzd((zzqc.zza)new zzt.zza(googleApiClient){

            protected void zza(zzu zzu2) throws RemoteException {
                zzu2.zzbcd().zza(addEventListenerRequest, null, null, (zzan)new zzbr((zzqc.zzb<Status>)this));
            }
        });
    }

    PendingResult<Status> zzb(GoogleApiClient googleApiClient, DriveId driveId) {
        return this.zza(googleApiClient, 1, driveId);
    }

    private PendingResult<Status> zza(GoogleApiClient googleApiClient, final int n, final DriveId driveId) {
        zzac.zzbs((boolean)zzg.zza(n, driveId));
        zzac.zza((boolean)this.isConnected(), (Object)"Client must be connected");
        return googleApiClient.zzd((zzqc.zza)new zzt.zza(googleApiClient){

            protected void zza(zzu zzu2) throws RemoteException {
                zzu2.zzbcd().zza(new RemoveEventListenerRequest(driveId, n), null, null, (zzan)new zzbr((zzqc.zzb<Status>)this));
            }
        });
    }

    PendingResult<Status> cancelPendingActions(GoogleApiClient googleApiClient, final List<String> list) {
        zzac.zzbs((list != null ? 1 : 0) != 0);
        zzac.zzbs((!list.isEmpty() ? 1 : 0) != 0);
        zzac.zza((boolean)this.isConnected(), (Object)"Client must be connected");
        return googleApiClient.zzd((zzqc.zza)new zzt.zza(googleApiClient){

            protected void zza(zzu zzu2) throws RemoteException {
                zzu2.zzbcd().zza(new CancelPendingActionsRequest(list), (zzan)new zzbr((zzqc.zzb<Status>)this));
            }
        });
    }

    protected /* synthetic */ IInterface zzh(IBinder iBinder) {
        return this.zzel(iBinder);
    }
}

