/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.metadata;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.drive.metadata.zzc;
import java.util.regex.Pattern;
import org.json.JSONException;
import org.json.JSONObject;

public class CustomPropertyKey
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<CustomPropertyKey> CREATOR = new zzc();
    public static final int PUBLIC = 0;
    public static final int PRIVATE = 1;
    final int mVersionCode;
    final String zzbaf;
    final int mVisibility;
    private static final Pattern Lu = Pattern.compile("[\\w.!@$%^&*()/-]+");

    CustomPropertyKey(int n, String string, int n2) {
        zzac.zzb((Object)string, (Object)"key");
        zzac.zzb((boolean)Lu.matcher(string).matches(), (Object)"key name characters must be alphanumeric or one of .!@$%^&*()-_/");
        zzac.zzb((n2 == 0 || n2 == 1 ? 1 : 0) != 0, (Object)"visibility must be either PUBLIC or PRIVATE");
        this.mVersionCode = n;
        this.zzbaf = string;
        this.mVisibility = n2;
    }

    public CustomPropertyKey(String string, int n) {
        this(1, string, n);
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzc.zza(this, parcel, n);
    }

    public String getKey() {
        return this.zzbaf;
    }

    public int getVisibility() {
        return this.mVisibility;
    }

    public int hashCode() {
        String string = this.zzbaf;
        int n = this.mVisibility;
        return new StringBuilder(11 + String.valueOf(string).length()).append(string).append(n).toString().hashCode();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof CustomPropertyKey)) {
            return false;
        }
        CustomPropertyKey customPropertyKey = (CustomPropertyKey)((Object)object);
        return customPropertyKey.getKey().equals(this.zzbaf) && customPropertyKey.getVisibility() == this.mVisibility;
    }

    public String toString() {
        String string = this.zzbaf;
        int n = this.mVisibility;
        return new StringBuilder(31 + String.valueOf(string).length()).append("CustomPropertyKey(").append(string).append(",").append(n).append(")").toString();
    }

    public JSONObject toJson() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("key", (Object)this.getKey());
        jSONObject.put("visibility", this.getVisibility());
        return jSONObject;
    }

    public static CustomPropertyKey fromJson(JSONObject jSONObject) throws JSONException {
        return new CustomPropertyKey(jSONObject.getString("key"), jSONObject.getInt("visibility"));
    }
}

