/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.java2d.renderer;

import java.awt.Font;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.annotation.Nonnull;

public class FontProviderJava2dImpl {
    protected static final Logger logger = Logger.getLogger(FontProviderJava2dImpl.class.getName());
    @Nonnull
    private final Map<String, Font> fonts = new HashMap<String, Font>();
    private Font defaultFont = new Font("arial", 0, 17);

    public void setDefaultFont(Font defaultFont) {
        this.defaultFont = defaultFont;
    }

    public void addFont(String name, Font font) {
        this.fonts.put(name, font);
    }

    public Font getFont(String name) {
        if (!this.fonts.containsKey(name)) {
            return this.getDefaultFont(name);
        }
        return this.fonts.get(name);
    }

    private Font getDefaultFont(String name) {
        logger.fine("font " + name + " not found, using default font instead");
        if (this.defaultFont != null) {
            return this.defaultFont;
        }
        throw new RuntimeException("font " + name + " not found");
    }
}

