/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.wizard.components.panels;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.installer.product.Registry;
import org.netbeans.installer.product.components.Product;
import org.netbeans.installer.product.dependencies.InstallAfter;
import org.netbeans.installer.product.filters.OrFilter;
import org.netbeans.installer.product.filters.ProductFilter;
import org.netbeans.installer.utils.FileUtils;
import org.netbeans.installer.utils.LogManager;
import org.netbeans.installer.utils.ResourceUtils;
import org.netbeans.installer.utils.StringUtils;
import org.netbeans.installer.utils.SystemUtils;
import org.netbeans.installer.utils.applications.JavaUtils;
import org.netbeans.installer.utils.exceptions.InitializationException;
import org.netbeans.installer.utils.helper.Dependency;
import org.netbeans.installer.utils.helper.Status;
import org.netbeans.installer.utils.helper.Version;
import org.netbeans.installer.wizard.components.actions.SearchForJavaAction;
import org.netbeans.installer.wizard.components.panels.ApplicationLocationPanel;

public class JdkLocationPanel
extends ApplicationLocationPanel {
    private Version minimumVersion;
    private Version maximumVersion;
    private Version preferredVersion;
    private String vendorAllowed;
    private List<File> jdkLocations;
    private List<String> jdkLabels;
    private static File lastSelectedJava = null;
    public static final String JDK_LOCATION_PROPERTY = "jdk.location";
    public static final String MINIMUM_JDK_VERSION_PROPERTY = "minimum.jdk.version";
    public static final String MAXIMUM_JDK_VERSION_PROPERTY = "maximum.jdk.version";
    public static final String PREFERRED_JDK_VERSION_PROPERTY = "preferred.jdk.version";
    public static final String VENDOR_JDK_ALLOWED_PROPERTY = "vendor.jdk.allowed.pattern";
    public static final String JRE_ALLOWED_PROPERTY = "jre.allowed";
    public static final String DEFAULT_JRE_ALLOWED = "false";
    public static final String DEFAULT_LOCATION_LABEL_TEXT = ResourceUtils.getString(JdkLocationPanel.class, "JLP.location.label.text");
    public static final String DEFAULT_LOCATION_LABEL_TEXT_JAVA = ResourceUtils.getString(JdkLocationPanel.class, "JLP.location.label.text.java");
    public static final String DEFAULT_LOCATION_BUTTON_TEXT = ResourceUtils.getString(JdkLocationPanel.class, "JLP.location.button.text");
    public static final String DEFAULT_LIST_LABEL_TEXT = ResourceUtils.getString(JdkLocationPanel.class, "JLP.list.label.text");
    public static final String DEFAULT_LIST_LABEL_TEXT_JAVA = ResourceUtils.getString(JdkLocationPanel.class, "JLP.list.label.text.java");
    public static final String ERROR_NULL_PROPERTY = "error.null";
    public static final String ERROR_NOT_VALID_PATH_PROPERTY = "error.not.valid.path";
    public static final String ERROR_PATH_NOT_EXISTS_PROPERTY = "error.path.not.exists";
    public static final String ERROR_NOT_JAVAHOME_PROPERTY = "error.not.javahome";
    public static final String ERROR_NOT_JDK_PROPERTY = "error.not.jdk";
    public static final String ERROR_WRONG_VERSION_OLDER_PROPERTY = "error.wrong.version.older";
    public static final String ERROR_WRONG_VERSION_NEWER_PROPERTY = "error.wrong.version.newer";
    public static final String ERROR_WRONG_VENDOR_PROPERTY = "error.wrong.vendor";
    public static final String ERROR_UNKNOWN_PROPERTY = "error.unknown";
    public static final String DEFAULT_ERROR_NULL = ResourceUtils.getString(JdkLocationPanel.class, "JLP.error.null");
    public static final String DEFAULT_ERROR_NULL_JAVA = ResourceUtils.getString(JdkLocationPanel.class, "JLP.error.null.java");
    public static final String DEFAULT_ERROR_NOT_VALID_PATH = ResourceUtils.getString(JdkLocationPanel.class, "JLP.error.not.valid.path");
    public static final String DEFAULT_ERROR_NOT_VALID_PATH_JAVA = ResourceUtils.getString(JdkLocationPanel.class, "JLP.error.not.valid.path.java");
    public static final String DEFAULT_ERROR_PATH_NOT_EXISTS = ResourceUtils.getString(JdkLocationPanel.class, "JLP.error.path.not.exists");
    public static final String DEFAULT_ERROR_PATH_NOT_EXISTS_JAVA = ResourceUtils.getString(JdkLocationPanel.class, "JLP.error.path.not.exists.java");
    public static final String DEFAULT_ERROR_NOT_JAVAHOME = ResourceUtils.getString(JdkLocationPanel.class, "JLP.error.not.javahome");
    public static final String DEFAULT_ERROR_NOT_JAVAHOME_JAVA = ResourceUtils.getString(JdkLocationPanel.class, "JLP.error.not.javahome.java");
    public static final String DEFAULT_ERROR_NOT_JDK = ResourceUtils.getString(JdkLocationPanel.class, "JLP.error.not.jdk");
    public static final String DEFAULT_ERROR_WRONG_VERSION_OLDER = ResourceUtils.getString(JdkLocationPanel.class, "JLP.error.wrong.version.older");
    public static final String DEFAULT_ERROR_WRONG_VERSION_OLDER_JAVA = ResourceUtils.getString(JdkLocationPanel.class, "JLP.error.wrong.version.older.java");
    public static final String DEFAULT_ERROR_WRONG_VERSION_NEWER = ResourceUtils.getString(JdkLocationPanel.class, "JLP.error.wrong.version.newer");
    public static final String DEFAULT_ERROR_WRONG_VERSION_NEWER_JAVA = ResourceUtils.getString(JdkLocationPanel.class, "JLP.error.wrong.version.newer.java");
    public static final String DEFAULT_ERROR_WRONG_VENDOR = ResourceUtils.getString(JdkLocationPanel.class, "JLP.error.wrong.vendor");
    public static final String DEFAULT_ERROR_WRONG_VENDOR_JAVA = ResourceUtils.getString(JdkLocationPanel.class, "JLP.error.wrong.vendor.java");
    public static final String DEFAULT_ERROR_UNKNOWN = ResourceUtils.getString(JdkLocationPanel.class, "JLP.error.unknown");
    public static final String DEFAULT_ERROR_NOTHING_FOUND = ResourceUtils.getString(JdkLocationPanel.class, "JLP.error.nothing.found");
    public static final String DEFAULT_ERROR_NOTHING_FOUND_JAVA = ResourceUtils.getString(JdkLocationPanel.class, "JLP.error.nothing.found.java");
    public static final String DEFAULT_MINIMUM_JDK_VERSION = ResourceUtils.getString(JdkLocationPanel.class, "JLP.minimum.jdk.version");
    public static final String DEFAULT_MAXIMUM_JDK_VERSION = ResourceUtils.getString(JdkLocationPanel.class, "JLP.maximum.jdk.version");
    public static final String DEFAULT_VENDOR_JDK_ALLOWED = ResourceUtils.getString(JdkLocationPanel.class, "JLP.vendor.jdk.allowed");
    public static final String JAVA_DOWNLOAD_PAGE_PROPERTY = "java.download.page";
    public static final String DEFAULT_JAVA_DOWNLOAD_PAGE = ResourceUtils.getString(JdkLocationPanel.class, "JLP.java.download.page");
    public static final String DEFAULT_JAVA_DOWNLOAD_PAGE_MAC = ResourceUtils.getString(JdkLocationPanel.class, "JLP.java.download.page.mac");
    public static final String DEFAULT_USEDBY_LABEL = ResourceUtils.getString(JdkLocationPanel.class, "JLP.usedby.label");
    public static final String USEDBY_LABEL_PROPERTY = "usedby.label";
    private static final String SUN_MICROSYSTEMS_VENDOR = "Sun Microsystems Inc.";
    private static final String JDK_PRODUCT_UID = "jdk";

    public JdkLocationPanel() {
        this.setProperty(MINIMUM_JDK_VERSION_PROPERTY, DEFAULT_MINIMUM_JDK_VERSION);
        this.setProperty(MAXIMUM_JDK_VERSION_PROPERTY, DEFAULT_MAXIMUM_JDK_VERSION);
        this.setProperty(VENDOR_JDK_ALLOWED_PROPERTY, DEFAULT_VENDOR_JDK_ALLOWED);
        this.setProperty(JRE_ALLOWED_PROPERTY, DEFAULT_JRE_ALLOWED);
        this.setProperty("location.label.text", DEFAULT_LOCATION_LABEL_TEXT);
        this.setProperty("location.button.text", DEFAULT_LOCATION_BUTTON_TEXT);
        this.setProperty("list.label.text", DEFAULT_LIST_LABEL_TEXT);
        this.setProperty(ERROR_NULL_PROPERTY, DEFAULT_ERROR_NULL);
        this.setProperty(ERROR_NOT_VALID_PATH_PROPERTY, DEFAULT_ERROR_NOT_VALID_PATH);
        this.setProperty(ERROR_PATH_NOT_EXISTS_PROPERTY, DEFAULT_ERROR_PATH_NOT_EXISTS);
        this.setProperty(ERROR_NOT_JAVAHOME_PROPERTY, DEFAULT_ERROR_NOT_JAVAHOME);
        this.setProperty(ERROR_NOT_JDK_PROPERTY, DEFAULT_ERROR_NOT_JDK);
        this.setProperty(ERROR_WRONG_VERSION_OLDER_PROPERTY, DEFAULT_ERROR_WRONG_VERSION_OLDER);
        this.setProperty(ERROR_WRONG_VERSION_NEWER_PROPERTY, DEFAULT_ERROR_WRONG_VERSION_NEWER);
        this.setProperty(ERROR_WRONG_VENDOR_PROPERTY, DEFAULT_ERROR_WRONG_VENDOR);
        this.setProperty(ERROR_UNKNOWN_PROPERTY, DEFAULT_ERROR_UNKNOWN);
        this.setProperty("error.nothing.found", DEFAULT_ERROR_NOTHING_FOUND);
        this.setProperty(USEDBY_LABEL_PROPERTY, DEFAULT_USEDBY_LABEL);
        this.setProperty(JAVA_DOWNLOAD_PAGE_PROPERTY, !SystemUtils.isMacOS() ? DEFAULT_JAVA_DOWNLOAD_PAGE : DEFAULT_JAVA_DOWNLOAD_PAGE_MAC);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.minimumVersion = Version.getVersion(this.getProperty(MINIMUM_JDK_VERSION_PROPERTY));
        this.maximumVersion = Version.getVersion(this.getProperty(MAXIMUM_JDK_VERSION_PROPERTY));
        this.vendorAllowed = this.getProperty(VENDOR_JDK_ALLOWED_PROPERTY);
        if (this.getProperty(PREFERRED_JDK_VERSION_PROPERTY) != null) {
            this.preferredVersion = Version.getVersion(this.getProperty(PREFERRED_JDK_VERSION_PROPERTY));
        }
        this.addJavaLocationsFromProductDependencies();
        this.jdkLocations = new LinkedList<File>();
        this.jdkLabels = new LinkedList<String>();
        Registry registry = Registry.getInstance();
        for (int i = 0; i < SearchForJavaAction.getJavaLocations().size(); ++i) {
            File location = SearchForJavaAction.getJavaLocations().get(i);
            String label = SearchForJavaAction.getJavaLabels().get(i);
            Version version = null;
            if (location.exists()) {
                version = JavaUtils.getVersion(location);
            }
            if (version == null) {
                for (Product jdk : registry.getProducts(JDK_PRODUCT_UID)) {
                    if (jdk.getStatus() != Status.TO_BE_INSTALLED || !jdk.getInstallationLocation().equals(location)) continue;
                    version = jdk.getVersion();
                }
            }
            if (version == null) continue;
            OrFilter filter = new OrFilter(new ProductFilter(Status.INSTALLED), new ProductFilter(Status.TO_BE_INSTALLED));
            LinkedList<Product> products = new LinkedList<Product>();
            for (Product product : registry.queryProducts(filter)) {
                String jdk = product.getProperty(JDK_LOCATION_PROPERTY);
                if (jdk == null || !jdk.equals(location.getAbsolutePath())) continue;
                products.add(product);
            }
            Product product = (Product)this.getWizard().getContext().get(Product.class);
            if (products.contains(product)) {
                products.remove(product);
            }
            if (products.size() > 0) {
                label = StringUtils.format(this.getProperty(USEDBY_LABEL_PROPERTY), label, StringUtils.asString(products));
            }
            if (location.exists() && !this.isJreAllowed() && !JavaUtils.isJdk(location)) continue;
            String vendor = JavaUtils.getInfo(location).getVendor();
            if (JavaUtils.getInfo(location) == null) {
                LogManager.log("JdkLocationPanel - JavaUtils.getInfo(" + location + ") returns null!");
                continue;
            }
            if (version.olderThan(this.minimumVersion) || version.newerThan(this.maximumVersion) || !vendor.matches(this.vendorAllowed)) continue;
            this.jdkLocations.add(location);
            this.jdkLabels.add(label);
        }
        boolean jreAllowed = this.isJreAllowed();
        this.setProperty("location.label.text", jreAllowed ? DEFAULT_LOCATION_LABEL_TEXT_JAVA : DEFAULT_LOCATION_LABEL_TEXT);
        this.setProperty("list.label.text", jreAllowed ? DEFAULT_LIST_LABEL_TEXT_JAVA : DEFAULT_LIST_LABEL_TEXT);
        this.setProperty(ERROR_NULL_PROPERTY, jreAllowed ? DEFAULT_ERROR_NULL_JAVA : DEFAULT_ERROR_NULL);
        this.setProperty(ERROR_NOT_VALID_PATH_PROPERTY, jreAllowed ? DEFAULT_ERROR_NOT_VALID_PATH_JAVA : DEFAULT_ERROR_NOT_VALID_PATH);
        this.setProperty(ERROR_PATH_NOT_EXISTS_PROPERTY, jreAllowed ? DEFAULT_ERROR_PATH_NOT_EXISTS_JAVA : DEFAULT_ERROR_PATH_NOT_EXISTS);
        this.setProperty(ERROR_NOT_JAVAHOME_PROPERTY, jreAllowed ? DEFAULT_ERROR_NOT_JAVAHOME_JAVA : DEFAULT_ERROR_NOT_JAVAHOME);
        this.setProperty(ERROR_WRONG_VERSION_OLDER_PROPERTY, jreAllowed ? DEFAULT_ERROR_WRONG_VERSION_OLDER_JAVA : DEFAULT_ERROR_WRONG_VERSION_OLDER);
        this.setProperty(ERROR_WRONG_VERSION_NEWER_PROPERTY, jreAllowed ? DEFAULT_ERROR_WRONG_VERSION_NEWER_JAVA : DEFAULT_ERROR_WRONG_VERSION_NEWER);
        this.setProperty(ERROR_WRONG_VENDOR_PROPERTY, jreAllowed ? DEFAULT_ERROR_WRONG_VENDOR_JAVA : DEFAULT_ERROR_WRONG_VENDOR);
        this.setProperty("error.nothing.found", jreAllowed ? DEFAULT_ERROR_NOTHING_FOUND_JAVA : DEFAULT_ERROR_NOTHING_FOUND);
    }

    @Override
    public List<File> getLocations() {
        return this.jdkLocations;
    }

    @Override
    public List<String> getLabels() {
        return this.jdkLabels;
    }

    private boolean isJreAllowed() {
        return "true".equals(this.getProperty(JRE_ALLOWED_PROPERTY));
    }

    @Override
    public File getSelectedLocation() {
        File jdkLocation = null;
        jdkLocation = this.getJavaAlreadySelectedForProduct();
        if (jdkLocation != null) {
            LogManager.log("... use Java that is already selected for the product: " + jdkLocation);
            return jdkLocation;
        }
        jdkLocation = this.getJavaFromSystemProperty();
        if (jdkLocation != null) {
            LogManager.log("... use Java that is passed via a system property: " + jdkLocation);
            return jdkLocation;
        }
        jdkLocation = this.getJavaAlreadySelectedGlobal();
        if (jdkLocation != null) {
            LogManager.log("... use Java that is already selected for another product which be installed: " + jdkLocation);
            return jdkLocation;
        }
        jdkLocation = this.getJavaBundledAndInstalled();
        if (jdkLocation != null) {
            LogManager.log("... use Java that is bundled and installed: " + jdkLocation);
            return jdkLocation;
        }
        jdkLocation = this.getJavaPreferredVersionLocation();
        if (jdkLocation != null) {
            LogManager.log("... use Java based on the preferred version: " + jdkLocation);
            return jdkLocation;
        }
        jdkLocation = this.getJavaFirstItemInTheList();
        if (jdkLocation != null) {
            LogManager.log("... use Java from the first item in the overall list: " + jdkLocation);
            return jdkLocation;
        }
        LogManager.log("... no Java found");
        return new File("");
    }

    private File getJavaFirstItemInTheList() {
        if (this.jdkLocations.isEmpty()) {
            return null;
        }
        if (this.isJreAllowed()) {
            for (File f : this.jdkLocations) {
                if (FileUtils.exists(f) && !JavaUtils.isJdk(f)) continue;
                return f;
            }
        }
        return this.jdkLocations.get(0);
    }

    private File getJavaFromSystemProperty() {
        File f;
        Product product;
        String jdkSysPropName;
        String jdkSysProp;
        Object obj = this.getWizard().getContext().get(Product.class);
        if (obj != null && obj instanceof Product && (jdkSysProp = System.getProperty(jdkSysPropName = (product = (Product)obj).getUid() + "." + JDK_LOCATION_PROPERTY)) != null && this.jdkLocations.contains(f = new File(jdkSysProp))) {
            LogManager.log("... using JDK from system property " + jdkSysPropName + " : " + jdkSysProp);
            return f;
        }
        return null;
    }

    private File getJavaAlreadySelectedForProduct() {
        String jdkLocation = this.getWizard().getProperty(JDK_LOCATION_PROPERTY);
        if (jdkLocation != null && this.jdkLocations.contains(new File(jdkLocation))) {
            return new File(jdkLocation);
        }
        return null;
    }

    private File getJavaAlreadySelectedGlobal() {
        return lastSelectedJava != null && this.jdkLocations.contains(lastSelectedJava) ? lastSelectedJava : null;
    }

    private File getJavaBundledAndInstalled() {
        try {
            Registry bundledRegistry = new Registry();
            String bundledRegistryUri = System.getProperty("nbi.product.bundled.registry.uri");
            bundledRegistry.loadProductRegistry(bundledRegistryUri != null ? bundledRegistryUri : "resource:data/registry.xml");
            for (Product bundledJdk : bundledRegistry.getProducts(JDK_PRODUCT_UID)) {
                File jdkLoc;
                Product globalJdk = Registry.getInstance().getProduct(JDK_PRODUCT_UID, bundledJdk.getVersion());
                if (globalJdk == null || (jdkLoc = globalJdk.getStatus().equals((Object)Status.INSTALLED) ? globalJdk.getInstallationLocation() : JavaUtils.findJDKHome(globalJdk.getVersion())) == null || !this.jdkLocations.contains(jdkLoc)) continue;
                return jdkLoc;
            }
        }
        catch (InitializationException e) {
            LogManager.log("Cannot load bundled registry", (Throwable)e);
        }
        return null;
    }

    private File getJavaFromInstalledProductProperties() {
        for (Product product : Registry.getInstance().queryProducts(new OrFilter(new ProductFilter(Status.INSTALLED), new ProductFilter(Status.TO_BE_INSTALLED)))) {
            File jdkFile;
            String jdk = product.getProperty(JDK_LOCATION_PROPERTY);
            if (jdk == null || !this.jdkLocations.contains(jdkFile = new File(jdk))) continue;
            return jdkFile;
        }
        return null;
    }

    private File getJavaPreferredVersionLocation() {
        Version.VersionDistance currentDistance;
        Version currentVersion;
        if (this.preferredVersion == null) {
            return null;
        }
        File closestLocation = null;
        Version.VersionDistance closestDistance = null;
        if (this.isJreAllowed()) {
            for (File location : this.jdkLocations) {
                currentVersion = JavaUtils.getVersion(location);
                currentDistance = currentVersion.getDistance(this.preferredVersion);
                if (FileUtils.exists(location) && !JavaUtils.isJdk(location) || closestDistance != null && !currentDistance.lessThan(closestDistance)) continue;
                closestLocation = location;
                closestDistance = currentDistance;
            }
        }
        if (closestLocation == null) {
            for (File location : this.jdkLocations) {
                currentVersion = JavaUtils.getVersion(location);
                currentDistance = currentVersion.getDistance(this.preferredVersion);
                if (closestDistance != null && !currentDistance.lessThan(closestDistance)) continue;
                closestLocation = location;
                closestDistance = currentDistance;
            }
        }
        return closestLocation;
    }

    @Override
    public String validateLocation(String path) {
        Version version;
        File file = new File(path);
        if (path.equals("")) {
            return StringUtils.format(this.getProperty(ERROR_NULL_PROPERTY), new Object[0]);
        }
        if (!SystemUtils.isPathValid(path)) {
            return StringUtils.format(this.getProperty(ERROR_NOT_VALID_PATH_PROPERTY), path);
        }
        if (!file.exists()) {
            if (JavaUtils.getInfo(file) == null) {
                return StringUtils.format(this.getProperty(ERROR_PATH_NOT_EXISTS_PROPERTY), path);
            }
        } else {
            if (!JavaUtils.isJavaHome(file)) {
                return StringUtils.format(this.getProperty(ERROR_NOT_JAVAHOME_PROPERTY), path);
            }
            if (!this.isJreAllowed() && !JavaUtils.isJdk(file)) {
                return StringUtils.format(this.getProperty(ERROR_NOT_JDK_PROPERTY), path);
            }
        }
        if ((version = this.getVersion(file)) == null) {
            return StringUtils.format(this.getProperty(ERROR_UNKNOWN_PROPERTY), path);
        }
        if (version.olderThan(this.minimumVersion)) {
            return StringUtils.format(this.getProperty(ERROR_WRONG_VERSION_OLDER_PROPERTY), path, version, this.minimumVersion);
        }
        if (version.newerThan(this.maximumVersion)) {
            return StringUtils.format(this.getProperty(ERROR_WRONG_VERSION_NEWER_PROPERTY), path, version, this.maximumVersion);
        }
        String vendor = JavaUtils.getInfo(file).getVendor();
        if (!vendor.matches(this.vendorAllowed)) {
            return StringUtils.format(this.getProperty(ERROR_WRONG_VENDOR_PROPERTY), path, vendor, this.vendorAllowed);
        }
        return null;
    }

    @Override
    public void setLocation(File location) {
        lastSelectedJava = location;
        SearchForJavaAction.addJavaLocation(location);
        this.getWizard().setProperty(JDK_LOCATION_PROPERTY, location.getAbsolutePath());
    }

    public boolean isJdkVersionRecommended(String jdkPath) {
        File jdkFile = new File(jdkPath);
        Version version = this.getVersion(jdkFile);
        return version != null ? JavaUtils.isRecommended(version) : true;
    }

    public boolean isArchitectureMatching(String jdkPath) {
        if (jdkPath == null || jdkPath.isEmpty()) {
            return true;
        }
        File jdkFile = new File(jdkPath);
        JavaUtils.JavaInfo info = JavaUtils.getInfo(jdkFile);
        if (info == null) {
            return true;
        }
        return info.getArch().endsWith("64") || !SystemUtils.getNativeUtils().isSystem64Bit();
    }

    private Version getVersion(File file) {
        Version version = JavaUtils.getVersion(file);
        if (version == null) {
            for (Product jdk : Registry.getInstance().getProducts(JDK_PRODUCT_UID)) {
                if (jdk.getStatus() != Status.TO_BE_INSTALLED || !jdk.getInstallationLocation().equals(file)) continue;
                version = jdk.getVersion();
            }
        }
        return version;
    }

    private void addJavaLocationsFromProductDependencies() {
        Object objectContext = this.getWizard().getContext().get(Product.class);
        boolean sort = false;
        if (objectContext != null && objectContext instanceof Product) {
            Product product = (Product)objectContext;
            for (Dependency dependency : product.getDependencies(InstallAfter.class)) {
                if (!dependency.getUid().equals(JDK_PRODUCT_UID)) continue;
                for (Product jdk : Registry.getInstance().getProducts(JDK_PRODUCT_UID)) {
                    if (jdk.getStatus() != Status.TO_BE_INSTALLED || SearchForJavaAction.getJavaLocations().contains(jdk.getInstallationLocation())) continue;
                    SearchForJavaAction.addJavaLocation(jdk.getInstallationLocation(), jdk.getVersion(), SUN_MICROSYSTEMS_VENDOR);
                    sort = true;
                }
            }
        }
        if (sort) {
            SearchForJavaAction.sortJavaLocations();
        }
    }
}

