/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.java2d.input;

import de.lessvoid.nifty.NiftyInputConsumer;
import de.lessvoid.nifty.input.keyboard.KeyboardInputEvent;
import de.lessvoid.nifty.java2d.input.AwtToNiftyKeyCodeConverter;
import de.lessvoid.nifty.spi.input.InputSystem;
import de.lessvoid.nifty.tools.resourceloader.NiftyResourceLoader;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.annotation.Nonnull;

public class InputSystemAwtImpl
implements InputSystem,
MouseMotionListener,
MouseListener,
KeyListener {
    @Nonnull
    private final ConcurrentLinkedQueue<MouseEvent> mouseEvents = new ConcurrentLinkedQueue();
    @Nonnull
    private final ConcurrentLinkedQueue<KeyboardInputEvent> keyboardEvents = new ConcurrentLinkedQueue();
    final AwtToNiftyKeyCodeConverter keyCodeConverter = new AwtToNiftyKeyCodeConverter();

    public void setResourceLoader(@Nonnull NiftyResourceLoader nifty) {
    }

    public void forwardEvents(@Nonnull NiftyInputConsumer inputEventConsumer) {
        MouseEvent mouseEvent = this.mouseEvents.poll();
        while (mouseEvent != null) {
            inputEventConsumer.processMouseEvent(mouseEvent.getX(), mouseEvent.getY(), 0, mouseEvent.getButton() - 1, mouseEvent.getButton() != 0);
            mouseEvent = this.mouseEvents.poll();
        }
        KeyboardInputEvent keyEvent = this.keyboardEvents.poll();
        while (keyEvent != null) {
            inputEventConsumer.processKeyboardEvent(keyEvent);
            keyEvent = this.keyboardEvents.poll();
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.mouseEvents.add(mouseEvent);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.mouseEvents.add(mouseEvent);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(@Nonnull MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 1) {
            this.mouseEvents.add(mouseEvent);
        }
    }

    @Override
    public void mouseReleased(@Nonnull MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 1) {
            this.mouseEvents.add(mouseEvent);
        }
    }

    @Override
    public void keyPressed(@Nonnull KeyEvent e) {
        this.handleKeyEvent(e, true);
    }

    @Override
    public void keyReleased(@Nonnull KeyEvent e) {
        this.handleKeyEvent(e, false);
    }

    private void handleKeyEvent(@Nonnull KeyEvent e, boolean isKeyDown) {
        int newKeyCode = this.keyCodeConverter.convertToNiftyKeyCode(e.getKeyCode(), e.getKeyLocation());
        this.keyboardEvents.add(new KeyboardInputEvent(newKeyCode, e.getKeyChar(), isKeyDown, e.isShiftDown(), e.isControlDown()));
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    public void setMousePosition(int x, int y) {
    }
}

