/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.java2d.renderer;

import de.lessvoid.nifty.java2d.renderer.FontProviderJava2dImpl;
import de.lessvoid.nifty.java2d.renderer.GraphicsWrapper;
import de.lessvoid.nifty.java2d.renderer.RenderFontJava2dImpl;
import de.lessvoid.nifty.java2d.renderer.RenderFontJava2dWithAngelCodeImpl;
import de.lessvoid.nifty.java2d.renderer.RenderImageJava2dImpl;
import de.lessvoid.nifty.java2d.renderer.fonts.AngelCodeFont;
import de.lessvoid.nifty.java2d.renderer.fonts.CharacterInfo;
import de.lessvoid.nifty.render.BlendMode;
import de.lessvoid.nifty.spi.render.MouseCursor;
import de.lessvoid.nifty.spi.render.RenderDevice;
import de.lessvoid.nifty.spi.render.RenderFont;
import de.lessvoid.nifty.spi.render.RenderImage;
import de.lessvoid.nifty.tools.Color;
import de.lessvoid.nifty.tools.resourceloader.NiftyResourceLoader;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Stack;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;

public class RenderDeviceJava2dImpl
implements RenderDevice {
    protected static final Logger logger = Logger.getLogger(RenderDeviceJava2dImpl.class.getName());
    private NiftyResourceLoader resourceLoader;
    private Graphics2D graphics;
    private Graphics2dHelper graphics2dHelper;
    @Nullable
    private Rectangle clipRectangle = null;
    private FontProviderJava2dImpl fontProvider = new FontProviderJava2dImpl();
    private final GraphicsWrapper graphicsWrapper;

    protected Graphics2D getGraphics() {
        return this.graphics;
    }

    @Nonnull
    private java.awt.Color convertNiftyColor(@Nonnull Color color) {
        return new java.awt.Color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
    }

    public void setResourceLoader(@Nonnull NiftyResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public RenderDeviceJava2dImpl(GraphicsWrapper graphicsWrapper) {
        this.graphicsWrapper = graphicsWrapper;
    }

    public void beginFrame() {
        this.graphics = this.graphicsWrapper.getGraphics2d();
        this.graphics2dHelper = new Graphics2dHelper(this.graphics);
    }

    public void endFrame() {
    }

    public void clear() {
        this.graphics.clearRect(0, 0, this.getWidth(), this.getHeight());
    }

    public void setFontProvider(FontProviderJava2dImpl fontProvider) {
        this.fontProvider = fontProvider;
    }

    @Nonnull
    public RenderFont createFont(@Nonnull String filename) {
        return new RenderFontJava2dImpl(this, this.fontProvider.getFont(filename));
    }

    @Nonnull
    public RenderImage createImage(@Nonnull String filename, boolean filterLinear) {
        try {
            BufferedImage image = ImageIO.read(this.resourceLoader.getResource(filename));
            BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
            Graphics g = bufferedImage.getGraphics();
            g.drawImage(image, 0, 0, null);
            return new RenderImageJava2dImpl(bufferedImage);
        }
        catch (IOException e) {
            throw new RuntimeException("failed to create image " + filename, e);
        }
    }

    public void disableClip() {
        this.clipRectangle = null;
    }

    public void enableClip(int x0, int y0, int x1, int y1) {
        this.clipRectangle = new Rectangle(x0, y0, x1 - x0, y1 - y0);
    }

    public int getHeight() {
        return this.graphicsWrapper.getHeight();
    }

    public int getWidth() {
        return this.graphicsWrapper.getWidth();
    }

    public void renderImage(@Nonnull RenderImage image, int x, int y, int width, int height, @Nonnull Color color, float imageScale) {
        if (!(image instanceof RenderImageJava2dImpl)) {
            return;
        }
        RenderImageJava2dImpl renderImage = (RenderImageJava2dImpl)image;
        this.graphics.setClip(this.clipRectangle);
        width = renderImage.getWidth();
        height = renderImage.getHeight();
        AffineTransform transform = new AffineTransform();
        AffineTransform translateTransform = AffineTransform.getTranslateInstance(-width / 2, -height / 2);
        AffineTransform scaleTransform = AffineTransform.getScaleInstance(imageScale, imageScale);
        AffineTransform inverseTranslateTransform = AffineTransform.getTranslateInstance(x + width / 2, y + height / 2);
        transform.concatenate(inverseTranslateTransform);
        transform.concatenate(scaleTransform);
        transform.concatenate(translateTransform);
        Composite comp = this.graphics.getComposite();
        this.graphics2dHelper.pushTransform();
        this.graphics.transform(transform);
        this.graphics.setComposite(AlphaComposite.getInstance(3, color.getAlpha()));
        this.graphics.drawImage((Image)renderImage.image, 0, 0, null);
        this.graphics2dHelper.popTransform();
        this.graphics.setComposite(comp);
    }

    public void renderImage(@Nonnull RenderImage image, int x, int y, int w, int h, int srcX, int srcY, int srcW, int srcH, @Nonnull Color color, float scale, int centerX, int centerY) {
        if (!(image instanceof RenderImageJava2dImpl)) {
            return;
        }
        RenderImageJava2dImpl renderImage = (RenderImageJava2dImpl)image;
        Composite comp = this.graphics.getComposite();
        this.graphics.setClip(this.clipRectangle);
        this.graphics.setComposite(AlphaComposite.getInstance(3, color.getAlpha()));
        this.graphics.drawImage(renderImage.image, x, y, x + w, y + h, srcX, srcY, srcX + srcW, srcY + srcH, null);
        this.graphics.setComposite(comp);
    }

    public void renderQuad(int x, int y, int width, int height, @Nonnull Color color) {
        this.graphics.setClip(this.clipRectangle);
        this.graphics.setColor(this.convertNiftyColor(color));
        this.graphics.fillRect(x, y, width, height);
    }

    public static boolean sameColor(@Nonnull Color color1, @Nonnull Color color2) {
        return color1.getRed() == color2.getRed() && color1.getGreen() == color2.getGreen() && color1.getBlue() == color2.getBlue() && color1.getAlpha() == color2.getAlpha();
    }

    public void renderQuad(int x, int y, int width, int height, @Nonnull Color topLeft, @Nonnull Color topRight, @Nonnull Color bottomRight, @Nonnull Color bottomLeft) {
        this.graphics.setClip(this.clipRectangle);
        Graphics2D graphics2d = this.graphics;
        GradientPaint grad = new GradientPaint(new Point(x, y), this.convertNiftyColor(topLeft), new Point(x + width, y), this.convertNiftyColor(bottomRight));
        if (RenderDeviceJava2dImpl.sameColor(topLeft, topRight)) {
            grad = new GradientPaint(new Point(x, y), this.convertNiftyColor(topLeft), new Point(x, y + height), this.convertNiftyColor(bottomLeft));
        }
        graphics2d.setPaint(grad);
        this.graphics.fillRect(x, y, width, height);
    }

    public void setBlendMode(@Nonnull BlendMode blendMode) {
    }

    public void renderFont(@Nonnull RenderFont font, @Nonnull String text, int x, int y, @Nonnull Color fontColor, float sizeX, float sizeY) {
        if (font instanceof RenderFontJava2dImpl) {
            this.renderFontJava2dImpl(text, x, y, fontColor, (RenderFontJava2dImpl)font);
        } else if (font instanceof RenderFontJava2dWithAngelCodeImpl) {
            char c;
            CharacterInfo charInfo;
            RenderFontJava2dWithAngelCodeImpl renderFont = (RenderFontJava2dWithAngelCodeImpl)font;
            AngelCodeFont angelCodeFont = renderFont.getAngelCodeFont();
            String[] textures = angelCodeFont.getTextures();
            for (int i = 0; i < text.length() && (charInfo = angelCodeFont.getChar(c = text.charAt(i))) != null; ++i) {
                int textureId = charInfo.getPage();
                String texture = textures[textureId];
                RenderImage renderImage = renderFont.getRenderImage(texture);
                this.renderImage(renderImage, x, y, 200, 200, charInfo.getX(), charInfo.getY(), charInfo.getWidth(), charInfo.getHeight(), fontColor, sizeX, 0, 0);
            }
        }
    }

    private void renderFontJava2dImpl(String text, int x, int y, @Nonnull Color fontColor, @Nonnull RenderFontJava2dImpl font) {
        this.graphics.setClip(this.clipRectangle);
        this.graphics.setFont(font.getFont());
        this.graphics.setColor(this.convertNiftyColor(fontColor));
        this.graphics.drawString(text, x, y + font.getHeight() / 2);
    }

    @Nullable
    public MouseCursor createMouseCursor(@Nonnull String filename, int hotspotX, int hotspotY) throws IOException {
        return null;
    }

    public void enableMouseCursor(@Nonnull MouseCursor mouseCursor) {
    }

    public void disableMouseCursor() {
    }

    static class Graphics2dHelper {
        @Nonnull
        final Stack<AffineTransform> transformStack = new Stack();
        private final Graphics2D graphics;

        public Graphics2dHelper(Graphics2D graphics) {
            this.graphics = graphics;
        }

        public void pushTransform() {
            this.transformStack.push(this.graphics.getTransform());
        }

        public void popTransform() {
            this.graphics.setTransform(this.transformStack.pop());
        }
    }
}

