/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.dom;

import com.bulletphysics.$Stack;
import com.bulletphysics.collision.broadphase.BroadphaseNativeType;
import com.bulletphysics.collision.shapes.ConcaveShape;
import com.bulletphysics.collision.shapes.ScalarType;
import com.bulletphysics.collision.shapes.TriangleCallback;
import com.bulletphysics.linearmath.MatrixUtil;
import com.bulletphysics.linearmath.Transform;
import javax.vecmath.Matrix3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

public class HeightfieldTerrainShape
extends ConcaveShape {
    public static final int XAXIS = 0;
    public static final int YAXIS = 1;
    public static final int ZAXIS = 2;
    protected Vector3f m_localAabbMin = new Vector3f();
    protected Vector3f m_localAabbMax = new Vector3f();
    protected Vector3f m_localOrigin = new Vector3f();
    protected int m_heightStickWidth;
    protected int m_heightStickLength;
    protected float m_minHeight;
    protected float m_maxHeight;
    protected float m_width;
    protected float m_length;
    protected float m_heightScale;
    protected float[] m_heightfieldDataFloat;
    protected ScalarType m_heightDataType;
    protected boolean m_flipQuadEdges;
    protected boolean m_useDiamondSubdivision;
    protected int m_upAxis;
    protected Vector3f m_localScaling = new Vector3f();

    public HeightfieldTerrainShape(int heightStickWidth, int heightStickLength, float[] heightfieldData, float heightScale, float minHeight, float maxHeight, int upAxis, boolean flipQuadEdges) {
        this.initialize(heightStickWidth, heightStickLength, heightfieldData, heightScale, minHeight, maxHeight, upAxis, ScalarType.FLOAT, flipQuadEdges);
    }

    private void initialize(int heightStickWidth, int heightStickLength, float[] heightfieldData, float heightScale, float minHeight, float maxHeight, int upAxis, ScalarType f, boolean flipQuadEdges) {
        this.m_heightStickWidth = heightStickWidth;
        this.m_heightStickLength = heightStickLength;
        this.m_minHeight = minHeight * heightScale;
        this.m_maxHeight = maxHeight * heightScale;
        this.m_width = heightStickWidth - 1;
        this.m_length = heightStickLength - 1;
        this.m_heightScale = heightScale;
        this.m_heightfieldDataFloat = heightfieldData;
        this.m_heightDataType = ScalarType.FLOAT;
        this.m_flipQuadEdges = flipQuadEdges;
        this.m_useDiamondSubdivision = false;
        this.m_upAxis = upAxis;
        this.m_localScaling.set(1.0f, 1.0f, 1.0f);
        switch (this.m_upAxis) {
            case 0: {
                this.m_localAabbMin.set(this.m_minHeight, 0.0f, 0.0f);
                this.m_localAabbMax.set(this.m_maxHeight, this.m_width, this.m_length);
                break;
            }
            case 1: {
                this.m_localAabbMin.set(0.0f, this.m_minHeight, 0.0f);
                this.m_localAabbMax.set(this.m_width, this.m_maxHeight, this.m_length);
                break;
            }
            case 2: {
                this.m_localAabbMin.set(0.0f, 0.0f, this.m_minHeight);
                this.m_localAabbMax.set(this.m_width, this.m_length, this.m_maxHeight);
            }
        }
        this.m_localOrigin.set((Tuple3f)this.m_localAabbMin);
        this.m_localOrigin.add((Tuple3f)this.m_localAabbMax);
        this.m_localOrigin.x *= 0.5f;
        this.m_localOrigin.y *= 0.5f;
        this.m_localOrigin.z *= 0.5f;
    }

    /*
     * WARNING - void declaration
     */
    public void processAllTriangles(TriangleCallback triangleCallback, Vector3f vector3f, Vector3f vector3f2) {
        $Stack $Stack = $Stack.get();
        try {
            void aabbMax;
            void aabbMin;
            $Stack.push$javax$vecmath$Vector3f();
            Vector3f localAabbMin = $Stack.get$javax$vecmath$Vector3f();
            localAabbMin.x = aabbMin.x * (1.0f / this.m_localScaling.x);
            localAabbMin.y = aabbMin.y * (1.0f / this.m_localScaling.y);
            localAabbMin.z = aabbMin.z * (1.0f / this.m_localScaling.z);
            Vector3f localAabbMax = $Stack.get$javax$vecmath$Vector3f();
            localAabbMax.x = aabbMax.x * (1.0f / this.m_localScaling.x);
            localAabbMax.y = aabbMax.y * (1.0f / this.m_localScaling.y);
            localAabbMax.z = aabbMax.z * (1.0f / this.m_localScaling.z);
            localAabbMin.add((Tuple3f)this.m_localOrigin);
            localAabbMax.add((Tuple3f)this.m_localOrigin);
            int[] quantizedAabbMin = new int[3];
            int[] quantizedAabbMax = new int[3];
            this.quantizeWithClamp(quantizedAabbMin, localAabbMin);
            this.quantizeWithClamp(quantizedAabbMax, localAabbMax);
            int i = 0;
            while (i < 3) {
                int n = i;
                quantizedAabbMin[n] = quantizedAabbMin[n] - 1;
                int n2 = i++;
                quantizedAabbMax[n2] = quantizedAabbMax[n2] + 1;
            }
            int startX = 0;
            int endX = this.m_heightStickWidth - 1;
            int startJ = 0;
            int endJ = this.m_heightStickLength - 1;
            switch (this.m_upAxis) {
                case 0: {
                    if (quantizedAabbMin[1] > startX) {
                        startX = quantizedAabbMin[1];
                    }
                    if (quantizedAabbMax[1] < endX) {
                        endX = quantizedAabbMax[1];
                    }
                    if (quantizedAabbMin[2] > startJ) {
                        startJ = quantizedAabbMin[2];
                    }
                    if (quantizedAabbMax[2] >= endJ) break;
                    endJ = quantizedAabbMax[2];
                    break;
                }
                case 1: {
                    if (quantizedAabbMin[0] > startX) {
                        startX = quantizedAabbMin[0];
                    }
                    if (quantizedAabbMax[0] < endX) {
                        endX = quantizedAabbMax[0];
                    }
                    if (quantizedAabbMin[2] > startJ) {
                        startJ = quantizedAabbMin[2];
                    }
                    if (quantizedAabbMax[2] >= endJ) break;
                    endJ = quantizedAabbMax[2];
                    break;
                }
                case 2: {
                    if (quantizedAabbMin[0] > startX) {
                        startX = quantizedAabbMin[0];
                    }
                    if (quantizedAabbMax[0] < endX) {
                        endX = quantizedAabbMax[0];
                    }
                    if (quantizedAabbMin[1] > startJ) {
                        startJ = quantizedAabbMin[1];
                    }
                    if (quantizedAabbMax[1] >= endJ) break;
                    endJ = quantizedAabbMax[1];
                }
            }
            for (int j = startJ; j < endJ; ++j) {
                for (int x = startX; x < endX; ++x) {
                    void callback;
                    Vector3f[] vertices = new Vector3f[]{$Stack.get$javax$vecmath$Vector3f(), $Stack.get$javax$vecmath$Vector3f(), $Stack.get$javax$vecmath$Vector3f()};
                    if (this.m_flipQuadEdges || this.m_useDiamondSubdivision && (j + x & 1) != 0) {
                        this.getVertex(x, j, vertices[0]);
                        this.getVertex(x + 1, j, vertices[1]);
                        this.getVertex(x + 1, j + 1, vertices[2]);
                        callback.processTriangle(vertices, x, j);
                        this.getVertex(x, j, vertices[0]);
                        this.getVertex(x + 1, j + 1, vertices[1]);
                        this.getVertex(x, j + 1, vertices[2]);
                        callback.processTriangle(vertices, x, j);
                        continue;
                    }
                    this.getVertex(x, j, vertices[0]);
                    this.getVertex(x, j + 1, vertices[1]);
                    this.getVertex(x + 1, j, vertices[2]);
                    callback.processTriangle(vertices, x, j);
                    this.getVertex(x + 1, j, vertices[0]);
                    this.getVertex(x, j + 1, vertices[1]);
                    this.getVertex(x + 1, j + 1, vertices[2]);
                    callback.processTriangle(vertices, x, j);
                }
            }
            $Stack.pop$javax$vecmath$Vector3f();
            return;
        }
        catch (Throwable throwable) {
            $Stack.pop$javax$vecmath$Vector3f();
            throw throwable;
        }
    }

    private void getVertex(int x, int y, Vector3f vertex) {
        float height = this.getRawHeightFieldValue(x, y);
        switch (this.m_upAxis) {
            case 0: {
                vertex.set(height - this.m_localOrigin.x, -this.m_width / 2.0f + (float)x, -this.m_length / 2.0f + (float)y);
                break;
            }
            case 1: {
                vertex.set(-this.m_width / 2.0f + (float)x, height - this.m_localOrigin.y, -this.m_length / 2.0f + (float)y);
                break;
            }
            case 2: {
                vertex.set(-this.m_width / 2.0f + (float)x, -this.m_length / 2.0f + (float)y, height - this.m_localOrigin.z);
            }
        }
        vertex.x *= this.m_localScaling.x;
        vertex.y *= this.m_localScaling.y;
        vertex.z *= this.m_localScaling.z;
    }

    public void calculateLocalInertia(float arg0, Vector3f inertia) {
        inertia.set(0.0f, 0.0f, 0.0f);
    }

    /*
     * WARNING - void declaration
     */
    public void getAabb(Transform transform, Vector3f vector3f, Vector3f vector3f2) {
        $Stack $Stack = $Stack.get();
        try {
            void aabbMax;
            void aabbMin;
            void t;
            $Stack $Stack2 = $Stack;
            $Stack2.push$javax$vecmath$Vector3f();
            $Stack2.push$javax$vecmath$Matrix3f();
            Vector3f halfExtents = $Stack.get$javax$vecmath$Vector3f();
            halfExtents.set((Tuple3f)this.m_localAabbMax);
            halfExtents.sub((Tuple3f)this.m_localAabbMin);
            halfExtents.x = halfExtents.x * this.m_localScaling.x * 0.5f;
            halfExtents.y = halfExtents.y * this.m_localScaling.y * 0.5f;
            halfExtents.z = halfExtents.z * this.m_localScaling.z * 0.5f;
            Matrix3f abs_b = $Stack.get$javax$vecmath$Matrix3f(t.basis);
            MatrixUtil.absolute(abs_b);
            Vector3f tmp = $Stack.get$javax$vecmath$Vector3f();
            Vector3f center = $Stack.get$javax$vecmath$Vector3f(t.origin);
            Vector3f extent = $Stack.get$javax$vecmath$Vector3f();
            abs_b.getRow(0, tmp);
            extent.x = tmp.dot(halfExtents);
            abs_b.getRow(1, tmp);
            extent.y = tmp.dot(halfExtents);
            abs_b.getRow(2, tmp);
            extent.z = tmp.dot(halfExtents);
            Vector3f margin = $Stack.get$javax$vecmath$Vector3f();
            margin.set(this.getMargin(), this.getMargin(), this.getMargin());
            extent.add((Tuple3f)margin);
            aabbMin.sub((Tuple3f)center, (Tuple3f)extent);
            aabbMax.add((Tuple3f)center, (Tuple3f)extent);
            $Stack $Stack3 = $Stack;
            $Stack3.pop$javax$vecmath$Vector3f();
            $Stack3.pop$javax$vecmath$Matrix3f();
            return;
        }
        catch (Throwable throwable) {
            $Stack $Stack4 = $Stack;
            $Stack4.pop$javax$vecmath$Vector3f();
            $Stack4.pop$javax$vecmath$Matrix3f();
            throw throwable;
        }
    }

    public Vector3f getLocalScaling(Vector3f arg0) {
        return this.m_localScaling;
    }

    public String getName() {
        return "Terrain";
    }

    public BroadphaseNativeType getShapeType() {
        return BroadphaseNativeType.TERRAIN_SHAPE_PROXYTYPE;
    }

    public void setLocalScaling(Vector3f scaling) {
        this.m_localScaling = scaling;
    }

    private float getRawHeightFieldValue(int x, int y) {
        return this.m_heightfieldDataFloat[y * this.m_heightStickWidth + x] * this.m_heightScale;
    }

    public static int getQuantized(float x) {
        if ((double)x < 0.0) {
            return (int)((double)x - 0.5);
        }
        return (int)((double)x + 0.5);
    }

    private void quantizeWithClamp(int[] out, Vector3f clampedPoint) {
        out[0] = HeightfieldTerrainShape.getQuantized(clampedPoint.x);
        out[1] = HeightfieldTerrainShape.getQuantized(clampedPoint.y);
        out[2] = HeightfieldTerrainShape.getQuantized(clampedPoint.z);
    }
}

