/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.java2d.renderer;

import de.lessvoid.nifty.java2d.renderer.RenderDeviceJava2dImpl;
import de.lessvoid.nifty.spi.render.RenderFont;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import javax.annotation.Nonnull;

public class RenderFontJava2dImpl
implements RenderFont {
    private final Font font;
    private final RenderDeviceJava2dImpl renderDevice;

    Font getFont() {
        return this.font;
    }

    public RenderFontJava2dImpl(RenderDeviceJava2dImpl renderDevice, Font font) {
        this.renderDevice = renderDevice;
        this.font = font;
    }

    public int getCharacterAdvance(char currentCharacter, char nextCharacter, float size) {
        return this.getFont().getSize();
    }

    public int getHeight() {
        Graphics2D graphics = this.renderDevice.getGraphics();
        if (graphics == null) {
            return 0;
        }
        FontMetrics fontMetrics = graphics.getFontMetrics(this.font);
        double height = fontMetrics.getStringBounds("A", graphics).getHeight();
        return (int)height;
    }

    public int getWidth(@Nonnull String text) {
        return this.getWidth(text, 1.0f);
    }

    public int getWidth(@Nonnull String text, float size) {
        Graphics2D graphics = this.renderDevice.getGraphics();
        if (graphics == null) {
            return 0;
        }
        FontMetrics fontMetrics = graphics.getFontMetrics(this.font);
        double width = fontMetrics.getStringBounds(text, graphics).getWidth();
        return (int)width;
    }

    public void dispose() {
    }
}

