/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.utils.system;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.installer.utils.FileUtils;
import org.netbeans.installer.utils.LogManager;
import org.netbeans.installer.utils.SystemUtils;
import org.netbeans.installer.utils.XMLUtils;
import org.netbeans.installer.utils.exceptions.NativeException;
import org.netbeans.installer.utils.exceptions.XMLException;
import org.netbeans.installer.utils.helper.ExecutionResults;
import org.netbeans.installer.utils.helper.Platform;
import org.netbeans.installer.utils.system.UnixNativeUtils;
import org.netbeans.installer.utils.system.shortcut.FileShortcut;
import org.netbeans.installer.utils.system.shortcut.InternetShortcut;
import org.netbeans.installer.utils.system.shortcut.LocationType;
import org.netbeans.installer.utils.system.shortcut.Shortcut;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class MacOsNativeUtils
extends UnixNativeUtils {
    private static final String FILE_LOCALHOST = "file://localhost";
    public static final String[] POSSIBLE_BROWSER_LOCATIONS_MAC = new String[]{"/usr/bin/open"};
    public static final String LIBRARY_PATH_MACOSX = "native/jnilib/macosx/macosx.dylib";
    public static final String APP_SUFFIX = ".app";
    private static final String DOCK_PROPERIES = "com.apple.dock.plist";
    private static final String PLUTILS = "plutil";
    private static final String PLUTILS_CONVERT = "-convert";
    private static final String PLUTILS_CONVERT_XML = "xml1";
    private static final String PLUTILS_CONVERT_BINARY = "binary1";
    private static final String[] UPDATE_DOCK_COMMAND = new String[]{"killall", "-HUP", "Dock"};
    public static final String[] FORBIDDEN_DELETING_FILES_MACOSX = new String[]{"/Applications", "/Developer", "/Library", "/Network", "/System", "/Users"};

    MacOsNativeUtils() {
        this.loadLibrary(LIBRARY_PATH_MACOSX);
        this.initializeForbiddenFiles(FORBIDDEN_DELETING_FILES_MACOSX);
    }

    @Override
    protected Platform getPlatform() {
        return System.getProperty("os.arch").contains("ppc") ? Platform.MACOSX_PPC : Platform.MACOSX_X86;
    }

    @Override
    public File getDefaultApplicationsLocation() {
        File applications = new File("/Applications");
        if (applications.exists() && applications.isDirectory() && FileUtils.canWrite(applications)) {
            return applications;
        }
        return SystemUtils.getUserHomeDirectory();
    }

    private String getShortcutFilename(Shortcut shortcut) {
        String fileName = shortcut.getFileName();
        if (fileName == null) {
            if (shortcut instanceof FileShortcut) {
                fileName = ((FileShortcut)shortcut).getTarget().getName();
                if (fileName != null && fileName.endsWith(APP_SUFFIX)) {
                    fileName = fileName.substring(0, fileName.lastIndexOf(APP_SUFFIX));
                }
            } else if (shortcut instanceof InternetShortcut) {
                fileName = ((InternetShortcut)shortcut).getURL().getFile();
            }
        }
        return fileName;
    }

    @Override
    public File getShortcutLocation(Shortcut shortcut, LocationType locationType) throws NativeException {
        if (shortcut.getPath() != null) {
            return new File(shortcut.getPath());
        }
        String fileName = this.getShortcutFilename(shortcut);
        File file = null;
        switch (locationType) {
            case CURRENT_USER_DESKTOP: {
                file = new File(SystemUtils.getUserHomeDirectory(), "Desktop/" + fileName);
                break;
            }
            case ALL_USERS_DESKTOP: {
                file = new File(SystemUtils.getUserHomeDirectory(), "Desktop/" + fileName);
                break;
            }
            case CURRENT_USER_START_MENU: {
                file = this.getDockPropertiesFile();
                break;
            }
            case ALL_USERS_START_MENU: {
                file = this.getDockPropertiesFile();
                break;
            }
            case CUSTOM: {
                file = new File(shortcut.getRelativePath(), fileName);
            }
        }
        shortcut.setPath(file.getAbsolutePath());
        return file;
    }

    protected void createURLShortcut(InternetShortcut shortcut) throws NativeException {
        try {
            LinkedList<String> lines = new LinkedList<String>();
            lines.add("[InternetShortcut]");
            lines.add("URL=" + shortcut.getURL());
            lines.add("IconFile=" + shortcut.getIconPath());
            lines.add(SystemUtils.getLineSeparator());
            FileUtils.writeStringList(new File(shortcut.getPath()), lines);
        }
        catch (IOException ex) {
            throw new NativeException("Can`t create URL shortcut", ex);
        }
    }

    @Override
    public File createShortcut(Shortcut shortcut, LocationType locationType) throws NativeException {
        try {
            File shortcutFile = this.getShortcutLocation(shortcut, locationType);
            switch (locationType) {
                case CURRENT_USER_DESKTOP: 
                case ALL_USERS_DESKTOP: 
                case CUSTOM: {
                    if (shortcutFile.exists()) break;
                    if (shortcut instanceof FileShortcut) {
                        this.createSymLink(shortcutFile, ((FileShortcut)shortcut).getTarget());
                        break;
                    }
                    if (!(shortcut instanceof InternetShortcut)) break;
                    this.createURLShortcut((InternetShortcut)shortcut);
                    break;
                }
                case CURRENT_USER_START_MENU: 
                case ALL_USERS_START_MENU: {
                    if (!(shortcut instanceof FileShortcut) || this.convertDockProperties(true) != 0 || !this.modifyDockLink((FileShortcut)shortcut, shortcutFile, true)) break;
                    LogManager.log(4, "    Updating Dock");
                    this.convertDockProperties(false);
                    SystemUtils.executeCommand(null, UPDATE_DOCK_COMMAND);
                    break;
                }
                default: {
                    LogManager.log("... unknown shortcut type " + (Object)((Object)locationType));
                    return null;
                }
            }
            return shortcutFile;
        }
        catch (IOException e) {
            throw new NativeException("Cannot create shortcut", e);
        }
    }

    @Override
    public void removeShortcut(Shortcut shortcut, LocationType locationType, boolean cleanupParents) throws NativeException {
        try {
            File shortcutFile = this.getShortcutLocation(shortcut, locationType);
            switch (locationType) {
                case CURRENT_USER_DESKTOP: 
                case ALL_USERS_DESKTOP: 
                case CUSTOM: {
                    if (shortcutFile.exists()) {
                        FileUtils.deleteFile(shortcutFile, false);
                    }
                    break;
                }
                case CURRENT_USER_START_MENU: 
                case ALL_USERS_START_MENU: {
                    if (shortcut instanceof FileShortcut && this.convertDockProperties(true) == 0 && this.modifyDockLink((FileShortcut)shortcut, shortcutFile, false)) {
                        LogManager.log(4, "... updating Dock");
                        if (this.convertDockProperties(false) == 0) {
                            SystemUtils.executeCommand(null, UPDATE_DOCK_COMMAND);
                        }
                    }
                    break;
                }
                default: {
                    LogManager.log("... unknown shortcut type " + (Object)((Object)locationType));
                    break;
                }
            }
        }
        catch (IOException e) {
            throw new NativeException("Cannot remove shortcut", e);
        }
    }

    public boolean isCheetah() {
        return this.getOSVersion().startsWith("10.0");
    }

    public boolean isPuma() {
        return this.getOSVersion().startsWith("10.1");
    }

    public boolean isJaguar() {
        return this.getOSVersion().startsWith("10.2");
    }

    public boolean isPanther() {
        return this.getOSVersion().startsWith("10.3");
    }

    public boolean isTiger() {
        return this.getOSVersion().startsWith("10.4");
    }

    public boolean isLeopard() {
        return this.getOSVersion().startsWith("10.5");
    }

    public boolean isSnowLeopard() {
        return this.getOSVersion().startsWith("10.6");
    }

    private String getOSVersion() {
        return System.getProperty("os.version");
    }

    private File upToApp(File file) {
        File executable;
        for (executable = file; executable != null && !executable.getPath().endsWith(APP_SUFFIX); executable = executable.getParentFile()) {
        }
        return executable;
    }

    private void modifyShortcutPath(FileShortcut shortcut) {
        File target;
        if (shortcut.canModifyPath() && (target = this.upToApp(shortcut.getTarget())) != null) {
            shortcut.setTarget(target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean modifyDockLink(FileShortcut shortcut, File dockFile, boolean adding) {
        OutputStream outputStream = null;
        boolean modified = false;
        try {
            if (shortcut instanceof FileShortcut) {
                String nodeName;
                Element array;
                this.modifyShortcutPath(shortcut);
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                documentBuilder.setEntityResolver(new PropertyListEntityResolver());
                LogManager.log(4, "    parsing xml file...");
                Document document = documentBuilder.parse(dockFile);
                LogManager.log(4, "    ...complete");
                LogManager.log(4, "    getting root element");
                Element root = document.getDocumentElement();
                LogManager.log(4, "    getting root/dict element");
                Element dict = XMLUtils.getChild(root, "dict");
                LogManager.log(4, "    getting root/dict/[key=persistent-apps] element. dict = " + dict.getNodeName());
                LogManager.log(4, "Get Keys");
                List<Element> keys = XMLUtils.getChildren(dict, "key");
                LogManager.log(4, "Length = " + keys.size());
                Element persistentAppsKeyNode = null;
                int index = 0;
                while (keys.get(index) != null) {
                    if (keys.get(index).getTextContent().equals("persistent-apps")) {
                        persistentAppsKeyNode = keys.get(index);
                        break;
                    }
                    ++index;
                }
                if (persistentAppsKeyNode == null) {
                    LogManager.log(4, "    Not found.. strange.. Create new one");
                    persistentAppsKeyNode = XMLUtils.appendChild(dict, "key", "persistent-apps");
                } else {
                    LogManager.log(4, "    done. KeyNode = " + persistentAppsKeyNode.getTextContent());
                }
                LogManager.log(4, "    Getting next element.. expecting it to be array element");
                Node arrayIt = array = keys.get(index);
                int MAX_SEARCH_ELEMENTS = 20;
                for (index = 0; !(index >= MAX_SEARCH_ELEMENTS || arrayIt == null || (nodeName = arrayIt.getNodeName()) != null && nodeName.equals("array") && arrayIt instanceof Element); arrayIt = arrayIt.getNextSibling(), ++index) {
                }
                if (index == MAX_SEARCH_ELEMENTS || arrayIt == null) {
                    LogManager.log(4, "    is not an array element... very strange");
                    boolean bl = false;
                    return bl;
                }
                array = arrayIt;
                if (array == null) {
                    LogManager.log(4, "    null... very strange");
                    boolean bl = false;
                    return bl;
                }
                LogManager.log(4, "    OK. Content = " + array.getNodeName());
                if (!array.getNodeName().equals("array")) {
                    LogManager.log(4, "    Not an array element");
                    boolean bl = false;
                    return bl;
                }
                if (adding) {
                    LogManager.log(4, "Adding shortcut with the following properties: ");
                    LogManager.log(4, "    target = " + shortcut.getTargetPath());
                    LogManager.log(4, "    name = " + shortcut.getName());
                    dict = XMLUtils.appendChild(array, "dict", null);
                    XMLUtils.appendChild(dict, "key", "tile-data");
                    Element dictChild = XMLUtils.appendChild(dict, "dict", null);
                    XMLUtils.appendChild(dictChild, "key", "file-data");
                    Element dictCC = XMLUtils.appendChild(dictChild, "dict", null);
                    XMLUtils.appendChild(dictCC, "key", "_CFURLString");
                    XMLUtils.appendChild(dictCC, "string", shortcut.getTargetPath());
                    XMLUtils.appendChild(dictCC, "key", "_CFURLStringType");
                    XMLUtils.appendChild(dictCC, "integer", "0");
                    XMLUtils.appendChild(dictChild, "key", "file-label");
                    XMLUtils.appendChild(dictChild, "string", shortcut.getName());
                    XMLUtils.appendChild(dictChild, "key", "file-type");
                    XMLUtils.appendChild(dictChild, "integer", "41");
                    XMLUtils.appendChild(dict, "key", "tile-type");
                    XMLUtils.appendChild(dict, "string", "file-tile");
                    LogManager.log(4, "... adding shortcut to Dock XML finished");
                    modified = true;
                } else {
                    LogManager.log(4, "Removing shortcut with the following properties: ");
                    LogManager.indent();
                    LogManager.log(4, "    target = " + shortcut.getTargetPath());
                    LogManager.log(4, "name = " + shortcut.getName());
                    String location = shortcut.getTargetPath();
                    LinkedList<Element> dcts = new LinkedList<Element>();
                    for (Element el1 : XMLUtils.getChildren(array, "dict")) {
                        for (Element el2 : XMLUtils.getChildren(el1, "dict")) {
                            for (Element el3 : XMLUtils.getChildren(el2, "dict")) {
                                dcts.addAll(XMLUtils.getChildren(el3, "string"));
                            }
                        }
                    }
                    Node dct = null;
                    LogManager.log(4, "Total dict/dict/dict/string items = " + dcts.size());
                    LogManager.log(4, "        location = " + location);
                    File locationFile = new File(location);
                    for (index = 0; index < dcts.size() && dcts.get(index) != null; ++index) {
                        File contentFile;
                        Node item = (Node)dcts.get(index);
                        String content = item.getTextContent();
                        LogManager.log(4, "        content = " + content);
                        if (content == null || content.equals("")) continue;
                        if (content.startsWith(FILE_LOCALHOST)) {
                            content = content.substring(FILE_LOCALHOST.length());
                        }
                        if (!locationFile.equals(contentFile = new File(content))) continue;
                        dct = item;
                        break;
                    }
                    if (dct != null) {
                        LogManager.log(4, "Shortcut exists in the dock.plist");
                        array.removeChild(dct.getParentNode().getParentNode().getParentNode());
                        modified = true;
                    } else {
                        LogManager.log(4, "... shortcut doesn`t exist in the dock.plist");
                        modified = false;
                    }
                    LogManager.unindent();
                    LogManager.log(4, "... removing shortcut from Dock XML finished");
                }
                if (modified) {
                    LogManager.log(4, "    Saving XML... ");
                    XMLUtils.saveXMLDocument(document, dockFile);
                    LogManager.log(4, "    Done (saving xml)");
                }
            } else {
                LogManager.log(4, "Adding non-file shortcuts to the Dock is not supported");
            }
        }
        catch (ParserConfigurationException e) {
            LogManager.log(2, (Throwable)e);
            boolean bl = false;
            return bl;
        }
        catch (XMLException e) {
            LogManager.log(2, (Throwable)e);
            boolean bl = false;
            return bl;
        }
        catch (SAXException e) {
            LogManager.log(2, (Throwable)e);
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            LogManager.log(2, (Throwable)e);
            boolean bl = false;
            return bl;
        }
        catch (NullPointerException e) {
            LogManager.log(2, (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException ex) {
                    LogManager.log(2, "Can`t close stream for Dock properties file");
                }
            }
        }
        LogManager.log(4, "    Return " + modified + " from modifyDockLink");
        return modified;
    }

    private File getDockPropertiesFile() {
        return new File(SystemUtils.getUserHomeDirectory(), "Library/Preferences/com.apple.dock.plist");
    }

    private int convertDockProperties(boolean decode) {
        File dockFile = this.getDockPropertiesFile();
        int returnResult = 0;
        try {
            if (!this.isCheetah() && !this.isPuma() && (!decode && (this.isTiger() || this.isLeopard() || this.isSnowLeopard()) || decode)) {
                ExecutionResults result = SystemUtils.executeCommand(null, new String[]{PLUTILS, PLUTILS_CONVERT, decode ? PLUTILS_CONVERT_XML : PLUTILS_CONVERT_BINARY, dockFile.getPath()});
                returnResult = result.getErrorCode();
            }
        }
        catch (IOException ex) {
            LogManager.log(2, (Throwable)ex);
            returnResult = -1;
        }
        return returnResult;
    }

    @Override
    protected String[] getPossibleBrowserLocations() {
        return POSSIBLE_BROWSER_LOCATIONS_MAC;
    }

    private class PropertyListEntityResolver
    implements EntityResolver {
        public static final String PROPERTTY_LIST_DTD_LOCAL = "/System/Library/DTDs/PropertyList.dtd";
        public static final String PROPERTTY_LIST_DTD_REMOTE = "http://www.apple.com/DTDs/PropertyList-1.0.dtd";
        public static final String PROPERTTY_LIST_DTD_PUBLIC_ID = "-//Apple Computer//DTD PLIST 1.0//EN";

        private PropertyListEntityResolver() {
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            File propDtd = new File(PROPERTTY_LIST_DTD_LOCAL);
            return (PROPERTTY_LIST_DTD_PUBLIC_ID.equals(publicId) || PROPERTTY_LIST_DTD_REMOTE.equals(systemId)) && FileUtils.exists(propDtd) ? new InputSource(new FileInputStream(propDtd)) : null;
        }
    }
}

