/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.utils.system.resolver;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.netbeans.installer.utils.system.resolver.BundlePropertyResolver;
import org.netbeans.installer.utils.system.resolver.EnvironmentVariableResolver;
import org.netbeans.installer.utils.system.resolver.FieldResolver;
import org.netbeans.installer.utils.system.resolver.MethodResolver;
import org.netbeans.installer.utils.system.resolver.NameResolver;
import org.netbeans.installer.utils.system.resolver.ResourceResolver;
import org.netbeans.installer.utils.system.resolver.StringResolver;
import org.netbeans.installer.utils.system.resolver.SystemPropertyResolver;

public class StringResolverUtil {
    private static List<StringResolver> list;

    public static final String resolve(String string, ClassLoader loader) {
        StringResolver resolver;
        String parsed = string;
        if (parsed == null) {
            return null;
        }
        if (list == null) {
            list = StringResolverUtil.createStringResolvers();
        }
        Iterator<StringResolver> iterator = list.iterator();
        while (iterator.hasNext() && (parsed = (resolver = iterator.next()).resolve(parsed, loader)) != null) {
        }
        return parsed;
    }

    private static List<StringResolver> createStringResolvers() {
        ArrayList<StringResolver> srlist = new ArrayList<StringResolver>();
        srlist.add(new NameResolver());
        srlist.add(new BundlePropertyResolver());
        srlist.add(new FieldResolver());
        srlist.add(new MethodResolver());
        srlist.add(new ResourceResolver());
        srlist.add(new SystemPropertyResolver());
        srlist.add(new EnvironmentVariableResolver());
        return srlist;
    }
}

