/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.wizard.components.actions;

import java.io.IOException;
import org.netbeans.installer.utils.EngineUtils;
import org.netbeans.installer.utils.ErrorManager;
import org.netbeans.installer.utils.ResourceUtils;
import org.netbeans.installer.utils.progress.Progress;
import org.netbeans.installer.wizard.components.WizardAction;

public class CacheEngineAction
extends WizardAction {
    public static final String DEFAULT_TITLE = ResourceUtils.getString(CacheEngineAction.class, "CEA.title");
    public static final String DEFAULT_DESCRIPTION = ResourceUtils.getString(CacheEngineAction.class, "CEA.description");
    public static final String ERROR_CANNOT_CACHE_ENGINE_KEY = "CEA.error.cannot.cache.engine";

    public CacheEngineAction() {
        this.setProperty("title", DEFAULT_TITLE);
        this.setProperty("description", DEFAULT_DESCRIPTION);
    }

    @Override
    public void execute() {
        try {
            Progress progress = new Progress();
            this.getWizardUi().setProgress(progress);
            EngineUtils.cacheEngine(progress);
        }
        catch (IOException e) {
            ErrorManager.notifyCritical(ResourceUtils.getString(CacheEngineAction.class, ERROR_CANNOT_CACHE_ENGINE_KEY), e);
        }
    }

    @Override
    public boolean isCancelable() {
        return false;
    }
}

