/*
 * Decompiled with CFR 0.152.
 */
package com.jme.ant;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.LogLevel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class UpdateNetBeansDependencies
extends Task {
    File projectFile;
    File platformFolder;
    private HashMap<String, String> versionMap = new HashMap();

    public void execute() throws BuildException {
        if (this.projectFile == null || this.platformFolder == null) {
            throw new BuildException("Please set projectfile and version");
        }
        this.clearVesionMap();
        this.gatherVersionMap(this.platformFolder);
        try {
            boolean change = false;
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(this.projectFile);
            Element project = doc.getDocumentElement();
            if (project == null) {
                return;
            }
            Element configuration = this.findChildElement(project, "configuration");
            if (configuration == null) {
                return;
            }
            Element data = this.findChildElement(configuration, "data");
            if (data == null) {
                return;
            }
            Element deps = this.findChildElement(data, "module-dependencies");
            if (deps == null) {
                return;
            }
            NodeList list = deps.getElementsByTagName("dependency");
            for (int i = 0; i < list.getLength(); ++i) {
                Element specVersion;
                Element runDep;
                Element elem = (Element)list.item(i);
                Element base = this.findChildElement(elem, "code-name-base");
                if (base == null || (runDep = this.findChildElement(elem, "run-dependency")) == null || (specVersion = this.findChildElement(runDep, "specification-version")) == null) continue;
                String name = base.getTextContent().trim();
                String version = specVersion.getTextContent().trim();
                String newVersion = this.versionMap.get(name);
                if (newVersion != null && !newVersion.equals(version)) {
                    specVersion.setTextContent(newVersion);
                    change = true;
                    this.log("Updating dependency in for " + name + " to " + newVersion);
                    continue;
                }
                if (newVersion == null) {
                    this.log("Unknown " + name + ", cannot update dependency.", LogLevel.WARN.getLevel());
                    continue;
                }
                this.log("Dependency " + name + " is up to date.", LogLevel.INFO.getLevel());
            }
            if (change) {
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                DOMSource source = new DOMSource(doc);
                StreamResult result = new StreamResult(this.projectFile);
                transformer.transform(source, result);
                OutputStreamWriter out = new OutputStreamWriter(new BufferedOutputStream(new FileOutputStream(this.projectFile, true)));
                out.write("\n");
                out.close();
            }
        }
        catch (Exception ex) {
            throw new BuildException("Error changing file: " + ex);
        }
    }

    public void setProjectFile(File projectFile) {
        this.projectFile = projectFile;
    }

    public void setPlatformFolder(File platformFolder) {
        this.platformFolder = platformFolder;
    }

    private void clearVesionMap() {
        this.versionMap.clear();
    }

    private void gatherVersionMap(File baseFolder) {
        File[] packages;
        for (File pkg : packages = baseFolder.listFiles()) {
            if (!pkg.isDirectory()) continue;
            for (File utr : pkg.listFiles()) {
                File[] xmls;
                if (!utr.isDirectory() || !utr.getName().equals("update_tracking")) continue;
                for (File file : xmls = utr.listFiles()) {
                    if (!file.getName().toLowerCase().endsWith(".xml")) continue;
                    this.parseModules(file);
                }
            }
        }
    }

    private void parseModules(File file) {
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(file);
            if (doc == null) {
                return;
            }
            Element moduleElement = doc.getDocumentElement();
            if (moduleElement == null || !moduleElement.getTagName().equalsIgnoreCase("module")) {
                return;
            }
            Element versionElement = this.findChildElement(moduleElement, "module_version");
            if (versionElement == null) {
                return;
            }
            String name = moduleElement.getAttribute("codename");
            int idx = name.indexOf("/");
            if (idx != -1) {
                name = name.substring(0, idx);
            }
            String version = versionElement.getAttribute("specification_version");
            this.versionMap.put(name, version);
        }
        catch (SAXException ex) {
            Logger.getLogger(UpdateNetBeansDependencies.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(UpdateNetBeansDependencies.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ParserConfigurationException ex) {
            Logger.getLogger(UpdateNetBeansDependencies.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private Element findChildElement(Element parent, String name) {
        Node ret;
        if (parent == null) {
            return null;
        }
        for (ret = parent.getFirstChild(); !(ret == null || ret instanceof Element && ret.getNodeName().equals(name)); ret = ret.getNextSibling()) {
        }
        return (Element)ret;
    }
}

