/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.java2d.renderer.fonts;

import de.lessvoid.nifty.java2d.renderer.fonts.CharacterInfo;
import de.lessvoid.nifty.tools.resourceloader.NiftyResourceLoader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.Collection;
import java.util.HashMap;
import javax.annotation.Nonnull;

@Deprecated
public class AngelCodeFont {
    private String name;
    @Nonnull
    private HashMap<Integer, String> textures = new HashMap();
    private int width;
    private int height;
    private int lineHeight;
    @Nonnull
    private HashMap<Character, CharacterInfo> chars = new HashMap();
    private NiftyResourceLoader resourceLoader;

    public AngelCodeFont(NiftyResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public boolean load(@Nonnull String filename) {
        InputStream in = this.resourceLoader.getResourceAsStream(filename);
        if (in == null) {
            return false;
        }
        return this.load(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load(@Nonnull InputStream in) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                HashMap<String, Object> values;
                if (line.startsWith("info")) {
                    values = this.getInfoLine(line);
                    this.parseInfo(values);
                    continue;
                }
                if (line.startsWith("common")) {
                    values = this.splitToInteger(line);
                    this.parseCommon(values);
                    continue;
                }
                if (line.startsWith("page")) {
                    values = this.getPageLine(line);
                    this.parsePage(values);
                    continue;
                }
                if (line.startsWith("chars")) {
                    values = this.splitToInteger(line);
                    this.parseChars(values);
                    continue;
                }
                if (line.startsWith("char")) {
                    values = this.splitToInteger(line);
                    this.parseChar(values);
                    continue;
                }
                if (line.startsWith("kernings")) {
                    values = this.splitToInteger(line);
                    this.parseKernings(values);
                    continue;
                }
                if (!line.startsWith("kerning")) continue;
                values = this.splitToInteger(line);
                this.parseKerning(values);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ignored) {}
        }
        return true;
    }

    private void parseInfo(@Nonnull HashMap<String, String> line) {
        this.name = line.get("face");
    }

    private void parseCommon(@Nonnull HashMap<String, Integer> line) {
        this.width = line.get("scaleW");
        this.height = line.get("scaleH");
    }

    private void parsePage(@Nonnull HashMap<String, String> line) {
        Integer id = Integer.parseInt(line.get("id"));
        this.textures.put(id, line.get("file"));
    }

    private void parseChars(HashMap<String, Integer> line) {
    }

    private void parseChar(@Nonnull HashMap<String, Integer> line) {
        CharacterInfo c = new CharacterInfo();
        c.setId(line.get("id"));
        c.setX(line.get("x"));
        c.setY(line.get("y"));
        c.setWidth(line.get("width"));
        c.setHeight(line.get("height"));
        c.setXoffset(line.get("xoffset"));
        c.setYoffset(line.get("yoffset"));
        c.setXadvance(line.get("xadvance"));
        c.setPage(line.get("page"));
        this.chars.put(Character.valueOf((char)c.getId()), c);
        this.lineHeight = Math.max(c.getHeight() + c.getYoffset(), this.lineHeight);
    }

    private void parseKernings(HashMap<String, Integer> line) {
    }

    private void parseKerning(@Nonnull HashMap<String, Integer> line) {
        int first = line.get("first");
        int second = line.get("second");
        int amount = line.get("amount");
        CharacterInfo info = this.chars.get(Character.valueOf((char)first));
        info.getKerning().put(Character.valueOf((char)second), amount);
    }

    @Nonnull
    private HashMap<String, Integer> splitToInteger(@Nonnull String line) {
        HashMap<String, Integer> table = new HashMap<String, Integer>();
        String[] values = line.split(" ");
        for (int i = 0; i < values.length; ++i) {
            String[] current = values[i].split("=");
            if (current.length > 1) {
                table.put(current[0], Integer.valueOf(current[1]));
                continue;
            }
            table.put(current[0], null);
        }
        return table;
    }

    @Nonnull
    private HashMap<String, String> getInfoLine(@Nonnull String line) {
        HashMap<String, String> table = new HashMap<String, String>();
        try {
            StreamTokenizer tokenizer = new StreamTokenizer(new StringReader(line));
            tokenizer.whitespaceChars(32, 32);
            tokenizer.parseNumbers();
            tokenizer.quoteChar(34);
            tokenizer.nextToken();
            tokenizer.nextToken();
            tokenizer.nextToken();
            tokenizer.nextToken();
            table.put("face", tokenizer.sval);
            tokenizer.nextToken();
            tokenizer.nextToken();
            tokenizer.nextToken();
            table.put("size", Integer.toString((int)tokenizer.nval));
            tokenizer.nextToken();
            tokenizer.nextToken();
            tokenizer.nextToken();
            table.put("bold", Integer.toString((int)tokenizer.nval));
            tokenizer.nextToken();
            tokenizer.nextToken();
            tokenizer.nextToken();
            table.put("italic", Integer.toString((int)tokenizer.nval));
            tokenizer.nextToken();
            tokenizer.nextToken();
            tokenizer.nextToken();
            table.put("charset", tokenizer.sval);
            tokenizer.nextToken();
            tokenizer.nextToken();
            tokenizer.nextToken();
            table.put("unicode", Integer.toString((int)tokenizer.nval));
            tokenizer.nextToken();
            tokenizer.nextToken();
            tokenizer.nextToken();
            table.put("stretchH", Integer.toString((int)tokenizer.nval));
            tokenizer.nextToken();
            tokenizer.nextToken();
            tokenizer.nextToken();
            table.put("smooth", Integer.toString((int)tokenizer.nval));
            tokenizer.nextToken();
            tokenizer.nextToken();
            tokenizer.nextToken();
            table.put("aa", Integer.toString((int)tokenizer.nval));
            tokenizer.nextToken();
            tokenizer.nextToken();
            tokenizer.nextToken();
            String padding = Integer.toString((int)tokenizer.nval);
            tokenizer.nextToken();
            padding = padding + "," + Integer.toString((int)tokenizer.nval);
            tokenizer.nextToken();
            padding = padding + "," + Integer.toString((int)tokenizer.nval);
            tokenizer.nextToken();
            padding = padding + "," + Integer.toString((int)tokenizer.nval);
            table.put("padding", padding);
            tokenizer.nextToken();
            tokenizer.nextToken();
            tokenizer.nextToken();
            String spacing = Integer.toString((int)tokenizer.nval);
            tokenizer.nextToken();
            spacing = spacing + "," + Integer.toString((int)tokenizer.nval);
            table.put("spacing", spacing);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return table;
    }

    @Nonnull
    private HashMap<String, String> getPageLine(@Nonnull String line) {
        HashMap<String, String> table = new HashMap<String, String>();
        try {
            StreamTokenizer tokenizer = new StreamTokenizer(new StringReader(line));
            tokenizer.whitespaceChars(32, 32);
            tokenizer.parseNumbers();
            tokenizer.quoteChar(34);
            tokenizer.nextToken();
            tokenizer.nextToken();
            tokenizer.nextToken();
            tokenizer.nextToken();
            table.put("id", Integer.toString((int)tokenizer.nval));
            tokenizer.nextToken();
            tokenizer.nextToken();
            tokenizer.nextToken();
            table.put("file", tokenizer.sval);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return table;
    }

    public String getName() {
        return this.name;
    }

    @Nonnull
    public String[] getTextures() {
        Collection<String> var = this.textures.values();
        return var.toArray(new String[var.size()]);
    }

    public int getNumChars() {
        return this.chars.size();
    }

    public CharacterInfo getChar(char c) {
        return this.chars.get(Character.valueOf(c));
    }

    @Nonnull
    public HashMap<Character, CharacterInfo> getChars() {
        return this.chars;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getLineHeight() {
        return this.lineHeight;
    }
}

