/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.examples.all;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.batch.BatchRenderDevice;
import de.lessvoid.nifty.batch.spi.BatchRenderBackend;
import de.lessvoid.nifty.examples.LwjglInitHelper;
import de.lessvoid.nifty.examples.NiftyExample;
import de.lessvoid.nifty.renderer.lwjgl.render.batch.LwjglBatchRenderBackend;
import de.lessvoid.nifty.sound.openal.OpenALSoundDevice;
import de.lessvoid.nifty.spi.input.InputSystem;
import de.lessvoid.nifty.spi.render.RenderDevice;
import de.lessvoid.nifty.spi.sound.SoundDevice;
import de.lessvoid.nifty.spi.time.TimeProvider;
import de.lessvoid.nifty.spi.time.impl.AccurateTimeProvider;

public class AllExamplesMain
implements NiftyExample {
    private static final String ALL_INTRO_XML = "all/intro.xml";
    private final String startScreen;

    public AllExamplesMain() {
        this("start");
    }

    private AllExamplesMain(String screen) {
        this.startScreen = screen;
    }

    public static void main(String[] args) {
        if (!LwjglInitHelper.initSubSystems("Nifty Examples")) {
            System.exit(0);
        }
        BatchRenderDevice renderDevice = new BatchRenderDevice((BatchRenderBackend)new LwjglBatchRenderBackend(), 2048, 2048);
        Nifty nifty = new Nifty((RenderDevice)renderDevice, (SoundDevice)new OpenALSoundDevice(), (InputSystem)LwjglInitHelper.getInputSystem(), (TimeProvider)new AccurateTimeProvider());
        nifty.createImage("nifty-logo-150x150.png", true);
        if (args.length == 1) {
            nifty.fromXml(ALL_INTRO_XML, args[0]);
        } else {
            nifty.fromXml(ALL_INTRO_XML, "start");
        }
        boolean done = false;
        while (!done) {
            LwjglInitHelper.renderLoop(nifty, null);
            done = true;
        }
        LwjglInitHelper.destroy();
    }

    @Override
    public String getStartScreen() {
        return this.startScreen;
    }

    @Override
    public String getMainXML() {
        return ALL_INTRO_XML;
    }

    @Override
    public String getTitle() {
        return "Nifty Examples";
    }

    @Override
    public void prepareStart(Nifty nifty) {
    }
}

