/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.jheora;

import com.fluendo.jheora.Constants;
import com.fluendo.jheora.Info;
import com.jcraft.jogg.Buffer;

public class Quant {
    private static int ilog(long v) {
        int ret = 0;
        while (v != 0L) {
            ++ret;
            v >>= 1;
        }
        return ret;
    }

    public static int readQTables(Info ci, Buffer opb) {
        long value;
        int x;
        int[][] NQRS = new int[2][3];
        int[][][] QRSIZES = new int[2][3][63];
        int[][][] QRBMIS = new int[2][3][64];
        long NBITS = opb.readB(4);
        ++NBITS;
        for (x = 0; x < 64; ++x) {
            value = opb.readB((int)NBITS);
            if (NBITS < 0L) {
                return -20;
            }
            ci.AcScaleFactorTable[x] = (int)value;
        }
        NBITS = opb.readB(4);
        ++NBITS;
        for (x = 0; x < 64; ++x) {
            value = opb.readB((int)NBITS);
            if (NBITS < 0L) {
                return -20;
            }
            ci.DcScaleFactorTable[x] = (short)value;
        }
        int NBMS = opb.readB(9);
        if (++NBMS > 384) {
            return -20;
        }
        ci.MaxQMatrixIndex = NBMS;
        ci.qmats = new short[NBMS * 64];
        for (int bmi = 0; bmi < NBMS; ++bmi) {
            for (x = 0; x < 64; ++x) {
                value = opb.readB(8);
                if (NBITS < 0L) {
                    return -20;
                }
                ci.qmats[(bmi << 6) + x] = (short)value;
            }
        }
        for (int qti = 0; qti <= 1; ++qti) {
            for (int pli = 0; pli <= 2; ++pli) {
                int NEWQR = qti > 0 || pli > 0 ? opb.readB(1) : 1;
                if (NEWQR == 0) {
                    int plj;
                    int qtj;
                    int RPQR = qti > 0 ? opb.readB(1) : 0;
                    if (RPQR == 1) {
                        qtj = qti - 1;
                        plj = pli;
                    } else {
                        qtj = (3 * qti + pli - 1) / 3;
                        plj = (pli + 2) % 3;
                    }
                    NQRS[qti][pli] = NQRS[qtj][plj];
                    QRSIZES[qti][pli] = QRSIZES[qtj][plj];
                    QRBMIS[qti][pli] = QRBMIS[qtj][plj];
                    continue;
                }
                int qri = 0;
                int qi = 0;
                QRBMIS[qti][pli][qri] = opb.readB(Quant.ilog(NBMS - 1));
                if (QRBMIS[qti][pli][qri] >= NBMS) {
                    System.out.println("bad header (1)");
                    return -20;
                }
                do {
                    QRSIZES[qti][pli][qri] = opb.readB(Quant.ilog(62 - qi)) + 1;
                    QRBMIS[qti][pli][++qri] = opb.readB(Quant.ilog(NBMS - 1));
                } while ((qi += QRSIZES[qti][pli][qri]) < 63);
                if (qi > 63) {
                    System.out.println("bad header (2): " + qi);
                    return -20;
                }
                NQRS[qti][pli] = qri;
            }
        }
        for (int coding = 0; coding < 2; ++coding) {
            for (int plane = 0; plane < 3; ++plane) {
                for (int quality = 0; quality < 64; ++quality) {
                    short[] scaledmat = Quant.compQuantMatrix(ci.AcScaleFactorTable, ci.DcScaleFactorTable, ci.qmats, NQRS, QRSIZES, QRBMIS, coding, plane, quality);
                    for (int coeff = 0; coeff < 64; ++coeff) {
                        int j = Constants.dequant_index[coeff];
                        ci.dequant_tables[coding][plane][quality][coeff] = scaledmat[j];
                    }
                }
            }
        }
        return 0;
    }

    static short[] compQuantMatrix(int[] ACSCALE, short[] DCSCALE, short[] BMS, int[][] NQRS, int[][][] QRSIZES, int[][][] QRBMIS, int qti, int pli, int qi) {
        int qrj;
        int qri;
        short[] QMAT = new short[64];
        for (qri = 0; qri < 63; ++qri) {
            int sum1 = 0;
            for (qrj = 0; qrj < qri; ++qrj) {
                sum1 += QRSIZES[qti][pli][qrj];
            }
            int sum2 = 0;
            for (qrj = 0; qrj <= qri; ++qrj) {
                sum2 += QRSIZES[qti][pli][qrj];
            }
            if (qi >= sum1 && qi <= sum2) break;
        }
        int QISTART = 0;
        for (qrj = 0; qrj < qri; ++qrj) {
            QISTART += QRSIZES[qti][pli][qrj];
        }
        int QIEND = 0;
        for (qrj = 0; qrj <= qri; ++qrj) {
            QIEND += QRSIZES[qti][pli][qrj];
        }
        int bmi = QRBMIS[qti][pli][qri];
        int bmj = QRBMIS[qti][pli][qri + 1];
        int[] BM = new int[64];
        for (int ci = 0; ci < 64; ++ci) {
            BM[ci] = (2 * (QIEND - qi) * BMS[(bmi << 6) + ci] + 2 * (qi - QISTART) * BMS[(bmj << 6) + ci] + QRSIZES[qti][pli][qri]) / (2 * QRSIZES[qti][pli][qri]);
            int QMIN = ci == 0 && qti == 0 ? 16 : (ci > 0 && qti == 0 ? 8 : (ci == 0 && qti == 1 ? 32 : 16));
            int QSCALE = ci == 0 ? DCSCALE[qi] : ACSCALE[qi];
            QMAT[ci] = (short)Math.max(QMIN, Math.min(QSCALE * BM[ci] / 100 * 4, 4096));
        }
        return QMAT;
    }
}

