/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.utils.system.resolver;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.installer.utils.ErrorManager;
import org.netbeans.installer.utils.StringUtils;
import org.netbeans.installer.utils.SystemUtils;
import org.netbeans.installer.utils.exceptions.NativeException;
import org.netbeans.installer.utils.system.resolver.StringResolver;

public class EnvironmentVariableResolver
implements StringResolver {
    public String resolve(String string, ClassLoader loader) {
        String parsed = string;
        Matcher matcher = Pattern.compile("(?<!\\\\)\\$E\\{(.*?)\\}").matcher(parsed);
        while (matcher.find()) {
            try {
                String name = matcher.group(1);
                String value = SystemUtils.getEnvironmentVariable(name);
                if (value == null) continue;
                parsed = parsed.replace(matcher.group(), value);
            }
            catch (NativeException e) {
                ErrorManager.notifyDebug(StringUtils.format(ERROR_CANNOT_PARSE_PATTERN, matcher.group()), e);
            }
        }
        return parsed;
    }
}

