/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jellytools;

import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Window;
import javax.swing.JTable;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.ComponentSearcher;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.WindowWaiter;
import org.netbeans.jemmy.operators.JTableOperator;

public class PopupSwitcherOperator
extends JTableOperator {
    public PopupSwitcherOperator() {
        this(PopupSwitcherOperator.waitPopupSwitcher());
    }

    public PopupSwitcherOperator(JTable lrTable) {
        super(lrTable);
    }

    public void selectItem(String isName) {
        Point lrLocation = this.findCell(isName, 0);
        if (lrLocation.equals(new Point(-1, -1))) {
            throw new JemmyException("Cannot select item \"" + isName + "\".");
        }
        this.selectCell(lrLocation.y, lrLocation.x);
    }

    public void selectItem(int inIndex) {
        int lnRowCount = this.getRowCount();
        if (lnRowCount == 0) {
            throw new JemmyException("Cannot select item with index \"" + inIndex + "\", table is empty.");
        }
        int lnColumn = 0;
        if (inIndex > lnRowCount) {
            lnColumn = inIndex / lnRowCount;
            inIndex %= lnRowCount;
        }
        this.selectCell(inIndex, lnColumn);
    }

    public void selectItem(int inRow, int inColumn) {
        this.selectCell(inRow, inColumn);
    }

    public static JTable waitPopupSwitcher() {
        Window lrPopupWindow = null;
        try {
            lrPopupWindow = new WindowWaiter().waitWindow((ComponentChooser)new PopupChooser(ComponentSearcher.getTrueChooser((String)"Any Popup window")));
        }
        catch (InterruptedException e) {
            throw new JemmyException("Waiting for popup window interrupted.");
        }
        return JTableOperator.waitJTable((Container)lrPopupWindow, (ComponentChooser)ComponentSearcher.getTrueChooser((String)"Any JTable"));
    }

    private static class PopupChooser
    implements ComponentChooser {
        private ComponentChooser subChooser;

        public PopupChooser(ComponentChooser irChooser) {
            this.subChooser = irChooser;
        }

        public boolean checkComponent(Component irComponent) {
            Class<?> lrClass = irComponent.getClass();
            do {
                if (!lrClass.getName().startsWith("javax.swing.Popup")) continue;
                return this.subChooser.checkComponent(irComponent);
            } while ((lrClass = lrClass.getSuperclass()) != null);
            return false;
        }

        public String getDescription() {
            return this.subChooser.getDescription();
        }
    }
}

