/*
 * Decompiled with CFR 0.152.
 */
package com.jme.ant;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UpdateSdkDependencies
extends Task {
    File projectFile;
    String version;
    String basePackage = "com.jme3.gde";

    public void execute() throws BuildException {
        if (this.projectFile == null || this.version == null) {
            throw new BuildException("Please set projectfile and version");
        }
        try {
            boolean change = false;
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(this.projectFile);
            Element project = doc.getDocumentElement();
            if (project == null) {
                return;
            }
            Element configuration = this.findChildElement(project, "configuration");
            if (configuration == null) {
                return;
            }
            Element data = this.findChildElement(configuration, "data");
            if (data == null) {
                return;
            }
            Element deps = this.findChildElement(data, "module-dependencies");
            if (deps == null) {
                return;
            }
            NodeList list = deps.getElementsByTagName("dependency");
            for (int i = 0; i < list.getLength(); ++i) {
                Element specVersion;
                Element runDep;
                Element elem = (Element)list.item(i);
                Element base = this.findChildElement(elem, "code-name-base");
                if (base == null || !base.getTextContent().trim().startsWith(this.basePackage) || (runDep = this.findChildElement(elem, "run-dependency")) == null || (specVersion = this.findChildElement(runDep, "specification-version")) == null || this.version.equals(specVersion.getTextContent().trim())) continue;
                specVersion.setTextContent(this.version);
                this.log("Updating plugin dependency in " + this.projectFile);
                change = true;
            }
            if (change) {
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                DOMSource source = new DOMSource(doc);
                StreamResult result = new StreamResult(this.projectFile);
                transformer.transform(source, result);
                OutputStreamWriter out = new OutputStreamWriter(new BufferedOutputStream(new FileOutputStream(this.projectFile, true)));
                out.write("\n");
                out.close();
            }
        }
        catch (Exception ex) {
            throw new BuildException("Error changing file: " + ex);
        }
    }

    public void setBasePackage(String basePackage) {
        this.basePackage = basePackage;
    }

    public void setProjectFile(File projectFile) {
        this.projectFile = projectFile;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    private Element findChildElement(Element parent, String name) {
        Node ret;
        if (parent == null) {
            return null;
        }
        for (ret = parent.getFirstChild(); !(ret == null || ret instanceof Element && ret.getNodeName().equals(name)); ret = ret.getNextSibling()) {
        }
        return (Element)ret;
    }
}

