/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.effects;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.effects.EffectEventId;
import de.lessvoid.nifty.effects.EffectEvents;
import de.lessvoid.nifty.effects.EffectImpl;
import de.lessvoid.nifty.effects.EffectProperties;
import de.lessvoid.nifty.effects.Falloff;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.render.NiftyRenderEngine;
import de.lessvoid.nifty.spi.time.TimeProvider;
import de.lessvoid.nifty.tools.time.TimeInterpolator;
import java.util.LinkedList;
import java.util.logging.Logger;

public class Effect {
    private static Logger log = Logger.getLogger(Effect.class.getName());
    private EffectEventId effectEventId;
    private boolean active;
    private Element element;
    private TimeInterpolator timeInterpolator;
    private EffectImpl effectImpl;
    private EffectProperties parameter;
    private boolean post;
    private boolean overlay;
    private String alternateEnable;
    private String alternateDisable;
    private String alternate;
    private String customKey;
    private boolean inherit;
    private Nifty nifty;
    private boolean hoverEffect;
    private boolean infiniteEffect;
    private Falloff falloff;
    private EffectEvents effectEvents;
    private boolean neverStopRendering;
    private boolean customFlag;

    public Effect(Nifty niftyParam, boolean inheritParam, boolean postParam, boolean overlayParam, String alternateEnableParam, String alternateDisableParam, String customKeyParam, boolean neverStopRenderingParam, EffectEventId effectEventIdParam) {
        this.nifty = niftyParam;
        this.inherit = inheritParam;
        this.post = postParam;
        this.overlay = overlayParam;
        this.active = false;
        this.alternateEnable = alternateEnableParam;
        this.alternateDisable = alternateDisableParam;
        this.alternate = null;
        this.customKey = customKeyParam;
        this.effectEventId = effectEventIdParam;
        this.hoverEffect = false;
        this.infiniteEffect = false;
        this.neverStopRendering = neverStopRenderingParam;
        this.effectEvents = new EffectEvents();
        this.customFlag = false;
    }

    public void enableHover(Falloff falloffParameter) {
        this.hoverEffect = true;
        this.falloff = falloffParameter;
    }

    public void enableInfinite() {
        this.infiniteEffect = true;
    }

    public void init(Element elementParam, EffectImpl effectImplParam, EffectProperties parameterParam, TimeProvider timeParam, LinkedList<Object> controllers) {
        this.element = elementParam;
        this.effectImpl = effectImplParam;
        this.parameter = parameterParam;
        this.parameter.put("effectEventId", (Object)this.effectEventId);
        this.timeInterpolator = new TimeInterpolator(this.parameter, timeParam, this.infiniteEffect);
        this.effectEvents.init(this.nifty, controllers, this.parameter);
        this.customFlag = false;
        if (this.hoverEffect) {
            this.element.setVisibleToMouseEvents(true);
        }
    }

    public boolean start(String alternate, String customKey) {
        this.alternate = alternate;
        if (!this.canStartEffect(alternate, customKey)) {
            return false;
        }
        log.info("starting effect [" + this.getStateString() + "] with customKey [" + customKey + "]");
        this.internalStart();
        return true;
    }

    private void internalStart() {
        this.active = true;
        this.timeInterpolator.start();
        this.effectEvents.onStartEffect(this.parameter);
        this.effectImpl.activate(this.nifty, this.element, this.parameter);
    }

    public void update() {
        this.setActiveInternal(this.timeInterpolator.update(), !this.neverStopRendering);
    }

    public void execute(NiftyRenderEngine r) {
        if (this.isHoverEffect()) {
            this.effectImpl.execute(this.element, this.timeInterpolator.getValue(), this.falloff, r);
        } else {
            this.effectImpl.execute(this.element, this.timeInterpolator.getValue(), null, r);
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public void deactivate() {
        this.setActiveInternal(false, true);
    }

    private void setActiveInternal(boolean newActive, boolean callDeactivate) {
        boolean ended = false;
        if (this.active && !newActive) {
            if (callDeactivate) {
                this.effectImpl.deactivate();
            }
            ended = true;
        }
        this.active = newActive;
        if (ended) {
            this.effectEvents.onEndEffect();
        }
    }

    public boolean isPost() {
        return this.post;
    }

    public boolean isAlternateDisable() {
        return this.alternateDisable != null;
    }

    public boolean customKeyMatches(String customKeyToCheck) {
        if (customKeyToCheck == null) {
            return this.customKey == null;
        }
        return customKeyToCheck.equals(this.customKey);
    }

    public String getStateString() {
        return "(" + this.effectImpl.getClass().getSimpleName() + "[" + this.customKey + "]" + ")";
    }

    public <T extends EffectImpl> T getEffectImpl(Class<T> requestedClass) {
        if (requestedClass.isInstance(this.effectImpl)) {
            return (T)((EffectImpl)requestedClass.cast(this.effectImpl));
        }
        return null;
    }

    public boolean isInherit() {
        return this.inherit;
    }

    public boolean isHoverEffect() {
        return this.hoverEffect;
    }

    public void hoverDistance(int x, int y) {
        if (this.falloff != null) {
            this.falloff.updateFalloffValue(this.element, x, y);
        }
    }

    public boolean isInsideFalloff(int x, int y) {
        if (this.falloff != null && this.falloff.getFalloffConstraint() != Falloff.HoverFalloffConstraint.none) {
            return this.falloff.isInside(this.element, x, y);
        }
        return this.element.isMouseInsideElement(x, y);
    }

    public boolean isOverlay() {
        return this.overlay;
    }

    public boolean isNeverStopRendering() {
        return this.neverStopRendering;
    }

    public EffectProperties getParameters() {
        return this.parameter;
    }

    public String getAlternate() {
        return this.alternate;
    }

    public String getCustomKey() {
        return this.customKey;
    }

    private boolean canStartEffect(String alternate, String customKey) {
        if (alternate == null) {
            if (this.isAlternateEnable()) {
                log.info("starting effect [" + this.getStateString() + "] canceled because alternateKey [" + alternate + "] and effect " + "isAlternateEnable()");
                return false;
            }
        } else {
            if (this.isAlternateDisable() && this.alternateDisableMatches(alternate)) {
                log.info("starting effect [" + this.getStateString() + "] canceled because alternateKey [" + alternate + "] matches " + "alternateDisableMatches()");
                return false;
            }
            if (this.isAlternateEnable() && !this.alternateEnableMatches(alternate)) {
                log.info("starting effect [" + this.getStateString() + "] canceled because alternateKey [" + alternate + "] does not " + "match alternateEnableMatches()");
                return false;
            }
        }
        if (!this.customKeyMatches(customKey)) {
            log.info("starting effect [" + this.getStateString() + "] canceled because customKey [" + customKey + "] does not match " + "key set at the effect");
            return false;
        }
        return true;
    }

    private boolean isAlternateEnable() {
        return this.alternateEnable != null;
    }

    private boolean alternateEnableMatches(String alternate) {
        return alternate != null && alternate.equals(this.alternateEnable);
    }

    private boolean alternateDisableMatches(String alternate) {
        return alternate != null && alternate.equals(this.alternateDisable);
    }

    public boolean getCustomFlag() {
        return this.customFlag;
    }

    public void setCustomFlag(boolean customFlag) {
        this.customFlag = customFlag;
    }
}

