/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.effects;

import de.lessvoid.nifty.EndNotify;
import de.lessvoid.nifty.effects.ActiveEffects;
import de.lessvoid.nifty.effects.Effect;
import de.lessvoid.nifty.effects.EffectImpl;
import de.lessvoid.nifty.effects.EffectProcessor;
import de.lessvoid.nifty.effects.NiftyRenderDeviceProxy;
import de.lessvoid.nifty.render.NiftyRenderEngine;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class EffectProcessorImpl
implements EffectProcessor {
    private static Logger log = Logger.getLogger(EffectProcessorImpl.class.getName());
    private Notify notify;
    private List<Effect> allEffects = new ArrayList<Effect>();
    private ActiveEffects activeEffects = new ActiveEffects();
    private List<Effect> activeEffectsToRemove = new ArrayList<Effect>();
    private List<Effect> pushedEffects = new ArrayList<Effect>();
    private boolean active = false;
    private EndNotify listener;
    private boolean neverStopRendering;
    private boolean processingEffects;
    private boolean pendingEffectsRemove;

    public EffectProcessorImpl(Notify notify, boolean neverStopRenderingParam) {
        this.notify = notify;
        this.neverStopRendering = neverStopRenderingParam;
    }

    @Override
    public void registerEffect(Effect e) {
        this.allEffects.add(e);
    }

    @Override
    public void getRenderStatesToSave(NiftyRenderDeviceProxy renderDeviceProxy) {
        if (this.isInactive()) {
            return;
        }
        renderDeviceProxy.reset();
        this.processingEffects = true;
        for (int i = 0; i < this.activeEffects.getActive().size(); ++i) {
            Effect e = this.activeEffects.getActive().get(i);
            if (!e.isInherit() || !this.isActive(e)) continue;
            e.execute(renderDeviceProxy);
        }
        this.checkPendingEffectsRemove();
    }

    @Override
    public void renderPre(NiftyRenderEngine renderDevice) {
        this.renderActive(renderDevice, this.activeEffects.getActivePre());
    }

    @Override
    public void renderPost(NiftyRenderEngine renderDevice) {
        this.renderActive(renderDevice, this.activeEffects.getActivePost());
    }

    @Override
    public void renderOverlay(NiftyRenderEngine renderDevice) {
        this.renderActive(renderDevice, this.activeEffects.getActiveOverlay());
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void saveActiveNeverStopRenderingEffects() {
        this.pushedEffects.clear();
        for (int i = 0; i < this.activeEffects.getActive().size(); ++i) {
            Effect e = this.activeEffects.getActive().get(i);
            if (!e.isNeverStopRendering()) continue;
            this.pushedEffects.add(e);
        }
        this.reset();
    }

    @Override
    public void restoreNeverStopRenderingEffects() {
        for (int i = 0; i < this.pushedEffects.size(); ++i) {
            Effect e = this.pushedEffects.get(i);
            this.activate(this.listener, e.getAlternate(), e.getCustomKey());
        }
    }

    @Override
    public void reset() {
        this.internalSetActive(false);
        for (int i = 0; i < this.activeEffects.getActive().size(); ++i) {
            Effect e = this.activeEffects.getActive().get(i);
            e.deactivate();
        }
        if (!this.processingEffects) {
            this.activeEffects.clear();
        } else {
            this.pendingEffectsRemove = true;
        }
    }

    @Override
    public void reset(String customKey) {
        this.activeEffectsToRemove.clear();
        for (int i = 0; i < this.activeEffects.getActive().size(); ++i) {
            Effect e = this.activeEffects.getActive().get(i);
            if (!e.customKeyMatches(customKey)) continue;
            e.deactivate();
            this.activeEffectsToRemove.add(e);
        }
        if (this.activeEffectsToRemove.size() == this.activeEffects.size()) {
            if (!this.processingEffects) {
                this.activeEffects.clear();
            } else {
                this.pendingEffectsRemove = true;
            }
        } else {
            for (Effect e : this.activeEffectsToRemove) {
                this.activeEffects.remove(e);
            }
        }
    }

    @Override
    public void activate(EndNotify newListener, String alternate, String customKey) {
        this.listener = newListener;
        for (int i = 0; i < this.allEffects.size(); ++i) {
            Effect e = this.allEffects.get(i);
            this.startEffect(e, alternate, customKey);
        }
        if (!this.activeEffects.isEmpty()) {
            this.internalSetActive(true);
            this.pendingEffectsRemove = false;
        }
    }

    @Override
    public String getStateString() {
        if (this.activeEffects.isEmpty()) {
            return "no active effects";
        }
        StringBuffer data = new StringBuffer();
        List<Effect> effects = this.activeEffects.getActive();
        for (int i = 0; i < effects.size(); ++i) {
            Effect e = effects.get(i);
            if (data.length() != 0) {
                data.append(", ");
            }
            data.append(e.getStateString());
        }
        return data.toString();
    }

    @Override
    public void setActive(boolean newActive) {
        this.internalSetActive(newActive);
        if (!this.active) {
            this.reset();
        }
    }

    @Override
    public void processHover(int x, int y) {
        for (int i = 0; i < this.allEffects.size(); ++i) {
            Effect e = this.allEffects.get(i);
            if (!e.isHoverEffect()) continue;
            if (!e.isActive() && e.isInsideFalloff(x, y)) {
                this.startEffect(e, null, null);
                this.setActive(true);
            }
            if (!e.isActive()) continue;
            if (!e.isInsideFalloff(x, y)) {
                e.deactivate();
                this.activeEffects.remove(e);
                continue;
            }
            e.hoverDistance(x, y);
        }
    }

    @Override
    public void processStartHover(int x, int y) {
        for (int i = 0; i < this.allEffects.size(); ++i) {
            Effect e = this.allEffects.get(i);
            if (!e.isHoverEffect()) continue;
            if (!e.isActive() && e.isInsideFalloff(x, y) && !e.getCustomFlag()) {
                this.startEffect(e, null, null);
                this.setActive(true);
                e.setCustomFlag(true);
            }
            if (e.isInsideFalloff(x, y) || !e.getCustomFlag()) continue;
            e.setCustomFlag(false);
            if (!e.isActive()) continue;
            e.deactivate();
            this.activeEffects.remove(e);
        }
    }

    @Override
    public void processEndHover(int x, int y) {
        for (int i = 0; i < this.allEffects.size(); ++i) {
            Effect e = this.allEffects.get(i);
            if (!e.isHoverEffect()) continue;
            if (!e.isActive()) {
                if (e.isInsideFalloff(x, y)) {
                    e.setCustomFlag(true);
                }
                if (!e.isInsideFalloff(x, y) && e.getCustomFlag()) {
                    this.startEffect(e, null, null);
                    this.setActive(true);
                    e.setCustomFlag(false);
                }
            }
            if (!e.isActive() || !e.isInsideFalloff(x, y) || e.getCustomFlag()) continue;
            e.setCustomFlag(true);
            e.deactivate();
            this.activeEffects.remove(e);
        }
    }

    @Override
    public void processHoverDeactivate(int x, int y) {
        for (int i = 0; i < this.allEffects.size(); ++i) {
            Effect e = this.allEffects.get(i);
            if (!e.isHoverEffect() || !e.isActive() || e.isInsideFalloff(x, y)) continue;
            e.deactivate();
            this.activeEffects.remove(e);
        }
    }

    @Override
    public void removeAllEffects() {
        this.allEffects.clear();
        this.activeEffects.clear();
    }

    @Override
    public <T extends EffectImpl> List<Effect> getEffects(Class<T> requestedClass) {
        ArrayList<Effect> result = new ArrayList<Effect>();
        for (int i = 0; i < this.allEffects.size(); ++i) {
            Effect effect = this.allEffects.get(i);
            T effectImpl = effect.getEffectImpl(requestedClass);
            if (effectImpl == null) continue;
            result.add(effect);
        }
        return result;
    }

    private void renderActive(NiftyRenderEngine renderDevice, List<Effect> effects) {
        if (this.isInactive()) {
            return;
        }
        this.processingEffects = true;
        for (int i = 0; i < effects.size(); ++i) {
            Effect e = effects.get(i);
            if (!this.isActive(e)) continue;
            e.update();
            if (!this.isActive(e)) continue;
            e.execute(renderDevice);
        }
        this.checkFinish();
        this.checkPendingEffectsRemove();
    }

    private void startEffect(Effect e, String alternate, String customKey) {
        if (!e.start(alternate, customKey)) {
            return;
        }
        if (!this.activeEffects.contains(e)) {
            log.info("adding effect as active");
            this.activeEffects.add(e);
        } else {
            log.info("NOT adding effect as active because it's already registered as active");
        }
    }

    private void checkFinish() {
        if (this.active && !this.activeEffects.containsActiveEffects()) {
            this.internalSetActive(false);
            if (this.listener != null) {
                this.listener.perform();
            }
        }
    }

    private void checkPendingEffectsRemove() {
        if (this.processingEffects) {
            if (this.pendingEffectsRemove) {
                this.activeEffects.clear();
                this.pendingEffectsRemove = false;
            }
            this.processingEffects = false;
        }
    }

    private boolean isInactive() {
        return !this.active && this.isNotNeverStopRendering();
    }

    private boolean isNotNeverStopRendering() {
        List<Effect> effects = this.activeEffects.getActive();
        for (int i = 0; i < effects.size(); ++i) {
            Effect e = effects.get(i);
            if (!e.isNeverStopRendering()) continue;
            return false;
        }
        return !this.neverStopRendering;
    }

    private boolean isActive(Effect e) {
        return e.isActive() || e.isNeverStopRendering() || this.neverStopRendering;
    }

    private void internalSetActive(boolean newActive) {
        boolean oldActive = this.active;
        this.active = newActive;
        if (newActive != oldActive) {
            this.notify.effectProcessorStateChanged(newActive);
        }
    }

    public static interface Notify {
        public void effectProcessorStateChanged(boolean var1);
    }
}

