/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.effects.impl;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.effects.EffectImpl;
import de.lessvoid.nifty.effects.EffectProperties;
import de.lessvoid.nifty.effects.Falloff;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.elements.render.ImageRenderer;
import de.lessvoid.nifty.render.NiftyImage;
import de.lessvoid.nifty.render.NiftyRenderEngine;
import de.lessvoid.nifty.render.image.ImageModeFactory;
import de.lessvoid.nifty.render.image.ImageModeHelper;
import java.util.logging.Logger;

public class ChangeImage
implements EffectImpl {
    private static Logger log = Logger.getLogger(ChangeImage.class.getName());
    private Element element;
    private NiftyImage activeImage;
    private NiftyImage inactiveImage;

    @Override
    public void activate(Nifty nifty, Element element, EffectProperties parameter) {
        this.element = element;
        this.activeImage = this.loadImage("active", nifty, parameter);
        this.inactiveImage = this.loadImage("inactive", nifty, parameter);
    }

    @Override
    public void execute(Element element, float normalizedTime, Falloff falloff, NiftyRenderEngine r) {
        this.changeElementImage(this.activeImage);
    }

    @Override
    public void deactivate() {
        this.changeElementImage(this.inactiveImage);
        this.activeImage.dispose();
        this.inactiveImage.dispose();
    }

    private NiftyImage loadImage(String name, Nifty nifty, EffectProperties parameter) {
        NiftyImage image = nifty.getRenderEngine().createImage(parameter.getProperty(name), false);
        String areaProviderProperty = ImageModeHelper.getAreaProviderProperty(parameter);
        String renderStrategyProperty = ImageModeHelper.getRenderStrategyProperty(parameter);
        if (areaProviderProperty != null || renderStrategyProperty != null) {
            image.setImageMode(ImageModeFactory.getSharedInstance().createImageMode(areaProviderProperty, renderStrategyProperty));
        }
        return image;
    }

    private void changeElementImage(NiftyImage image) {
        ImageRenderer imageRenderer = this.element.getRenderer(ImageRenderer.class);
        if (imageRenderer == null) {
            log.warning("this effect can only be applied to images!");
            return;
        }
        imageRenderer.setImage(image);
    }
}

