/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.effects.impl;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.effects.EffectImpl;
import de.lessvoid.nifty.effects.EffectProperties;
import de.lessvoid.nifty.effects.Falloff;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.render.NiftyImage;
import de.lessvoid.nifty.render.NiftyRenderEngine;
import de.lessvoid.nifty.render.image.ImageModeFactory;
import de.lessvoid.nifty.render.image.ImageModeHelper;
import de.lessvoid.nifty.tools.pulsate.Pulsator;

public class ImageOverlayPulsate
implements EffectImpl {
    private NiftyImage image;
    private Pulsator pulsater;

    @Override
    public void activate(Nifty nifty, Element element, EffectProperties parameter) {
        this.image = nifty.getRenderEngine().createImage(parameter.getProperty("filename"), true);
        String areaProviderProperty = ImageModeHelper.getAreaProviderProperty(parameter);
        String renderStrategyProperty = ImageModeHelper.getRenderStrategyProperty(parameter);
        if (areaProviderProperty != null || renderStrategyProperty != null) {
            this.image.setImageMode(ImageModeFactory.getSharedInstance().createImageMode(areaProviderProperty, renderStrategyProperty));
        }
        this.pulsater = new Pulsator(parameter, nifty.getTimeProvider());
    }

    @Override
    public void execute(Element element, float normalizedTime, Falloff falloff, NiftyRenderEngine r) {
        r.saveState(null);
        float value = this.pulsater.update();
        r.setColorAlpha(value);
        r.renderImage(this.image, element.getX(), element.getY(), element.getWidth(), element.getHeight());
        r.restoreState();
    }

    @Override
    public void deactivate() {
        this.image.dispose();
    }
}

