/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.render.image;

import de.lessvoid.nifty.ParameterizedObjectFactory;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;

public class ImageModeHelper {
    private static Logger log = Logger.getLogger(ParameterizedObjectFactory.class.getName());

    private ImageModeHelper() {
    }

    public static String getAreaProviderProperty(Properties properties) {
        return ImageModeHelper.getAreaProviderProperty(new StringPropertyAdapter(properties));
    }

    public static String getAreaProviderProperty(Map<String, String> properties) {
        String imageModeProperty = properties.get("imageMode");
        String property = ImageModeHelper.getAreaProviderProperty(imageModeProperty);
        if (property != null) {
            log.info("imageMode property converted to imageArea property : " + imageModeProperty + " -> " + property);
            return property;
        }
        return properties.get("imageArea");
    }

    public static String getAreaProviderProperty(String imageModeProperty) {
        if (imageModeProperty != null) {
            String[] imageMode = imageModeProperty.split(":");
            String imageModeName = imageMode[0];
            if (imageModeName.equals("normal") || imageModeName.equals("resize")) {
                return "fullimage";
            }
            if (imageModeName.equals("subImage") || imageModeName.equals("subImageDirect") || imageModeName.equals("repeat")) {
                return "subimage:" + ImageModeHelper.getImageModeParameters(imageMode);
            }
            if (imageModeName.equals("sprite")) {
                return "sprite:" + ImageModeHelper.getImageModeParameters(imageMode);
            }
            if (imageModeName.equals("sprite-resize")) {
                String imageModeParameters = imageMode[1];
                return "sprite:" + imageModeParameters.replace("," + ImageModeHelper.getNinePartParameters(imageModeParameters), "");
            }
            log.warning("imageMode property could not be converted to imageArea property : " + imageModeProperty);
        }
        return null;
    }

    public static String getRenderStrategyProperty(Properties properties) {
        return ImageModeHelper.getRenderStrategyProperty(new StringPropertyAdapter(properties));
    }

    public static String getRenderStrategyProperty(Map<String, String> properties) {
        String imageModeProperty = properties.get("imageMode");
        String property = ImageModeHelper.getRenderStrategyProperty(imageModeProperty);
        if (property != null) {
            log.info("imageMode property converted to renderStrategy property : " + imageModeProperty + " -> " + property);
            return property;
        }
        return properties.get("renderStrategy");
    }

    public static String getRenderStrategyProperty(String imageModeProperty) {
        if (imageModeProperty != null) {
            String[] imageMode = imageModeProperty.split(":");
            String imageModeName = imageMode[0];
            if (imageModeName.equals("normal") || imageModeName.equals("subImage") || imageModeName.equals("sprite")) {
                return "resize";
            }
            if (imageModeName.equals("subImageDirect")) {
                return "direct";
            }
            if (imageModeName.equals("resize")) {
                return "nine-part:" + ImageModeHelper.getImageModeParameters(imageMode);
            }
            if (imageModeName.equals("sprite-resize")) {
                return "nine-part:" + ImageModeHelper.getNinePartParameters(ImageModeHelper.getImageModeParameters(imageMode));
            }
            if (imageModeName.equals("repeat")) {
                return "repeat";
            }
            log.warning("imageMode property could not be converted to renderStrategy property : " + imageModeProperty);
        }
        return null;
    }

    private static String getImageModeParameters(String[] imageMode) {
        if (imageMode.length > 1) {
            return imageMode[1];
        }
        return "";
    }

    private static String getNinePartParameters(String imageMode) {
        String[] split = imageMode.split("(\\d+,){3}", 2);
        if (split.length > 1) {
            return split[1];
        }
        return "";
    }

    private static class StringPropertyAdapter
    implements Map<String, String> {
        private final Properties m_properties;

        public StringPropertyAdapter(Properties properties) {
            this.m_properties = properties;
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsKey(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsValue(Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<Map.Entry<String, String>> entrySet() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String get(Object key) {
            return this.m_properties.getProperty((String)key);
        }

        @Override
        public boolean isEmpty() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<String> keySet() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String put(String key, String value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAll(Map<? extends String, ? extends String> m) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String remove(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Collection<String> values() {
            throw new UnsupportedOperationException();
        }
    }
}

