/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.tools.pulsate;

import de.lessvoid.nifty.spi.time.TimeProvider;
import de.lessvoid.nifty.tools.pulsate.PulsatorProvider;
import de.lessvoid.nifty.tools.pulsate.provider.NullPulsator;
import de.lessvoid.nifty.tools.pulsate.provider.RectanglePulsator;
import de.lessvoid.nifty.tools.pulsate.provider.SinusPulsator;
import de.lessvoid.nifty.tools.pulsate.provider.SinusRaisedPulsator;
import java.util.Properties;
import java.util.logging.Logger;

public class Pulsator {
    private static Logger log = Logger.getLogger(Pulsator.class.getName());
    private TimeProvider timeProvider;
    private PulsatorProvider pulsateProvider;

    public Pulsator(Properties parameter, TimeProvider newTimeProvider) {
        this.timeProvider = newTimeProvider;
        String pulsateType = parameter.getProperty("pulsateType", "sin");
        if (pulsateType.equals("sin")) {
            this.pulsateProvider = new SinusPulsator();
        } else if (pulsateType.equals("sinRaised")) {
            this.pulsateProvider = new SinusRaisedPulsator();
        } else if (pulsateType.equals("rectangle")) {
            this.pulsateProvider = new RectanglePulsator();
        } else {
            log.warning(pulsateType + " is not supported, using NullPulsater for fallback. probably not what you want...");
            this.pulsateProvider = new NullPulsator();
        }
        this.pulsateProvider.initialize(parameter);
        this.reset();
    }

    public void reset() {
        this.pulsateProvider.reset(this.timeProvider.getMsTime());
    }

    public float update() {
        return this.pulsateProvider.getValue(this.timeProvider.getMsTime());
    }
}

