/*
 * Decompiled with CFR 0.152.
 */
package jogamp.common;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class Debug {
    private static boolean verbose;
    private static boolean debugAll;
    private static AccessControlContext localACC;
    public static final String jnlp_prefix = "jnlp.";

    static int getIntProperty(String property, boolean jnlpAlias) {
        return Debug.getIntProperty(property, jnlpAlias, localACC, 0);
    }

    public static int getIntProperty(String property, boolean jnlpAlias, AccessControlContext acc, int defaultValue) {
        int i = defaultValue;
        try {
            String sv = Debug.getProperty(property, jnlpAlias, acc);
            if (null != sv) {
                Integer iv = Integer.valueOf(sv);
                i = iv;
            }
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        return i;
    }

    public static long getLongProperty(String property, boolean jnlpAlias, AccessControlContext acc, long defaultValue) {
        long l = defaultValue;
        try {
            String sv = Debug.getProperty(property, jnlpAlias, acc);
            if (null != sv) {
                Long lv = Long.valueOf(sv);
                l = lv;
            }
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        return l;
    }

    static boolean getBooleanProperty(String property, boolean jnlpAlias) {
        return Debug.getBooleanProperty(property, jnlpAlias, localACC);
    }

    public static boolean getBooleanProperty(String property, boolean jnlpAlias, AccessControlContext acc) {
        Boolean b = Boolean.valueOf(Debug.getProperty(property, jnlpAlias, acc));
        return b;
    }

    static boolean isPropertyDefined(String property, boolean jnlpAlias) {
        return Debug.isPropertyDefined(property, jnlpAlias, localACC);
    }

    public static boolean isPropertyDefined(String property, boolean jnlpAlias, AccessControlContext acc) {
        return Debug.getProperty(property, jnlpAlias, acc) != null;
    }

    static String getProperty(String property, boolean jnlpAlias) {
        return Debug.getProperty(property, jnlpAlias, localACC);
    }

    public static String getProperty(final String property, final boolean jnlpAlias, AccessControlContext acc) {
        String s = null;
        if (null != acc && acc.equals(localACC)) {
            s = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    String val = null;
                    try {
                        val = System.getProperty(property);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (null == val && jnlpAlias && !property.startsWith(Debug.jnlp_prefix)) {
                        try {
                            val = System.getProperty(Debug.jnlp_prefix + property);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    return val;
                }
            });
        } else {
            try {
                s = System.getProperty(property);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (null == s && jnlpAlias && !property.startsWith(jnlp_prefix)) {
                try {
                    s = System.getProperty(jnlp_prefix + property);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return s;
    }

    public static boolean verbose() {
        return verbose;
    }

    public static boolean debugAll() {
        return debugAll;
    }

    public static boolean debug(String subcomponent) {
        return Debug.debugAll() || Debug.isPropertyDefined("jogamp.debug." + subcomponent, true);
    }

    static {
        localACC = AccessController.getContext();
        verbose = Debug.isPropertyDefined("jogamp.verbose", true);
        debugAll = Debug.isPropertyDefined("jogamp.debug", true);
    }
}

