/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.cpptasks.openwatcom;

import java.util.Vector;
import net.sf.antcontrib.cpptasks.types.LibraryTypeEnum;

public final class OpenWatcomProcessor {
    public static void addWarningSwitch(Vector args, int level) {
        switch (level) {
            case 0: {
                args.addElement("/w0");
                break;
            }
            case 1: {
                args.addElement("/w1");
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                args.addElement("/w2");
                break;
            }
            case 4: {
                args.addElement("/w3");
                break;
            }
            case 5: {
                args.addElement("/we");
                break;
            }
            default: {
                args.addElement("/w1");
            }
        }
    }

    public static String getCommandFileSwitch(String cmdFile) {
        StringBuffer buf = new StringBuffer("@");
        if (cmdFile.indexOf(32) >= 0) {
            buf.append('\"');
            buf.append(cmdFile.replace('/', '\\'));
            buf.append('\"');
        } else {
            buf.append(cmdFile);
        }
        return buf.toString();
    }

    public static void getDefineSwitch(StringBuffer buffer, String define, String value) {
        buffer.append("/d");
        buffer.append(define);
        if (value != null && value.length() > 0) {
            buffer.append('=');
            buffer.append(value);
        }
    }

    public static String getIncludeDirSwitch(String includeDir) {
        return "/i=" + includeDir.replace('/', '\\');
    }

    public static String[] getOutputFileSwitch(String outPath) {
        StringBuffer buf = new StringBuffer("/fo=");
        if (outPath.indexOf(32) >= 0) {
            buf.append('\"');
            buf.append(outPath);
            buf.append('\"');
        } else {
            buf.append(outPath);
        }
        String[] retval = new String[]{buf.toString()};
        return retval;
    }

    public static String[] getLibraryPatterns(String[] libnames, LibraryTypeEnum libType) {
        StringBuffer buf = new StringBuffer();
        String[] patterns = new String[libnames.length];
        for (int i = 0; i < libnames.length; ++i) {
            buf.setLength(0);
            buf.append(libnames[i]);
            buf.append(".lib");
            patterns[i] = buf.toString();
        }
        return patterns;
    }

    public static void getUndefineSwitch(StringBuffer buffer, String define) {
        buffer.append("/u");
        buffer.append(define);
    }

    public static boolean isCaseSensitive() {
        return false;
    }

    private OpenWatcomProcessor() {
    }
}

