/*
 * Decompiled with CFR 0.152.
 */
package jogamp.nativewindow.jawt.x11;

import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.AbstractGraphicsScreen;
import javax.media.nativewindow.NativeWindowException;
import javax.media.nativewindow.awt.AWTGraphicsDevice;
import javax.media.nativewindow.util.Point;
import jogamp.nativewindow.jawt.JAWT;
import jogamp.nativewindow.jawt.JAWTWindow;
import jogamp.nativewindow.jawt.JAWT_DrawingSurface;
import jogamp.nativewindow.jawt.JAWT_DrawingSurfaceInfo;
import jogamp.nativewindow.jawt.x11.JAWT_X11DrawingSurfaceInfo;
import jogamp.nativewindow.jawt.x11.X11SunJDKReflection;
import jogamp.nativewindow.x11.X11Util;

public class X11JAWTWindow
extends JAWTWindow {
    private JAWT_DrawingSurface ds;
    private boolean dsLocked;
    private JAWT_DrawingSurfaceInfo dsi;
    private JAWT_X11DrawingSurfaceInfo x11dsi;

    public X11JAWTWindow(Object object, AbstractGraphicsConfiguration abstractGraphicsConfiguration) {
        super(object, abstractGraphicsConfiguration);
    }

    @Override
    protected void validateNative() throws NativeWindowException {
        AbstractGraphicsDevice abstractGraphicsDevice;
        AWTGraphicsDevice aWTGraphicsDevice = (AWTGraphicsDevice)this.config.getScreen().getDevice();
        if (aWTGraphicsDevice.getHandle() != 0L) {
            return;
        }
        long l = 0L;
        AbstractGraphicsConfiguration abstractGraphicsConfiguration = null != this.config ? this.config.getNativeGraphicsConfiguration() : null;
        AbstractGraphicsScreen abstractGraphicsScreen = null != abstractGraphicsConfiguration ? abstractGraphicsConfiguration.getScreen() : null;
        AbstractGraphicsDevice abstractGraphicsDevice2 = abstractGraphicsDevice = null != abstractGraphicsScreen ? abstractGraphicsScreen.getDevice() : null;
        if (null != abstractGraphicsDevice) {
            l = abstractGraphicsDevice.getHandle();
        }
        if (0L == l) {
            l = X11SunJDKReflection.graphicsDeviceGetDisplay(aWTGraphicsDevice.getGraphicsDevice());
        }
        if (0L == l) {
            throw new InternalError("X11JAWTWindow: No X11 Display handle available");
        }
        aWTGraphicsDevice.setSubType("X11", l);
    }

    @Override
    protected int lockSurfaceImpl() throws NativeWindowException {
        int n = 3;
        this.ds = JAWT.getJAWT().GetDrawingSurface(this.component);
        if (this.ds == null) {
            this.unlockSurfaceImpl();
            return 1;
        }
        int n2 = this.ds.Lock();
        boolean bl = this.dsLocked = 0 == (n2 & 1);
        if (!this.dsLocked) {
            this.unlockSurfaceImpl();
            throw new NativeWindowException("Unable to lock surface");
        }
        if ((n2 & 8) != 0) {
            n = 2;
        }
        this.dsi = this.ds.GetDrawingSurfaceInfo();
        if (this.dsi == null) {
            this.unlockSurfaceImpl();
            return 1;
        }
        this.x11dsi = (JAWT_X11DrawingSurfaceInfo)this.dsi.platformInfo();
        if (this.x11dsi == null) {
            this.unlockSurfaceImpl();
            return 1;
        }
        this.drawable = this.x11dsi.getDrawable();
        if (this.drawable == 0L) {
            this.unlockSurfaceImpl();
            return 1;
        }
        this.updateBounds(this.dsi.getBounds());
        return n;
    }

    @Override
    protected void unlockSurfaceImpl() throws NativeWindowException {
        if (null != this.ds) {
            if (null != this.dsi) {
                this.ds.FreeDrawingSurfaceInfo(this.dsi);
            }
            if (this.dsLocked) {
                this.ds.Unlock();
            }
            JAWT.getJAWT().FreeDrawingSurface(this.ds);
        }
        this.ds = null;
        this.dsi = null;
        this.x11dsi = null;
    }

    @Override
    protected Point getLocationOnScreenImpl(int n, int n2) {
        return X11Util.GetRelativeLocation(this.getDisplayHandle(), this.getScreenIndex(), this.getWindowHandle(), 0L, n, n2);
    }
}

