/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.examples.defaultcontrols.common;

import de.lessvoid.nifty.builder.EffectBuilder;
import de.lessvoid.nifty.builder.PanelBuilder;
import de.lessvoid.nifty.controls.label.builder.LabelBuilder;

public class CommonBuilders {
    public EffectBuilder createMoveEffect(final String mode, final String direction, final int length) {
        return new EffectBuilder("move"){
            {
                super(x0);
                this.effectParameter("mode", mode);
                this.effectParameter("direction", direction);
                this.effectParameter("timeType", "exp");
                this.effectParameter("factor", "3.5");
                this.length(length);
                this.startDelay(0);
                this.inherit(true);
            }
        };
    }

    public EffectBuilder createFadeEffect() {
        return new EffectBuilder("fade"){
            {
                this.effectParameter("start", "#f");
                this.effectParameter("end", "#0");
                this.length(300);
                this.startDelay(300);
                this.inherit(true);
            }
        };
    }

    public PanelBuilder vspacer() {
        return new PanelBuilder(){
            {
                this.childLayoutHorizontal();
                this.height("9px");
                this.width("0px");
            }
        };
    }

    public PanelBuilder vspacer(final String height) {
        return new PanelBuilder(){
            {
                this.childLayoutHorizontal();
                this.height(height);
                this.width("100%");
            }
        };
    }

    public PanelBuilder hspacer(final String width) {
        return new PanelBuilder(){
            {
                this.width(width);
                this.height("0px");
            }
        };
    }

    public LabelBuilder createLabel(String text) {
        return this.createLabel(text, "100px");
    }

    public LabelBuilder createLabel(final String text, final String width) {
        return new LabelBuilder(){
            {
                this.text(text);
                this.width(width);
                this.alignLeft();
                this.textVAlignCenter();
                this.textHAlignLeft();
            }
        };
    }

    public LabelBuilder createLabel(String id, String text, final String width) {
        return new LabelBuilder(id, text){
            {
                super(x0, x1);
                this.width(width);
                this.alignLeft();
                this.textVAlignCenter();
                this.textHAlignLeft();
            }
        };
    }

    public LabelBuilder createShortLabel(String name, String width) {
        LabelBuilder result = this.createShortLabel(name);
        result.width(width);
        return result;
    }

    public LabelBuilder createShortLabel(final String name) {
        return new LabelBuilder(){
            {
                this.text(name);
                this.alignLeft();
                this.textVAlignCenter();
                this.textHAlignLeft();
            }
        };
    }
}

