/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls.chatcontrol;

import de.lessvoid.nifty.controls.ListBox;
import de.lessvoid.nifty.controls.chatcontrol.ChatEntryModelClass;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.elements.render.ImageRenderer;
import de.lessvoid.nifty.elements.render.TextRenderer;

public class ChatBoxViewConverter
implements ListBox.ListBoxViewConverter<ChatEntryModelClass> {
    private static final String CHAT_LINE_ICON = "#chat-line-icon";
    private static final String CHAT_LINE_TEXT = "#chat-line-text";

    @Override
    public final void display(Element listBoxItem, ChatEntryModelClass item) {
        Element text = listBoxItem.findElementByName(CHAT_LINE_TEXT);
        TextRenderer textRenderer = (TextRenderer)text.getRenderer(TextRenderer.class);
        Element icon = listBoxItem.findElementByName(CHAT_LINE_ICON);
        ImageRenderer iconRenderer = (ImageRenderer)icon.getRenderer(ImageRenderer.class);
        if (item != null) {
            textRenderer.setText(item.toString());
            iconRenderer.setImage(item.getIcon());
            if (item.getStyle() != null && !item.getStyle().equals("")) {
                text.setStyle(item.getStyle());
            } else {
                text.setStyle("default");
            }
        } else {
            textRenderer.setText("");
            iconRenderer.setImage(null);
        }
    }

    @Override
    public final int getWidth(Element listBoxItem, ChatEntryModelClass item) {
        Element text = listBoxItem.findElementByName(CHAT_LINE_TEXT);
        TextRenderer textRenderer = (TextRenderer)text.getRenderer(TextRenderer.class);
        Element icon = listBoxItem.findElementByName(CHAT_LINE_ICON);
        ImageRenderer iconRenderer = (ImageRenderer)icon.getRenderer(ImageRenderer.class);
        return (textRenderer.getFont() == null ? 0 : textRenderer.getFont().getWidth(item.getLabel())) + (item.getIcon() == null ? 0 : item.getIcon().getWidth());
    }
}

