/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.examples.progressbar;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.examples.LwjglInitHelper;
import de.lessvoid.nifty.examples.progressbar.ProgressbarControl;
import de.lessvoid.nifty.renderer.lwjgl.render.LwjglRenderDevice;
import de.lessvoid.nifty.sound.openal.OpenALSoundDevice;
import de.lessvoid.nifty.spi.input.InputSystem;
import de.lessvoid.nifty.spi.render.RenderDevice;
import de.lessvoid.nifty.spi.sound.SoundDevice;
import de.lessvoid.nifty.tools.TimeProvider;
import java.util.Date;

public class ProgressbarMain {
    private ProgressbarMain() {
    }

    public static void main(String[] args) {
        if (!LwjglInitHelper.initSubSystems("Nifty Hello World")) {
            System.exit(0);
        }
        Nifty nifty = new Nifty((RenderDevice)new LwjglRenderDevice(), (SoundDevice)new OpenALSoundDevice(), (InputSystem)LwjglInitHelper.getInputSystem(), new TimeProvider());
        nifty.fromXml("progressbar/progressbar.xml", "start");
        LwjglInitHelper.renderLoop(nifty, new RenderLoop(nifty));
        LwjglInitHelper.destroy();
    }

    private static final class RenderLoop
    implements LwjglInitHelper.RenderLoopCallback {
        private final Nifty nifty;
        private int progress = 0;
        private long start = new Date().getTime();

        private RenderLoop(Nifty nifty) {
            this.nifty = nifty;
        }

        @Override
        public void process() {
            long now = new Date().getTime();
            if (now - this.start > 50L) {
                this.start = now;
                ++this.progress;
                ((ProgressbarControl)this.nifty.getScreen("start").findControl("my-progress", ProgressbarControl.class)).setProgress((float)this.progress / 100.0f);
                if (this.progress >= 100) {
                    System.out.println("done");
                }
            }
        }
    }
}

