/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.examples.tutorial;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.effects.EffectImpl;
import de.lessvoid.nifty.effects.EffectProperties;
import de.lessvoid.nifty.effects.Falloff;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.render.NiftyImage;
import de.lessvoid.nifty.render.NiftyRenderEngine;
import de.lessvoid.nifty.tools.TimeProvider;
import java.util.Random;

public class BubblesEffect
implements EffectImpl {
    private Bubble[] bubbles = new Bubble[32];
    private int screenWidth;
    private int screenHeight;
    private Random random = new Random();
    private TimeProvider timeProvider = new TimeProvider();
    private NiftyImage niftyImage1;
    private NiftyImage niftyImage2;

    public void activate(Nifty nifty, Element element, EffectProperties parameter) {
        this.niftyImage1 = nifty.getRenderEngine().createImage("tutorial/bubble-64x64.png", true);
        this.niftyImage2 = nifty.getRenderEngine().createImage("tutorial/bubble-32x32.png", true);
        this.screenWidth = nifty.getCurrentScreen().getRootElement().getWidth();
        this.screenHeight = nifty.getCurrentScreen().getRootElement().getHeight();
        for (int i = 0; i < this.bubbles.length; ++i) {
            this.bubbles[i] = new Bubble(this.timeProvider.getMsTime());
        }
    }

    public void deactivate() {
        this.niftyImage1.dispose();
        this.niftyImage2.dispose();
    }

    public void execute(Element element, float effectTime, Falloff falloff, NiftyRenderEngine r) {
        for (Bubble bubble : this.bubbles) {
            bubble.update(this.timeProvider.getMsTime());
            bubble.render(r);
        }
    }

    private class Bubble {
        private static final int Y_MIN_1 = 100;
        private static final int Y_MIN_2 = 140;
        private static final int Y_MAX_1 = 628;
        private static final int Y_MAX_2 = 668;
        private int x;
        private int initialX;
        private int y;
        private int sizeX;
        private int sizeY;
        private long speed;
        private boolean enabled = true;
        private long startTime;
        private int speedX;
        private int dir;
        private int timeX;
        private int image;

        public Bubble(long startTime) {
            this.initPosition(startTime);
            this.y = BubblesEffect.this.screenHeight;
            this.speed = this.getNewSpeed();
            this.startTime = startTime + (long)BubblesEffect.this.random.nextInt((int)this.speed);
        }

        private int getNewSpeed() {
            return BubblesEffect.this.random.nextInt(5000) + 8000;
        }

        private void initPosition(long currentTime) {
            this.initialX = this.x = BubblesEffect.this.random.nextInt(BubblesEffect.this.screenWidth);
            this.speed = this.getNewSpeed();
            this.initWind();
            this.startTime = currentTime;
            this.image = BubblesEffect.this.random.nextInt(2);
            if (this.image == 0) {
                this.sizeX = 64;
                this.sizeY = 64;
            } else {
                this.sizeX = 32;
                this.sizeY = 32;
            }
            this.y = BubblesEffect.this.screenHeight;
        }

        private void initWind() {
            this.dir = BubblesEffect.this.random.nextInt(2) * -1;
            this.speedX = BubblesEffect.this.random.nextInt(150) + 150;
            this.timeX = BubblesEffect.this.random.nextInt(5000) + 2500;
        }

        public void update(long currentTime) {
            long time = currentTime - this.startTime;
            float t = this.getSinusValue(currentTime);
            this.x = (int)(t * (float)this.speedX * (float)this.dir + (float)this.initialX);
            float value = (float)(this.speed - time) / (float)this.speed;
            this.y = (int)((float)BubblesEffect.this.screenHeight * value);
            if (this.y < 100) {
                this.initPosition(currentTime);
                this.enabled = true;
            }
        }

        public void render(NiftyRenderEngine r) {
            if (this.enabled) {
                if (this.y < 100) {
                    return;
                }
                if (this.y < 140) {
                    r.setColorAlpha(1.0f - (140.0f - (float)this.y) / 40.0f);
                } else if (this.y > 628 && this.y < 668) {
                    float max = 628.0f;
                    r.setColorAlpha(1.0f - ((float)this.y - max) / 40.0f);
                } else {
                    if (this.y >= 668) {
                        return;
                    }
                    r.setColorAlpha(1.0f);
                }
                if (this.image == 0) {
                    r.renderImage(BubblesEffect.this.niftyImage1, this.x, this.y, this.sizeX, this.sizeY);
                } else {
                    r.renderImage(BubblesEffect.this.niftyImage2, this.x, this.y, this.sizeX, this.sizeY);
                }
            }
        }

        private float getSinusValue(long x) {
            return (float)((Math.sin(Math.PI * (double)x / (double)this.timeX) + 1.0) / 2.0);
        }
    }
}

