/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.cpptasks.ibm;

import java.io.File;
import java.util.Vector;
import net.sf.antcontrib.cpptasks.OptimizationEnum;
import net.sf.antcontrib.cpptasks.compiler.LinkType;
import net.sf.antcontrib.cpptasks.compiler.Linker;
import net.sf.antcontrib.cpptasks.gcc.GccCompatibleCCompiler;
import net.sf.antcontrib.cpptasks.ibm.VisualAgeLinker;
import org.apache.tools.ant.types.Environment;

public final class VisualAgeCCompiler
extends GccCompatibleCCompiler {
    private static final String[] headerExtensions = new String[]{".h", ".hpp", ".inl"};
    private static final String[] sourceExtensions = new String[]{".c", ".cc", ".cxx", ".cpp", ".i", ".s"};
    private static final VisualAgeCCompiler instance = new VisualAgeCCompiler("xlC", sourceExtensions, headerExtensions, false, null);
    private String identifier;
    private File[] includePath;

    public static VisualAgeCCompiler getInstance() {
        return instance;
    }

    private VisualAgeCCompiler(String command, String[] sourceExtensions, String[] headerExtensions, boolean newEnvironment, Environment env) {
        super(command, "-help", sourceExtensions, headerExtensions, false, null, newEnvironment, env);
    }

    public void addImpliedArgs(Vector args, boolean debug, boolean multithreaded, boolean exceptions, LinkType linkType, Boolean rtti, OptimizationEnum optimization) {
        args.addElement("-c");
        if (debug) {
            args.addElement("-g");
        }
        if (linkType.isSharedLibrary()) {
            args.addElement("-fpic");
        }
        if (rtti != null) {
            if (rtti.booleanValue()) {
                args.addElement("-qrtti=all");
            } else {
                args.addElement("-qnortti");
            }
        }
    }

    public void addWarningSwitch(Vector args, int level) {
        switch (level) {
            case 0: {
                args.addElement("-w");
                break;
            }
            case 1: {
                args.addElement("-qflag=s:s");
                break;
            }
            case 2: {
                args.addElement("-qflag=e:e");
                break;
            }
            case 3: {
                args.addElement("-qflag=w:w");
                break;
            }
            case 4: {
                args.addElement("-qflag=i:i");
                break;
            }
            case 5: {
                args.addElement("-qhalt=w:w");
            }
        }
    }

    public Linker getLinker(LinkType linkType) {
        return VisualAgeLinker.getInstance().getLinker(linkType);
    }

    public int getMaximumCommandLength() {
        return Integer.MAX_VALUE;
    }

    public String getIdentifier() {
        return "VisualAge compiler - unidentified version";
    }
}

