/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.cpptasks.trolltech;

import java.io.File;
import java.util.Vector;
import net.sf.antcontrib.cpptasks.CCTask;
import net.sf.antcontrib.cpptasks.OptimizationEnum;
import net.sf.antcontrib.cpptasks.VersionInfo;
import net.sf.antcontrib.cpptasks.compiler.CommandLineCompiler;
import net.sf.antcontrib.cpptasks.compiler.CommandLineCompilerConfiguration;
import net.sf.antcontrib.cpptasks.compiler.LinkType;
import net.sf.antcontrib.cpptasks.compiler.Linker;
import net.sf.antcontrib.cpptasks.compiler.Processor;
import net.sf.antcontrib.cpptasks.compiler.ProgressMonitor;
import net.sf.antcontrib.cpptasks.gcc.LdLinker;
import net.sf.antcontrib.cpptasks.parser.Parser;
import net.sf.antcontrib.cpptasks.trolltech.UserInterfaceParser;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Environment;

public final class UserInterfaceCompiler
extends CommandLineCompiler {
    private static final UserInterfaceCompiler INSTANCE = new UserInterfaceCompiler(false, null);

    public static UserInterfaceCompiler getInstance() {
        return INSTANCE;
    }

    private UserInterfaceCompiler(boolean newEnvironment, Environment env) {
        super("uic", "-version", new String[]{".ui"}, new String[0], ".h", false, null, newEnvironment, env);
    }

    protected void addImpliedArgs(Vector args, boolean debug, boolean multithreaded, boolean exceptions, LinkType linkType, Boolean rtti, OptimizationEnum optimization) {
    }

    protected void addWarningSwitch(Vector args, int level) {
    }

    public Processor changeEnvironment(boolean newEnvironment, Environment env) {
        return this;
    }

    protected Parser createParser(File source) {
        return new UserInterfaceParser();
    }

    protected int getArgumentCountPerInputFile() {
        return 3;
    }

    public String[] getOutputFileNames(String inputFile, VersionInfo versionInfo) {
        String baseName = this.getBaseOutputName(inputFile);
        return new String[]{baseName + ".h", baseName + ".cpp", "moc_" + baseName + ".cpp"};
    }

    protected String getInputFileArgument(File outputDir, String filename, int index) {
        switch (index) {
            case 0: {
                return "-o";
            }
            case 1: {
                String outputFileName = this.getOutputFileNames(filename, null)[0];
                return new File(outputDir, outputFileName).toString();
            }
            case 2: {
                return filename;
            }
        }
        return null;
    }

    public int getMaximumCommandLength() {
        return 1024;
    }

    protected int getMaximumInputFilesPerCommand() {
        return 1;
    }

    protected String getIncludeDirSwitch(String includeDir) {
        return "";
    }

    protected void getDefineSwitch(StringBuffer buffer, String define, String value) {
    }

    protected void getUndefineSwitch(StringBuffer buffer, String define) {
    }

    protected File[] getEnvironmentIncludePath() {
        return new File[0];
    }

    public Linker getLinker(LinkType type) {
        return LdLinker.getInstance();
    }

    public void compile(CCTask task, File outputDir, String[] sourceFiles, String[] args, String[] endArgs, boolean relentless, CommandLineCompilerConfiguration config, ProgressMonitor monitor) {
        BuildException exc = null;
        String[] thisSource = new String[1];
        String[] uicCommand = new String[args.length + endArgs.length + 4];
        uicCommand[0] = "uic";
        String[] uicImplCommand = new String[args.length + endArgs.length + 6];
        uicImplCommand[0] = "uic";
        String[] mocCommand = new String[args.length + endArgs.length + 4];
        mocCommand[0] = "moc";
        for (int i = 0; i < args.length; ++i) {
            uicCommand[i + 1] = args[i];
            uicImplCommand[i + 1] = args[i];
            mocCommand[i + i] = args[i];
        }
        uicCommand[args.length + 1] = "-o";
        uicImplCommand[args.length + 1] = "-o";
        mocCommand[args.length + 1] = "-o";
        int uicIndex = args.length + 4;
        int uicImplIndex = args.length + 6;
        int mocIndex = args.length + 4;
        for (int i = 0; i < endArgs.length; ++i) {
            uicCommand[uicIndex++] = endArgs[i];
            uicImplCommand[uicImplIndex++] = endArgs[i];
            mocCommand[mocIndex++] = endArgs[i];
        }
        for (int j = 0; j < sourceFiles.length; ++j) {
            uicIndex = args.length + 2;
            uicImplIndex = args.length + 2;
            mocIndex = args.length + 2;
            String[] outputFileNames = this.getOutputFileNames(sourceFiles[j], null);
            uicCommand[uicIndex++] = outputFileNames[0];
            uicCommand[uicIndex++] = sourceFiles[j];
            uicImplCommand[uicImplIndex++] = outputFileNames[1];
            uicImplCommand[uicImplIndex++] = "-impl";
            uicImplCommand[uicImplIndex++] = outputFileNames[0];
            uicImplCommand[uicImplIndex++] = sourceFiles[j];
            mocCommand[mocIndex++] = outputFileNames[2];
            mocCommand[mocIndex++] = outputFileNames[0];
            int retval = this.runCommand(task, outputDir, uicCommand);
            if (retval == 0 && (retval = this.runCommand(task, outputDir, uicImplCommand)) == 0) {
                retval = this.runCommand(task, outputDir, mocCommand);
            }
            if (monitor != null) {
                thisSource[0] = sourceFiles[j];
                monitor.progress(thisSource);
            }
            if (retval == 0 || exc != null) continue;
            exc = new BuildException(this.getCommand() + " failed with return code " + retval, task.getLocation());
            if (relentless) continue;
            throw exc;
        }
        if (exc != null) {
            throw exc;
        }
    }

    protected int getTotalArgumentLengthForInputFile(File outputDir, String inputFile) {
        String arg1 = this.getInputFileArgument(outputDir, inputFile, 1);
        String arg2 = this.getInputFileArgument(outputDir, inputFile, 2);
        return arg1.length() + arg2.length() + 4;
    }
}

