/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.cpptasks.compiler;

import net.sf.antcontrib.cpptasks.CCTask;
import net.sf.antcontrib.cpptasks.ProcessorDef;
import net.sf.antcontrib.cpptasks.TargetDef;
import net.sf.antcontrib.cpptasks.VersionInfo;
import net.sf.antcontrib.cpptasks.compiler.CaptureStreamHandler;
import net.sf.antcontrib.cpptasks.compiler.LinkType;
import net.sf.antcontrib.cpptasks.compiler.Linker;
import net.sf.antcontrib.cpptasks.compiler.Processor;
import net.sf.antcontrib.cpptasks.compiler.ProcessorConfiguration;
import org.apache.tools.ant.types.Environment;

public abstract class AbstractProcessor
implements Processor,
Cloneable {
    public static final int DEFAULT_DISCARD_BID = 1;
    public static final int DEFAULT_PROCESS_BID = 100;
    private final String[] headerExtensions;
    private final String[] sourceExtensions;

    protected static String getIdentifier(String[] command, String fallback) {
        String identifier = fallback;
        try {
            String[] cmdout = CaptureStreamHandler.run(command);
            if (cmdout.length > 0) {
                identifier = cmdout[0];
            }
        }
        catch (Throwable ex) {
            identifier = fallback + ":" + ex.toString();
        }
        return identifier;
    }

    protected AbstractProcessor(String[] sourceExtensions, String[] headerExtensions) {
        this.sourceExtensions = (String[])sourceExtensions.clone();
        this.headerExtensions = (String[])headerExtensions.clone();
    }

    public int bid(String inputFile) {
        int i;
        String lower = inputFile.toLowerCase();
        for (i = 0; i < this.sourceExtensions.length; ++i) {
            if (!lower.endsWith(this.sourceExtensions[i])) continue;
            return 100;
        }
        for (i = 0; i < this.headerExtensions.length; ++i) {
            if (!lower.endsWith(this.headerExtensions[i])) continue;
            return 1;
        }
        return 0;
    }

    public Processor changeEnvironment(boolean newEnvironment, Environment env) {
        return this;
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String[] getHeaderExtensions() {
        return (String[])this.headerExtensions.clone();
    }

    public abstract String getIdentifier();

    protected String getOSArch() {
        return System.getProperty("os.arch");
    }

    protected String getOSName() {
        return System.getProperty("os.name");
    }

    public String[] getSourceExtensions() {
        return (String[])this.sourceExtensions.clone();
    }

    protected boolean isDarwin() {
        String osName = this.getOSName();
        return "Mac OS X".equals(osName);
    }

    public final String toString() {
        return this.getIdentifier();
    }

    public abstract /* synthetic */ String[] getOutputFileNames(String var1, VersionInfo var2);

    public abstract /* synthetic */ Linker getLinker(LinkType var1);

    public abstract /* synthetic */ ProcessorConfiguration createConfiguration(CCTask var1, LinkType var2, ProcessorDef[] var3, ProcessorDef var4, TargetDef var5, VersionInfo var6);
}

