/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject.copylibstask;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Jar;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.FileUtils;

public class CopyLibs
extends Jar {
    private static final String LIB = "lib";
    Path runtimePath;
    static final /* synthetic */ boolean $assertionsDisabled;

    public void setRuntimeClassPath(Path path) {
        if (!$assertionsDisabled && path == null) {
            throw new AssertionError();
        }
        this.runtimePath = path;
    }

    public Path getRuntimeClassPath() {
        return this.runtimePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        if (this.runtimePath == null) {
            throw new BuildException("RuntimeClassPath must be set.");
        }
        String[] pathElements = this.runtimePath.list();
        File[] filesToCopy = new File[pathElements.length];
        for (int i = 0; i < pathElements.length; ++i) {
            File f = new File(pathElements[i]);
            if (f.isDirectory() || !f.canRead()) {
                filesToCopy = null;
                this.log(f.toString() + " is a directory or can't be read. Not copying the libraries.");
                break;
            }
            filesToCopy[i] = f;
        }
        super.execute();
        File destFile = this.getDestFile();
        File destFolder = destFile.getParentFile();
        if (!($assertionsDisabled || destFolder != null && destFolder.canWrite())) {
            throw new AssertionError();
        }
        try {
            ResourceBundle bundle = ResourceBundle.getBundle("org.netbeans.modules.java.j2seproject.copylibstask.Bundle");
            if (!$assertionsDisabled && bundle == null) {
                throw new AssertionError();
            }
            File readme = new File(destFolder, bundle.getString("TXT_README_FILE_NAME"));
            if (!readme.exists()) {
                readme.createNewFile();
            }
            PrintWriter out = new PrintWriter(new FileWriter(readme));
            try {
                String content = bundle.getString("TXT_README_FILE_CONTENT");
                out.println(MessageFormat.format(content, destFile.getName()));
            }
            finally {
                out.close();
            }
        }
        catch (IOException ioe) {
            this.log("Cannot generate readme file.", 3);
        }
        if (filesToCopy != null && filesToCopy.length > 0) {
            File libFolder = new File(destFolder, LIB);
            if (!libFolder.exists()) {
                libFolder.mkdir();
                this.log("Create lib folder " + libFolder.toString() + ".", 3);
            }
            if (!$assertionsDisabled && !libFolder.canWrite()) {
                throw new AssertionError();
            }
            FileUtils utils = FileUtils.getFileUtils();
            this.log("Copy libraries to " + libFolder.toString() + ".");
            for (int i = 0; i < filesToCopy.length; ++i) {
                this.log("Copy " + filesToCopy[i].getName() + " to " + libFolder + ".", 3);
                try {
                    File libFile = new File(libFolder, filesToCopy[i].getName());
                    utils.copyFile(filesToCopy[i], libFile);
                    continue;
                }
                catch (IOException ioe) {
                    throw new BuildException((Throwable)ioe);
                }
            }
        } else {
            this.log("Not copying the libraries.");
        }
    }

    static {
        $assertionsDisabled = !CopyLibs.class.desiredAssertionStatus();
    }
}

