/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls;

import de.lessvoid.nifty.controls.NiftyControl;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.elements.render.TextRenderer;
import java.util.List;
import java.util.logging.Logger;

public interface DropDown<T>
extends NiftyControl {
    public void setViewConverter(DropDownViewConverter<T> var1);

    public void addItem(T var1);

    public void insertItem(T var1, int var2);

    public int itemCount();

    public void clear();

    public void selectItemByIndex(int var1);

    public void selectItem(T var1);

    public T getSelection();

    public int getSelectedIndex();

    public void removeItemByIndex(int var1);

    public void removeItem(T var1);

    public List<T> getItems();

    public void addAllItems(List<T> var1);

    public void removeAllItems(List<T> var1);

    public static class SimpleDropDownViewConverter<T>
    implements DropDownViewConverter<T> {
        private Logger log = Logger.getLogger(SimpleDropDownViewConverter.class.getName());

        @Override
        public void display(Element element, T item) {
            TextRenderer renderer = (TextRenderer)element.getRenderer(TextRenderer.class);
            if (renderer == null) {
                this.log.warning("you're using the SimpleDropDownViewConverter but there is no TextRenderer on the element.You've probably changed the item template but did not provided your own DropDownViewConverter to the DropDown.");
                return;
            }
            if (item != null) {
                renderer.setText(item.toString());
            } else {
                renderer.setText("");
            }
        }

        @Override
        public int getWidth(Element element, T item) {
            TextRenderer renderer = (TextRenderer)element.getRenderer(TextRenderer.class);
            if (renderer == null) {
                this.log.warning("you're using the SimpleDropDownViewConverter but there is no TextRenderer on the element.You've probably changed the item template but did not provided your own DropDownViewConverter to the DropDown.");
                return 0;
            }
            return ((TextRenderer)element.getRenderer(TextRenderer.class)).getFont().getWidth(item.toString());
        }
    }

    public static interface DropDownViewConverter<T> {
        public void display(Element var1, T var2);

        public int getWidth(Element var1, T var2);
    }
}

