/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.examples.console;

import de.lessvoid.nifty.EndNotify;
import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.NiftyEventSubscriber;
import de.lessvoid.nifty.controls.Console;
import de.lessvoid.nifty.controls.ConsoleExecuteCommandEvent;
import de.lessvoid.nifty.effects.EffectEventId;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.input.NiftyInputEvent;
import de.lessvoid.nifty.input.NiftyInputMapping;
import de.lessvoid.nifty.input.mapping.DefaultInputMapping;
import de.lessvoid.nifty.screen.KeyInputHandler;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.nifty.screen.ScreenController;

public class ConsoleSameScreenStartScreen
implements ScreenController,
KeyInputHandler {
    private Nifty nifty;
    private Screen screen;
    private boolean consoleVisible = false;
    private boolean allowConsoleToggle = true;
    private Element oldFocusElement;
    private Element consoleElement;
    private Element consoleElementFocus;
    private Element consoleLayer;

    public void bind(Nifty newNifty, Screen newScreen) {
        this.nifty = newNifty;
        this.screen = newScreen;
        this.screen.addKeyboardInputHandler((NiftyInputMapping)new DefaultInputMapping(), (KeyInputHandler)this);
        this.consoleElement = this.screen.findElementByName("console");
        this.consoleElementFocus = this.consoleElement.findElementByName("#textInput");
        this.consoleLayer = this.screen.findElementByName("consoleLayer");
    }

    public void onStartScreen() {
        this.removeConsoleElementFromFocusHandler();
    }

    public void onEndScreen() {
    }

    public void back() {
        this.nifty.fromXml("all/intro.xml", "menu");
    }

    public boolean keyEvent(NiftyInputEvent inputEvent) {
        if (inputEvent == NiftyInputEvent.ConsoleToggle) {
            this.toggleConsole();
            return true;
        }
        return false;
    }

    @NiftyEventSubscriber(id="console")
    public void onConsoleCommand(String id, ConsoleExecuteCommandEvent command) {
        Console console = (Console)this.screen.findNiftyControl("console", Console.class);
        console.output("your input was: " + command.getCommandLine() + " [" + command.getArgumentCount() + " parameter(s)]");
        if ("exit".equals(command.getCommand())) {
            this.back();
        }
    }

    private void toggleConsole() {
        if (this.allowConsoleToggle) {
            this.allowConsoleToggle = false;
            if (this.consoleVisible) {
                this.closeConsole();
            } else {
                this.openConsole();
            }
        }
    }

    private void openConsole() {
        this.consoleLayer.showWithoutEffects();
        this.consoleLayer.startEffect(EffectEventId.onStartScreen, new EndNotify(){

            public void perform() {
                ConsoleSameScreenStartScreen.this.oldFocusElement = ConsoleSameScreenStartScreen.this.screen.getFocusHandler().getKeyboardFocusElement();
                ConsoleSameScreenStartScreen.this.addConsoleElementToFocusHandler();
                ConsoleSameScreenStartScreen.this.consoleElementFocus.setFocus();
                ConsoleSameScreenStartScreen.this.consoleVisible = true;
                ConsoleSameScreenStartScreen.this.allowConsoleToggle = true;
            }
        });
    }

    private void closeConsole() {
        this.consoleLayer.startEffect(EffectEventId.onEndScreen, new EndNotify(){

            public void perform() {
                ConsoleSameScreenStartScreen.this.consoleLayer.hideWithoutEffect();
                ConsoleSameScreenStartScreen.this.consoleVisible = false;
                ConsoleSameScreenStartScreen.this.allowConsoleToggle = true;
                if (ConsoleSameScreenStartScreen.this.oldFocusElement != null) {
                    ConsoleSameScreenStartScreen.this.oldFocusElement.setFocus();
                }
                ConsoleSameScreenStartScreen.this.removeConsoleElementFromFocusHandler();
            }
        });
    }

    private void addConsoleElementToFocusHandler() {
        if (this.screen.getFocusHandler().findElement(this.consoleElementFocus.getId()) == null) {
            this.screen.getFocusHandler().addElement(this.consoleElementFocus);
        }
    }

    private void removeConsoleElementFromFocusHandler() {
        this.screen.getFocusHandler().remove(this.consoleElementFocus);
    }
}

