/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.examples.defaultcontrols;

import de.lessvoid.nifty.EndNotify;
import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.NiftyEventSubscriber;
import de.lessvoid.nifty.controls.ButtonClickedEvent;
import de.lessvoid.nifty.controls.Console;
import de.lessvoid.nifty.controls.ConsoleCommands;
import de.lessvoid.nifty.controls.ConsoleExecuteCommandEvent;
import de.lessvoid.nifty.controls.DropDown;
import de.lessvoid.nifty.controls.DropDownSelectionChangedEvent;
import de.lessvoid.nifty.controls.SliderChangedEvent;
import de.lessvoid.nifty.effects.Effect;
import de.lessvoid.nifty.effects.EffectEventId;
import de.lessvoid.nifty.effects.impl.Move;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.elements.events.NiftyMousePrimaryClickedEvent;
import de.lessvoid.nifty.input.NiftyInputEvent;
import de.lessvoid.nifty.screen.KeyInputHandler;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.nifty.screen.ScreenController;
import de.lessvoid.nifty.tools.Color;
import java.awt.Desktop;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;

public class ControlsDemoScreenController
implements ScreenController,
KeyInputHandler {
    private static Logger logger = Logger.getLogger(ControlsDemoScreenController.class.getName());
    private static final Color HELP_COLOR = new Color("#aaaf");
    private Nifty nifty;
    private Screen screen;
    private Element consolePopup;
    private Element creditsPopup;
    private Console console;
    private ConsoleCommands consoleCommands;
    private Map<String, String> buttonToDialogMap = new Hashtable<String, String>();
    private List<String> buttonIdList = new ArrayList<String>();
    private String currentMenuButtonId;

    public ControlsDemoScreenController(String ... mapping) {
        if (mapping == null || mapping.length == 0 || mapping.length % 2 != 0) {
            logger.warning("expecting pairs of values that map menuButton IDs to dialog IDs");
        } else {
            for (int i = 0; i < mapping.length / 2; ++i) {
                String menuButtonId = mapping[i * 2 + 0];
                String dialogId = mapping[i * 2 + 1];
                this.buttonToDialogMap.put(menuButtonId, dialogId);
                this.buttonIdList.add(menuButtonId);
                if (i != 0) continue;
                this.currentMenuButtonId = menuButtonId;
            }
        }
    }

    public void bind(Nifty nifty, Screen screen) {
        this.nifty = nifty;
        this.screen = screen;
        this.creditsPopup = nifty.createPopup("creditsPopup");
        this.consolePopup = nifty.createPopup("consolePopup");
        this.console = (Console)this.consolePopup.findNiftyControl("console", Console.class);
        this.console.output("Humble Nifty Console Demonstration :)\nYou can toggle the console on/off with the F1 key\nEnter 'help' to show all available commands");
        this.consoleCommands = new ConsoleCommands(nifty, this.console);
        ShowCommand showCommand = new ShowCommand();
        this.consoleCommands.registerCommand("show ListBox", (ConsoleCommands.ConsoleCommand)showCommand);
        this.consoleCommands.registerCommand("show DropDown", (ConsoleCommands.ConsoleCommand)showCommand);
        this.consoleCommands.registerCommand("show TextField", (ConsoleCommands.ConsoleCommand)showCommand);
        this.consoleCommands.registerCommand("show Slider", (ConsoleCommands.ConsoleCommand)showCommand);
        this.consoleCommands.registerCommand("show ScrollPanel", (ConsoleCommands.ConsoleCommand)showCommand);
        this.consoleCommands.registerCommand("show ChatControl", (ConsoleCommands.ConsoleCommand)showCommand);
        this.consoleCommands.registerCommand("show DragAndDrop", (ConsoleCommands.ConsoleCommand)showCommand);
        NiftyCommand niftyCommand = new NiftyCommand();
        this.consoleCommands.registerCommand("nifty screen", (ConsoleCommands.ConsoleCommand)niftyCommand);
        HelpCommand helpCommand = new HelpCommand();
        this.consoleCommands.registerCommand("help", (ConsoleCommands.ConsoleCommand)helpCommand);
        ClearCommand clearCommand = new ClearCommand();
        this.consoleCommands.registerCommand("clear", (ConsoleCommands.ConsoleCommand)clearCommand);
        ExitCommand exitCommand = new ExitCommand();
        this.consoleCommands.registerCommand("exit", (ConsoleCommands.ConsoleCommand)exitCommand);
        this.consoleCommands.enableCommandCompletion(true);
        this.fillResolutionDropDown(screen);
    }

    public void onStartScreen() {
        this.screen.findElementByName(this.buttonToDialogMap.get(this.currentMenuButtonId)).show();
        this.screen.findElementByName(this.currentMenuButtonId).startEffect(EffectEventId.onCustom, null, "selected");
    }

    public void onEndScreen() {
    }

    public boolean keyEvent(NiftyInputEvent inputEvent) {
        if (inputEvent == NiftyInputEvent.ConsoleToggle) {
            if (this.screen.isActivePopup(this.consolePopup)) {
                this.nifty.closePopup(this.consolePopup.getId());
            } else {
                this.nifty.showPopup(this.screen, this.consolePopup.getId(), null);
            }
            return true;
        }
        return false;
    }

    public void openLink(String url) {
        if (!Desktop.isDesktopSupported()) {
            System.err.println("Desktop is not supported (Can't open link)");
            return;
        }
        Desktop desktop = Desktop.getDesktop();
        if (!desktop.isSupported(Desktop.Action.BROWSE)) {
            System.err.println("Desktop (BROWSE) is not supported (Can't open link)");
            return;
        }
        try {
            URI uri = new URI(url);
            desktop.browse(uri);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void modifyMoveEffect(EffectEventId effectEventId, Element element, String direction) {
        List moveEffects = element.findElementByName("#effectPanel").getEffects(effectEventId, Move.class);
        if (!moveEffects.isEmpty()) {
            ((Effect)moveEffects.get(0)).getParameters().put((Object)"direction", (Object)direction);
        }
    }

    @NiftyEventSubscriber(pattern="menuButton.*")
    public void onMenuButtonListBoxClick(String id, NiftyMousePrimaryClickedEvent clickedEvent) {
        if ("menuButtonCredits".equals(id)) {
            this.showCredits();
            return;
        }
        this.changeDialogTo(id);
    }

    private void showCredits() {
        this.nifty.showPopup(this.screen, this.creditsPopup.getId(), null);
    }

    @NiftyEventSubscriber(id="creditsBack")
    public void onCreditsBackClick(String id, ButtonClickedEvent event) {
        this.nifty.closePopup(this.creditsPopup.getId());
    }

    @NiftyEventSubscriber(id="resetScreenButton")
    public void onTestButtonClick(String id, ButtonClickedEvent clickedEvent) {
        this.screen.findElementByName(this.buttonToDialogMap.get(this.currentMenuButtonId)).hide(new EndNotify(){

            public void perform() {
                ControlsDemoScreenController.this.nifty.gotoScreen("demo");
            }
        });
    }

    private void changeDialogTo(String id) {
        if (!id.equals(this.currentMenuButtonId)) {
            int currentIndex = this.buttonIdList.indexOf(this.currentMenuButtonId);
            int nextIndex = this.buttonIdList.indexOf(id);
            Element nextElement = this.screen.findElementByName(this.buttonToDialogMap.get(id));
            this.modifyMoveEffect(EffectEventId.onShow, nextElement, currentIndex < nextIndex ? "right" : "left");
            nextElement.show();
            Element currentElement = this.screen.findElementByName(this.buttonToDialogMap.get(this.currentMenuButtonId));
            this.modifyMoveEffect(EffectEventId.onHide, currentElement, currentIndex < nextIndex ? "left" : "right");
            currentElement.hide();
            this.screen.findElementByName(this.currentMenuButtonId).stopEffect(EffectEventId.onCustom);
            this.screen.findElementByName(id).startEffect(EffectEventId.onCustom, null, "selected");
            this.currentMenuButtonId = id;
        }
    }

    @NiftyEventSubscriber(id="console")
    public void onConsoleEvent(String id, ConsoleExecuteCommandEvent executeCommandEvent) {
        System.out.println(executeCommandEvent.getCommandLine());
    }

    @NiftyEventSubscriber(id="resolutions")
    public void onResolution(String id, final DropDownSelectionChangedEvent<DisplayMode> event) {
        this.screen.findElementByName("whiteOverlay").startEffect(EffectEventId.onCustom, new EndNotify(){

            public void perform() {
                DisplayMode displayMode = (DisplayMode)event.getSelection();
                try {
                    Display.setDisplayMode((DisplayMode)displayMode);
                    GL11.glMatrixMode((int)5889);
                    GL11.glLoadIdentity();
                    GL11.glOrtho((double)0.0, (double)displayMode.getWidth(), (double)displayMode.getHeight(), (double)0.0, (double)-9999.0, (double)9999.0);
                    GL11.glMatrixMode((int)5888);
                    ControlsDemoScreenController.this.nifty.enableAutoScaling(1024, 768);
                    ControlsDemoScreenController.this.nifty.resolutionChanged();
                }
                catch (LWJGLException e) {
                    e.printStackTrace();
                }
            }
        }, "onResolutionStart");
    }

    @NiftyEventSubscriber(id="scale-resolution")
    public void onSliderChanged(String id, SliderChangedEvent sliderChangedEvent) {
        this.nifty.enableAutoScaling(1024, 768, sliderChangedEvent.getValue(), sliderChangedEvent.getValue());
    }

    private void fillResolutionDropDown(Screen screen) {
        try {
            DisplayMode currentMode = Display.getDisplayMode();
            ArrayList<DisplayMode> sorted = new ArrayList<DisplayMode>();
            DisplayMode[] modes = Display.getAvailableDisplayModes();
            for (int i = 0; i < modes.length; ++i) {
                DisplayMode mode = modes[i];
                if (mode.getBitsPerPixel() != 32 || mode.getFrequency() != currentMode.getFrequency()) continue;
                sorted.add(mode);
            }
            Collections.sort(sorted, new Comparator<DisplayMode>(){

                @Override
                public int compare(DisplayMode o1, DisplayMode o2) {
                    int widthCompare = Integer.valueOf(o1.getWidth()).compareTo(o2.getWidth());
                    if (widthCompare != 0) {
                        return widthCompare;
                    }
                    int heightCompare = Integer.valueOf(o1.getHeight()).compareTo(o2.getHeight());
                    if (heightCompare != 0) {
                        return heightCompare;
                    }
                    return o1.toString().compareTo(o2.toString());
                }
            });
            DropDown dropDown = (DropDown)screen.findNiftyControl("resolutions", DropDown.class);
            for (DisplayMode mode : sorted) {
                dropDown.addItem((Object)mode);
            }
            dropDown.selectItem((Object)currentMode);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class ClearCommand
    implements ConsoleCommands.ConsoleCommand {
        private ClearCommand() {
        }

        public void execute(String[] args) {
            ControlsDemoScreenController.this.console.clear();
        }
    }

    private class ExitCommand
    implements ConsoleCommands.ConsoleCommand {
        private ExitCommand() {
        }

        public void execute(String[] args) {
            ControlsDemoScreenController.this.console.output("good bye");
            ControlsDemoScreenController.this.nifty.closePopup(ControlsDemoScreenController.this.consolePopup.getId());
        }
    }

    private class HelpCommand
    implements ConsoleCommands.ConsoleCommand {
        private HelpCommand() {
        }

        public void execute(String[] args) {
            ControlsDemoScreenController.this.console.output("---------------------------", HELP_COLOR);
            ControlsDemoScreenController.this.console.output("Supported commands", HELP_COLOR);
            ControlsDemoScreenController.this.console.output("---------------------------", HELP_COLOR);
            for (String command : ControlsDemoScreenController.this.consoleCommands.getRegisteredCommands()) {
                ControlsDemoScreenController.this.console.output(command, HELP_COLOR);
            }
        }
    }

    private class NiftyCommand
    implements ConsoleCommands.ConsoleCommand {
        private NiftyCommand() {
        }

        public void execute(String[] args) {
            if (args.length != 2) {
                ControlsDemoScreenController.this.console.outputError("command argument error");
                return;
            }
            String param = args[1];
            if ("screen".equals(param)) {
                String screenDebugOutput = ControlsDemoScreenController.this.nifty.getCurrentScreen().debugOutput();
                ControlsDemoScreenController.this.console.output(screenDebugOutput);
                System.out.println(screenDebugOutput);
            } else {
                ControlsDemoScreenController.this.console.outputError("unknown parameter [" + args[1] + "]");
            }
        }
    }

    private class ShowCommand
    implements ConsoleCommands.ConsoleCommand {
        private ShowCommand() {
        }

        public void execute(String[] args) {
            if (args.length != 2) {
                ControlsDemoScreenController.this.console.outputError("command argument error");
                return;
            }
            String menuButtonId = "menuButton" + args[1];
            if (!ControlsDemoScreenController.this.buttonToDialogMap.containsKey(menuButtonId)) {
                ControlsDemoScreenController.this.console.outputError("'" + menuButtonId + "' is not a registered dialog.");
                return;
            }
            if (menuButtonId.equals(ControlsDemoScreenController.this.currentMenuButtonId)) {
                ControlsDemoScreenController.this.console.outputError("Hah! Already there! I'm smart... :>");
                return;
            }
            ControlsDemoScreenController.this.changeDialogTo(menuButtonId);
        }
    }
}

