/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.examples.defaultcontrols.listbox;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.NiftyEventSubscriber;
import de.lessvoid.nifty.controls.Button;
import de.lessvoid.nifty.controls.ButtonClickedEvent;
import de.lessvoid.nifty.controls.CheckBox;
import de.lessvoid.nifty.controls.CheckBoxStateChangedEvent;
import de.lessvoid.nifty.controls.Controller;
import de.lessvoid.nifty.controls.Label;
import de.lessvoid.nifty.controls.ListBox;
import de.lessvoid.nifty.controls.ListBoxSelectionChangedEvent;
import de.lessvoid.nifty.controls.TextField;
import de.lessvoid.nifty.controls.TextFieldChangedEvent;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.examples.defaultcontrols.common.JustAnExampleModelClass;
import de.lessvoid.nifty.input.NiftyInputEvent;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.xml.xpp3.Attributes;
import java.util.List;
import java.util.Properties;

public class ListBoxDialogController
implements Controller {
    private Screen screen;
    private ListBox<JustAnExampleModelClass> listBox;
    private ListBox<JustAnExampleModelClass> selectionListBox;
    private CheckBox multiSelectionCheckBox;
    private CheckBox disableSelectionCheckBox;
    private CheckBox forceSelectionCheckBox;
    private Button appendButton;
    private Button removeSelectionButton;
    private TextField addTextField;
    private Label selectedIndices;

    public void bind(Nifty nifty, Screen screen, Element element, Properties parameter, Attributes controlDefinitionAttributes) {
        this.screen = screen;
        this.listBox = this.getListBox("listBox");
        this.selectionListBox = this.getListBox("selectionListBox");
        this.addTextField = (TextField)screen.findNiftyControl("addTextField", TextField.class);
        this.multiSelectionCheckBox = (CheckBox)screen.findNiftyControl("multiSelectionCheckBox", CheckBox.class);
        this.disableSelectionCheckBox = (CheckBox)screen.findNiftyControl("disableSelectionCheckBox", CheckBox.class);
        this.forceSelectionCheckBox = (CheckBox)screen.findNiftyControl("forceSelectionCheckBox", CheckBox.class);
        this.appendButton = (Button)screen.findNiftyControl("appendButton", Button.class);
        this.removeSelectionButton = (Button)screen.findNiftyControl("removeSelectionButton", Button.class);
        this.selectedIndices = (Label)screen.findNiftyControl("selectedIndices", Label.class);
        this.listBox.addItem((Object)new JustAnExampleModelClass("You can add more lines to this ListBox."));
        this.listBox.addItem((Object)new JustAnExampleModelClass("Use the append button to do this."));
        this.multiSelectionCheckBox.uncheck();
        this.disableSelectionCheckBox.uncheck();
        this.forceSelectionCheckBox.uncheck();
        this.addTextField.setText("");
    }

    public void init(Properties parameter, Attributes controlDefinitionAttributes) {
        this.updateSelectedIndexLabel(this.listBox.getSelectedIndices());
        this.setAppendButtonState();
        this.setRemoveSelectionButtonState();
    }

    public void onStartScreen() {
    }

    public void onFocus(boolean getFocus) {
    }

    public boolean inputEvent(NiftyInputEvent inputEvent) {
        return false;
    }

    @NiftyEventSubscriber(pattern=".*CheckBox")
    public void onAllCheckBoxChanged(String id, CheckBoxStateChangedEvent event) {
        this.listBox.changeSelectionMode(this.getSelectionMode(), this.forceSelectionCheckBox.isChecked());
    }

    @NiftyEventSubscriber(id="listBox")
    public void onListBoxSelectionChanged(String id, ListBoxSelectionChangedEvent<JustAnExampleModelClass> changed) {
        this.selectionListBox.clear();
        this.selectionListBox.addAllItems(changed.getSelection());
        this.updateSelectedIndexLabel(changed.getSelectionIndices());
        this.setRemoveSelectionButtonState();
    }

    @NiftyEventSubscriber(id="addTextField")
    public void onAppendTextFieldChanged(String id, TextFieldChangedEvent event) {
        this.setAppendButtonState();
    }

    @NiftyEventSubscriber(id="addTextField")
    public void onAddTextFieldInputEvent(String id, NiftyInputEvent event) {
        if (NiftyInputEvent.SubmitText.equals((Object)event)) {
            this.appendButton.activate();
        }
    }

    @NiftyEventSubscriber(id="appendButton")
    public void onAppendButtonClicked(String id, ButtonClickedEvent event) {
        if (this.addTextField.getText().length() == 0) {
            return;
        }
        this.listBox.addItem((Object)new JustAnExampleModelClass(this.addTextField.getText()));
        this.listBox.showItemByIndex(this.listBox.itemCount() - 1);
    }

    @NiftyEventSubscriber(id="removeSelectionButton")
    public void onRemoveSelectionButtonClicked(String id, ButtonClickedEvent event) {
        if (!this.listBox.getSelection().isEmpty()) {
            this.listBox.removeAllItems(this.listBox.getSelection());
        }
    }

    private ListBox.SelectionMode getSelectionMode() {
        if (this.disableSelectionCheckBox.isChecked()) {
            return ListBox.SelectionMode.Disabled;
        }
        if (this.multiSelectionCheckBox.isChecked()) {
            return ListBox.SelectionMode.Multiple;
        }
        return ListBox.SelectionMode.Single;
    }

    private void setAppendButtonState() {
        if (this.addTextField.getText().isEmpty()) {
            this.appendButton.disable();
        } else {
            this.appendButton.enable();
        }
    }

    private void setRemoveSelectionButtonState() {
        if (this.selectionListBox.itemCount() == 0) {
            this.removeSelectionButton.disable();
        } else {
            this.removeSelectionButton.enable();
        }
    }

    private void updateSelectedIndexLabel(List<Integer> selectionIndices) {
        if (selectionIndices == null || selectionIndices.isEmpty()) {
            this.selectedIndices.setText("N/A");
            return;
        }
        StringBuffer text = new StringBuffer();
        boolean first = true;
        for (Integer i : selectionIndices) {
            if (first) {
                first = false;
                text.append(i);
                continue;
            }
            text.append(", ");
            text.append(i);
        }
        this.selectedIndices.setText(text.toString());
    }

    private ListBox<JustAnExampleModelClass> getListBox(String name) {
        return (ListBox)this.screen.findNiftyControl(name, ListBox.class);
    }
}

