/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.examples.menu;

import de.lessvoid.nifty.EndNotify;
import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.controls.Label;
import de.lessvoid.nifty.controls.Menu;
import de.lessvoid.nifty.controls.MenuItemActivatedEvent;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.nifty.screen.ScreenController;
import de.lessvoid.nifty.tools.SizeValue;
import org.bushe.swing.event.EventTopicSubscriber;

public class MenuStartScreen
implements ScreenController {
    private Nifty nifty;
    private Screen screen;
    private Element popup;

    public void bind(Nifty nifty, Screen screen) {
        this.nifty = nifty;
        this.screen = screen;
        this.createPopup();
    }

    public void onStartScreen() {
    }

    public void onEndScreen() {
    }

    private void createPopup() {
        this.popup = this.nifty.createPopup("niftyPopupMenu");
        Menu popupMenu = (Menu)this.popup.findNiftyControl("#menu", Menu.class);
        popupMenu.setWidth(new SizeValue("250px"));
        popupMenu.addMenuItem("MenuItem 1", "menu/listen.png", (Object)new ThisReallyCouldBeAnyClassYouWant("SomeId1", "You've clicked MenuItem 1"));
        popupMenu.addMenuItem("MenuItem 4000000000000000000", "menu/stop.png", (Object)new ThisReallyCouldBeAnyClassYouWant("SomeId2", "You've clicked a very odd MenuItem"));
        popupMenu.addMenuItemSeparator();
        popupMenu.addMenuItem("MenuItem 5", (Object)new ThisReallyCouldBeAnyClassYouWant("SomeId5", "You've clicked MenuItem 5 (Where is 3?)"));
        popupMenu.addMenuItem("MenuItem 6", (Object)new ThisReallyCouldBeAnyClassYouWant("SomeId6", "You've clicked MenuItem 6"));
        popupMenu.addMenuItemSeparator();
        popupMenu.addMenuItem("Exit", (Object)new ThisReallyCouldBeAnyClassYouWant("exit", "Good Bye! :)"));
    }

    public void showMenu() {
        this.nifty.showPopup(this.screen, this.popup.getId(), null);
        this.nifty.subscribe(this.screen, ((Menu)this.popup.findNiftyControl("#menu", Menu.class)).getId(), MenuItemActivatedEvent.class, (EventTopicSubscriber)new MenuItemActivatedEventSubscriber());
    }

    private class ThisReallyCouldBeAnyClassYouWant {
        public String key;
        public String text;

        public ThisReallyCouldBeAnyClassYouWant(String key, String text) {
            this.key = key;
            this.text = text;
        }
    }

    private class MenuItemActivatedEventSubscriber
    implements EventTopicSubscriber<MenuItemActivatedEvent> {
        private MenuItemActivatedEventSubscriber() {
        }

        public void onEvent(String id, MenuItemActivatedEvent event) {
            final ThisReallyCouldBeAnyClassYouWant item = (ThisReallyCouldBeAnyClassYouWant)event.getItem();
            Label label = (Label)MenuStartScreen.this.screen.findNiftyControl("textOut", Label.class);
            label.setText(item.text + " [" + item.key + "]");
            MenuStartScreen.this.nifty.closePopup(MenuStartScreen.this.popup.getId(), new EndNotify(){

                public void perform() {
                    if ("exit".equals(item.key)) {
                        MenuStartScreen.this.nifty.setAlternateKeyForNextLoadXml("fade");
                        MenuStartScreen.this.nifty.fromXml("all/intro.xml", "menu");
                    }
                }
            });
        }
    }
}

