/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.wizard.utils;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.netbeans.installer.product.Registry;
import org.netbeans.installer.product.components.Product;
import org.netbeans.installer.utils.LogManager;
import org.netbeans.installer.utils.ResourceUtils;
import org.netbeans.installer.utils.helper.DetailedStatus;
import org.netbeans.installer.utils.helper.swing.NbiDialog;
import org.netbeans.installer.utils.helper.swing.NbiScrollPane;
import org.netbeans.installer.utils.helper.swing.NbiTreeTable;
import org.netbeans.installer.utils.helper.swing.NbiTreeTableColumnCellRenderer;
import org.netbeans.installer.utils.helper.swing.NbiTreeTableModel;

public class InstallationDetailsDialog
extends NbiDialog {
    private NbiTreeTable detailsTreeTable;
    private NbiScrollPane detailsScrollPane;
    private static final String TITLE_INSTALLATION_DETAILS_KEY = "IDD.installation.details.label";
    private static final String TITLE_COMPONENTS_KEY = "IDD.component.label";
    private static final String TITLE_STATUS_KEY = "IDD.status.label";

    public InstallationDetailsDialog() {
        this.initComponents();
        this.initialize();
    }

    private void initialize() {
        this.setTitle(ResourceUtils.getString(InstallationDetailsDialog.class, TITLE_INSTALLATION_DETAILS_KEY));
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        this.detailsTreeTable = new NbiTreeTable(new InstallationDetailsTreeTableModel());
        this.detailsTreeTable.setShowVerticalLines(false);
        this.detailsTreeTable.setOpaque(false);
        this.detailsTreeTable.setTableHeader(null);
        this.detailsTreeTable.setRowHeight(this.detailsTreeTable.getRowHeight() + 4);
        this.detailsTreeTable.setIntercellSpacing(new Dimension(0, 0));
        this.detailsTreeTable.setTreeColumnCellRenderer(new InstallationDetailsTreeColumnCellRenderer(this.detailsTreeTable));
        this.detailsTreeTable.getColumnModel().getColumn(1).setMaxWidth(200);
        this.detailsTreeTable.getColumnModel().getColumn(1).setMinWidth(200);
        this.detailsTreeTable.getColumnModel().getColumn(1).setCellRenderer(new InstallationStatusCellRenderer());
        this.detailsTreeTable.setRowSelectionAllowed(false);
        this.detailsTreeTable.setColumnSelectionAllowed(false);
        this.detailsTreeTable.setCellSelectionEnabled(false);
        this.detailsScrollPane = new NbiScrollPane(this.detailsTreeTable);
        this.add((Component)this.detailsScrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(11, 11, 11, 11), 0, 0));
    }

    public static class InstallationDetailsTreeColumnCellRenderer
    extends NbiTreeTableColumnCellRenderer {
        private static final EmptyBorder EMPTY_BORDER = new EmptyBorder(0, 0, 0, 0);
        private static final EmptyBorder PADDED_BORDER = new EmptyBorder(0, 0, 0, 5);

        public InstallationDetailsTreeColumnCellRenderer(NbiTreeTable treeTable) {
            super(treeTable);
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            this.setOpaque(false);
            this.setForeground(this.treeTable.getForeground());
            this.setBackground(this.treeTable.getBackground());
            if (value instanceof Product) {
                Product component = (Product)value;
                this.setIcon(component.getIcon());
                this.setText(component.getDisplayName());
                this.setBorder(EMPTY_BORDER);
            } else {
                this.setIcon(null);
                this.setText(value != null ? value.toString() : "");
                this.setBorder(PADDED_BORDER);
            }
            return this;
        }
    }

    private static class InstallationDetailsTreeModel
    implements TreeModel {
        private List<Product> components = new ArrayList<Product>();
        private Map<Product, List<String>> propertiesMap = new HashMap<Product, List<String>>();
        private Object root = new Object();

        public InstallationDetailsTreeModel() {
            Registry registry = Registry.getInstance();
            this.components.addAll(registry.getProducts(DetailedStatus.INSTALLED_SUCCESSFULLY));
            this.components.addAll(registry.getProducts(DetailedStatus.INSTALLED_WITH_WARNINGS));
            this.components.addAll(registry.getProducts(DetailedStatus.FAILED_TO_INSTALL));
            this.components.addAll(registry.getProducts(DetailedStatus.UNINSTALLED_SUCCESSFULLY));
            this.components.addAll(registry.getProducts(DetailedStatus.UNINSTALLED_WITH_WARNINGS));
            this.components.addAll(registry.getProducts(DetailedStatus.FAILED_TO_UNINSTALL));
        }

        public Object getRoot() {
            return this.root;
        }

        public Object getChild(Object parent, int index) {
            if (parent.equals(this.root)) {
                return this.components.get(index);
            }
            if (parent instanceof Product) {
                this.initComponentProperties((Product)parent);
                return this.propertiesMap.get(parent).get(index);
            }
            return null;
        }

        public int getChildCount(Object parent) {
            if (parent.equals(this.root)) {
                return this.components.size();
            }
            if (parent instanceof Product) {
                this.initComponentProperties((Product)parent);
                return this.propertiesMap.get(parent).size();
            }
            return 0;
        }

        private void initComponentProperties(Product component) {
            List<String> properties = this.propertiesMap.get(component);
            if (properties == null) {
                properties = new ArrayList<String>();
                switch (component.getDetailedStatus()) {
                    case INSTALLED_WITH_WARNINGS: {
                        for (Throwable warning : component.getInstallationWarnings()) {
                            properties.add("<html><b>Warning:</b> " + warning.getMessage());
                        }
                    }
                    case INSTALLED_SUCCESSFULLY: {
                        properties.add("Installation location: " + component.getInstallationLocation());
                        break;
                    }
                    case FAILED_TO_INSTALL: {
                        properties.add("<html><b>Error:</b> " + component.getInstallationError().getMessage());
                        break;
                    }
                    case UNINSTALLED_WITH_WARNINGS: {
                        for (Throwable warning : component.getUninstallationWarnings()) {
                            properties.add("<html><b>Warning:</b> " + warning.getMessage());
                        }
                    }
                    case UNINSTALLED_SUCCESSFULLY: {
                        break;
                    }
                    case FAILED_TO_UNINSTALL: {
                        properties.add("<html><b>Error:</b> " + component.getUninstallationError().getMessage());
                        break;
                    }
                }
                this.propertiesMap.put(component, properties);
            }
        }

        public boolean isLeaf(Object node) {
            return !node.equals(this.root) && !(node instanceof Product);
        }

        public void valueForPathChanged(TreePath path, Object newValue) {
        }

        public int getIndexOfChild(Object parent, Object child) {
            LogManager.log(4, "getIndexOfChild");
            if (parent.equals(this.root)) {
                return this.components.indexOf(child);
            }
            String string = (String)child;
            if (string.startsWith("Installation Location: ")) {
                return 0;
            }
            if (string.startsWith("Disk space:")) {
                return 1;
            }
            return -1;
        }

        public void addTreeModelListener(TreeModelListener listener) {
        }

        public void removeTreeModelListener(TreeModelListener listener) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InstallationDetailsTreeTableModel
    extends NbiTreeTableModel {
        public InstallationDetailsTreeTableModel() {
            super(new InstallationDetailsTreeModel());
        }

        @Override
        public int getTreeColumnIndex() {
            return 0;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return ResourceUtils.getString(InstallationDetailsDialog.class, InstallationDetailsDialog.TITLE_COMPONENTS_KEY);
                }
                case 1: {
                    return ResourceUtils.getString(InstallationDetailsDialog.class, InstallationDetailsDialog.TITLE_STATUS_KEY);
                }
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int column) {
            return Object.class;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        @Override
        public Object getValueAt(int row, int column) {
            Object node = this.getTree().getPathForRow(row).getLastPathComponent();
            switch (column) {
                case 0: {
                    return node;
                }
                case 1: {
                    if (node instanceof Product) {
                        return ((Product)node).getDetailedStatus();
                    }
                    return null;
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
        }
    }

    public static class InstallationStatusCellRenderer
    extends JLabel
    implements TableCellRenderer {
        public InstallationStatusCellRenderer() {
            this.setBorder(new EmptyBorder(0, 5, 0, 5));
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setOpaque(false);
            this.setBackground(table.getBackground());
            this.setForeground(table.getForeground());
            this.setText(value instanceof DetailedStatus ? value.toString() : "");
            return this;
        }
    }
}

