/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.cpptasks.compiler;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import net.sf.antcontrib.cpptasks.CCTask;
import net.sf.antcontrib.cpptasks.CUtil;
import net.sf.antcontrib.cpptasks.CompilerDef;
import net.sf.antcontrib.cpptasks.OptimizationEnum;
import net.sf.antcontrib.cpptasks.ProcessorDef;
import net.sf.antcontrib.cpptasks.ProcessorParam;
import net.sf.antcontrib.cpptasks.TargetDef;
import net.sf.antcontrib.cpptasks.VersionInfo;
import net.sf.antcontrib.cpptasks.compiler.AbstractCompiler;
import net.sf.antcontrib.cpptasks.compiler.AbstractProcessor;
import net.sf.antcontrib.cpptasks.compiler.CommandLineCompilerConfiguration;
import net.sf.antcontrib.cpptasks.compiler.CompilerConfiguration;
import net.sf.antcontrib.cpptasks.compiler.LinkType;
import net.sf.antcontrib.cpptasks.compiler.ProgressMonitor;
import net.sf.antcontrib.cpptasks.types.CommandLineArgument;
import net.sf.antcontrib.cpptasks.types.UndefineArgument;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Environment;

public abstract class CommandLineCompiler
extends AbstractCompiler {
    private String command;
    private final Environment env;
    private String identifier;
    private String identifierArg;
    private boolean libtool;
    private CommandLineCompiler libtoolCompiler;
    private final boolean newEnvironment;

    protected CommandLineCompiler(String command, String identifierArg, String[] sourceExtensions, String[] headerExtensions, String outputSuffix, boolean libtool, CommandLineCompiler libtoolCompiler, boolean newEnvironment, Environment env) {
        super(sourceExtensions, headerExtensions, outputSuffix);
        this.command = command;
        if (libtool && libtoolCompiler != null) {
            throw new IllegalArgumentException("libtoolCompiler should be null when libtool is true");
        }
        this.libtool = libtool;
        this.libtoolCompiler = libtoolCompiler;
        this.identifierArg = identifierArg;
        this.newEnvironment = newEnvironment;
        this.env = env;
    }

    protected abstract void addImpliedArgs(Vector var1, boolean var2, boolean var3, boolean var4, LinkType var5, Boolean var6, OptimizationEnum var7);

    protected void addIncludes(String baseDirPath, File[] includeDirs, Vector args, Vector relativeArgs, StringBuffer includePathId) {
        for (int i = 0; i < includeDirs.length; ++i) {
            args.addElement(this.getIncludeDirSwitch(includeDirs[i].getAbsolutePath()));
            if (relativeArgs == null) continue;
            String relative = CUtil.getRelativePath(baseDirPath, includeDirs[i]);
            relativeArgs.addElement(this.getIncludeDirSwitch(relative));
            if (includePathId == null) continue;
            if (includePathId.length() == 0) {
                includePathId.append("/I");
            } else {
                includePathId.append(" /I");
            }
            includePathId.append(relative);
        }
    }

    protected abstract void addWarningSwitch(Vector var1, int var2);

    protected void buildDefineArguments(CompilerDef[] defs, Vector args) {
        UndefineArgument[] merged = defs[0].getActiveDefines();
        for (int i = 1; i < defs.length; ++i) {
            merged = UndefineArgument.merge(defs[i].getActiveDefines(), merged);
        }
        StringBuffer buf = new StringBuffer(30);
        for (int i = 0; i < merged.length; ++i) {
            buf.setLength(0);
            UndefineArgument current = merged[i];
            if (current.isDefine()) {
                this.getDefineSwitch(buf, current.getName(), current.getValue());
            } else {
                this.getUndefineSwitch(buf, current.getName());
            }
            args.addElement(buf.toString());
        }
    }

    public void compile(CCTask task, File outputDir, String[] sourceFiles, String[] args, String[] endArgs, boolean relentless, CommandLineCompilerConfiguration config, ProgressMonitor monitor) throws BuildException {
        int i;
        BuildException exc = null;
        String command = this.getCommand();
        int baseLength = command.length() + args.length + endArgs.length;
        if (this.libtool) {
            baseLength += 8;
        }
        for (i = 0; i < args.length; ++i) {
            baseLength += args[i].length();
        }
        for (i = 0; i < endArgs.length; ++i) {
            baseLength += endArgs[i].length();
        }
        if (baseLength > this.getMaximumCommandLength()) {
            throw new BuildException("Command line is over maximum length without specifying source file");
        }
        int maxInputFilesPerCommand = this.getMaximumInputFilesPerCommand();
        int argumentCountPerInputFile = this.getArgumentCountPerInputFile();
        int sourceIndex = 0;
        while (sourceIndex < sourceFiles.length) {
            int j;
            int firstFileNextExec;
            int cmdLength = baseLength;
            for (firstFileNextExec = sourceIndex; firstFileNextExec < sourceFiles.length && firstFileNextExec - sourceIndex < maxInputFilesPerCommand && (cmdLength += this.getTotalArgumentLengthForInputFile(outputDir, sourceFiles[firstFileNextExec])) < this.getMaximumCommandLength(); ++firstFileNextExec) {
            }
            if (firstFileNextExec == sourceIndex) {
                throw new BuildException("Extremely long file name, can't fit on command line");
            }
            int argCount = args.length + 1 + endArgs.length + (firstFileNextExec - sourceIndex) * argumentCountPerInputFile;
            if (this.libtool) {
                ++argCount;
            }
            String[] commandline = new String[argCount];
            int index = 0;
            if (this.libtool) {
                commandline[index++] = "libtool";
            }
            commandline[index++] = command;
            for (j = 0; j < args.length; ++j) {
                commandline[index++] = args[j];
            }
            for (j = sourceIndex; j < firstFileNextExec; ++j) {
                for (int k = 0; k < argumentCountPerInputFile; ++k) {
                    commandline[index++] = this.getInputFileArgument(outputDir, sourceFiles[j], k);
                }
            }
            for (j = 0; j < endArgs.length; ++j) {
                commandline[index++] = endArgs[j];
            }
            int retval = this.runCommand(task, outputDir, commandline);
            if (monitor != null) {
                String[] fileNames = new String[firstFileNextExec - sourceIndex];
                for (int j2 = 0; j2 < fileNames.length; ++j2) {
                    fileNames[j2] = sourceFiles[sourceIndex + j2];
                }
                monitor.progress(fileNames);
            }
            if (retval != 0 && exc == null) {
                exc = new BuildException(this.getCommand() + " failed with return code " + retval, task.getLocation());
                if (!relentless) {
                    throw exc;
                }
            }
            sourceIndex = firstFileNextExec;
        }
        if (exc != null) {
            throw exc;
        }
    }

    protected CompilerConfiguration createConfiguration(CCTask task, LinkType linkType, ProcessorDef[] baseDefs, CompilerDef specificDef, TargetDef targetPlatform, VersionInfo versionInfo) {
        int i;
        String baseDirPath;
        Vector<String> args = new Vector<String>();
        CompilerDef[] defaultProviders = new CompilerDef[baseDefs.length + 1];
        for (int i2 = 0; i2 < baseDefs.length; ++i2) {
            defaultProviders[i2 + 1] = (CompilerDef)baseDefs[i2];
        }
        defaultProviders[0] = specificDef;
        Vector<CommandLineArgument> cmdArgs = new Vector<CommandLineArgument>();
        for (int i3 = defaultProviders.length - 1; i3 >= 0; --i3) {
            CommandLineArgument[] commandArgs = defaultProviders[i3].getActiveProcessorArgs();
            for (int j = 0; j < commandArgs.length; ++j) {
                if (commandArgs[j].getLocation() == 0) {
                    args.addElement(commandArgs[j].getValue());
                    continue;
                }
                cmdArgs.addElement(commandArgs[j]);
            }
        }
        Vector<ProcessorParam> params = new Vector<ProcessorParam>();
        for (int i4 = defaultProviders.length - 1; i4 >= 0; --i4) {
            ProcessorParam[] paramArray = defaultProviders[i4].getActiveProcessorParams();
            for (int j = 0; j < paramArray.length; ++j) {
                params.add(paramArray[j]);
            }
        }
        if (targetPlatform != null) {
            ProcessorParam param = new ProcessorParam();
            param.setValue(targetPlatform.getDescription());
            param.setName("target");
            params.add(param);
        }
        ProcessorParam[] paramArray = params.toArray(new ProcessorParam[params.size()]);
        boolean multithreaded = specificDef.getMultithreaded(defaultProviders, 1);
        boolean debug = specificDef.getDebug(baseDefs, 0);
        boolean exceptions = specificDef.getExceptions(defaultProviders, 1);
        Boolean rtti = specificDef.getRtti(defaultProviders, 1);
        OptimizationEnum optimization = specificDef.getOptimization(defaultProviders, 1);
        this.addImpliedArgs(args, debug, multithreaded, exceptions, linkType, rtti, optimization);
        this.buildDefineArguments(defaultProviders, args);
        int warnings = specificDef.getWarnings(defaultProviders, 0);
        this.addWarningSwitch(args, warnings);
        Enumeration argEnum = cmdArgs.elements();
        int endCount = 0;
        while (argEnum.hasMoreElements()) {
            CommandLineArgument arg = (CommandLineArgument)argEnum.nextElement();
            switch (arg.getLocation()) {
                case 1: {
                    args.addElement(arg.getValue());
                    break;
                }
                case 2: {
                    ++endCount;
                }
            }
        }
        String[] endArgs = new String[endCount];
        argEnum = cmdArgs.elements();
        int index = 0;
        while (argEnum.hasMoreElements()) {
            CommandLineArgument arg = (CommandLineArgument)argEnum.nextElement();
            if (arg.getLocation() != 2) continue;
            endArgs[index++] = arg.getValue();
        }
        Vector relativeArgs = (Vector)args.clone();
        StringBuffer includePathIdentifier = new StringBuffer();
        File baseDir = specificDef.getProject().getBaseDir();
        try {
            baseDirPath = baseDir.getCanonicalPath();
        }
        catch (IOException ex) {
            baseDirPath = baseDir.toString();
        }
        Vector<String> includePath = new Vector<String>();
        Vector<String> sysIncludePath = new Vector<String>();
        for (int i5 = defaultProviders.length - 1; i5 >= 0; --i5) {
            int j;
            String[] incPath = defaultProviders[i5].getActiveIncludePaths();
            for (j = 0; j < incPath.length; ++j) {
                includePath.addElement(incPath[j]);
            }
            incPath = defaultProviders[i5].getActiveSysIncludePaths();
            for (j = 0; j < incPath.length; ++j) {
                sysIncludePath.addElement(incPath[j]);
            }
        }
        File[] incPath = new File[includePath.size()];
        for (int i6 = 0; i6 < includePath.size(); ++i6) {
            incPath[i6] = new File((String)includePath.elementAt(i6));
        }
        File[] sysIncPath = new File[sysIncludePath.size()];
        for (int i7 = 0; i7 < sysIncludePath.size(); ++i7) {
            sysIncPath[i7] = new File((String)sysIncludePath.elementAt(i7));
        }
        this.addIncludes(baseDirPath, incPath, args, relativeArgs, includePathIdentifier);
        this.addIncludes(baseDirPath, sysIncPath, args, null, null);
        StringBuffer buf = new StringBuffer(this.getIdentifier());
        for (i = 0; i < relativeArgs.size(); ++i) {
            buf.append(' ');
            buf.append(relativeArgs.elementAt(i));
        }
        for (i = 0; i < endArgs.length; ++i) {
            buf.append(' ');
            buf.append(endArgs[i]);
        }
        String configId = buf.toString();
        Object[] argArray = new String[args.size()];
        args.copyInto(argArray);
        boolean rebuild = specificDef.getRebuild(baseDefs, 0);
        File[] envIncludePath = this.getEnvironmentIncludePath();
        return new CommandLineCompilerConfiguration(this, configId, incPath, sysIncPath, envIncludePath, includePathIdentifier.toString(), (String[])argArray, paramArray, rebuild, endArgs);
    }

    protected int getArgumentCountPerInputFile() {
        return 1;
    }

    protected final String getCommand() {
        return this.command;
    }

    protected abstract void getDefineSwitch(StringBuffer var1, String var2, String var3);

    protected abstract File[] getEnvironmentIncludePath();

    public String getIdentifier() {
        if (this.identifier == null) {
            this.identifier = this.identifierArg == null ? AbstractProcessor.getIdentifier(new String[]{this.command}, this.command) : AbstractProcessor.getIdentifier(new String[]{this.command, this.identifierArg}, this.command);
        }
        return this.identifier;
    }

    protected abstract String getIncludeDirSwitch(String var1);

    protected String getInputFileArgument(File outputDir, String filename, int index) {
        if (filename.indexOf(32) >= 0) {
            StringBuffer buf = new StringBuffer("\"");
            buf.append(filename);
            buf.append("\"");
            return buf.toString();
        }
        return filename;
    }

    protected final boolean getLibtool() {
        return this.libtool;
    }

    public final CommandLineCompiler getLibtoolCompiler() {
        if (this.libtoolCompiler != null) {
            return this.libtoolCompiler;
        }
        return this;
    }

    public abstract int getMaximumCommandLength();

    protected int getMaximumInputFilesPerCommand() {
        return Integer.MAX_VALUE;
    }

    protected int getTotalArgumentLengthForInputFile(File outputDir, String inputFile) {
        return inputFile.length() + 1;
    }

    protected abstract void getUndefineSwitch(StringBuffer var1, String var2);

    protected int runCommand(CCTask task, File workingDir, String[] cmdline) throws BuildException {
        return CUtil.runCommand(task, workingDir, cmdline, this.newEnvironment, this.env);
    }

    protected final void setCommand(String command) {
        this.command = command;
    }
}

